/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.parlor.card.server;

import com.threerings.crowd.data.OccupantInfo;
import com.threerings.crowd.server.OccupantOp;
import com.threerings.parlor.card.data.Card;
import com.threerings.parlor.card.data.CardCodes;
import com.threerings.parlor.card.data.CardGameObject;
import com.threerings.parlor.card.data.Deck;
import com.threerings.parlor.card.data.Hand;
import com.threerings.parlor.card.server.CardGameSender;
import com.threerings.parlor.game.server.GameManager;
import com.threerings.parlor.turn.server.TurnGameManager;
import com.threerings.presents.data.ClientObject;

public class CardGameManager
extends GameManager
implements TurnGameManager,
CardCodes {
    protected CardGameObject _cardgameobj;
    protected int[] _oldPlayerOids;

    @Override
    protected void didStartup() {
        super.didStartup();
        this._cardgameobj = (CardGameObject)this._gameobj;
    }

    @Override
    public void turnWillStart() {
    }

    @Override
    public void turnDidStart() {
    }

    @Override
    public void turnDidEnd() {
    }

    @Override
    protected void gameDidEnd() {
        this._oldPlayerOids = (int[])this._playerOids.clone();
        super.gameDidEnd();
    }

    public void rematchGame() {
        if (this.gameWillRematch()) {
            this._playerOids = (int[])this._oldPlayerOids.clone();
            this.startGame();
        }
    }

    protected boolean gameWillRematch() {
        return true;
    }

    public Hand dealHand(Deck deck, int size, int playerIndex) {
        ClientObject clobj;
        if (deck.size() < size) {
            return null;
        }
        Hand hand = deck.dealHand(size);
        if (!this.isAI(playerIndex) && (clobj = (ClientObject)this._omgr.getObject(this._playerOids[playerIndex])) != null) {
            CardGameSender.sendHand(clobj, this._cardgameobj.getOid(), hand);
        }
        return hand;
    }

    public Hand[] dealHands(Deck deck, int size) {
        if (deck.size() < size * this._playerCount) {
            return null;
        }
        Hand[] hands = new Hand[this._playerCount];
        int ii = 0;
        while (ii < this._playerCount) {
            hands[ii] = this.dealHand(deck, size, ii);
            ++ii;
        }
        return hands;
    }

    public int getPlayerIndex(ClientObject client) {
        int[] oids = this._gameobj.state == 2 ? this._oldPlayerOids : this._playerOids;
        int oid = client.getOid();
        int ii = 0;
        while (ii < oids.length) {
            if (oids[ii] == oid) {
                return ii;
            }
            ++ii;
        }
        return -1;
    }

    public ClientObject getClientObject(int pidx) {
        if (this._playerOids[pidx] != 0) {
            return (ClientObject)this._omgr.getObject(this._playerOids[pidx]);
        }
        return null;
    }

    public void transferCardsBetweenPlayers(int fromPlayerIdx, int toPlayerIdx, Card[] cards) {
        ClientObject toClient;
        ClientObject fromClient = this.getClientObject(fromPlayerIdx);
        if (fromClient != null) {
            CardGameSender.sentCardsToPlayer(fromClient, toPlayerIdx, cards);
        }
        if ((toClient = this.getClientObject(toPlayerIdx)) != null) {
            CardGameSender.sendCardsFromPlayer(toClient, fromPlayerIdx, cards);
        }
        this.notifyCardsTransferred(fromPlayerIdx, toPlayerIdx, cards.length);
    }

    public void transferCardsBetweenPlayers(int[] toPlayerIndices, Card[][] cards) {
        int ii = 0;
        while (ii < this._playerCount) {
            ClientObject fromClient = this.getClientObject(ii);
            if (fromClient != null) {
                CardGameSender.sentCardsToPlayer(fromClient, toPlayerIndices[ii], cards[ii]);
            }
            ++ii;
        }
        ii = 0;
        while (ii < this._playerCount) {
            ClientObject toClient = this.getClientObject(toPlayerIndices[ii]);
            if (toClient != null) {
                CardGameSender.sendCardsFromPlayer(toClient, ii, cards[ii]);
            }
            this.notifyCardsTransferred(ii, toPlayerIndices[ii], cards[ii].length);
            ++ii;
        }
    }

    protected void notifyCardsTransferred(final int fromPlayerIdx, final int toPlayerIdx, final int cards) {
        final int senderOid = this._playerOids[fromPlayerIdx];
        final int receiverOid = this._playerOids[toPlayerIdx];
        OccupantOp op = new OccupantOp(){

            public void apply(OccupantInfo info) {
                ClientObject client;
                int oid = info.getBodyOid();
                if (oid != senderOid && oid != receiverOid && (client = (ClientObject)CardGameManager.this._omgr.getObject(oid)) != null) {
                    CardGameSender.cardsTransferredBetweenPlayers(client, fromPlayerIdx, toPlayerIdx, cards);
                }
            }
        };
        this.applyToOccupants(op);
    }
}

