/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.parlor.card.data;

import com.threerings.parlor.card.data.CardCodes;
import com.threerings.presents.dobj.DSet;
import com.threerings.util.ActionScript;

public class Card
implements DSet.Entry,
Comparable<Card>,
CardCodes {
    protected byte _value;
    @ActionScript(omit=true)
    protected transient Byte _key;

    public Card() {
    }

    public Card(int number, int suit) {
        this._value = (byte)(suit << 5 | number);
    }

    public int getNumber() {
        return this._value & 0x1F;
    }

    public int getSuit() {
        return this._value >> 5;
    }

    public boolean isNumber() {
        int number = this.getNumber();
        return number >= 2 && number <= 10;
    }

    public boolean isFace() {
        int number = this.getNumber();
        return number == 13 || number == 12 || number == 11;
    }

    public boolean isAce() {
        return this.getNumber() == 14;
    }

    public boolean isJoker() {
        int number = this.getNumber();
        return number == 15 || number == 16;
    }

    public boolean isValid() {
        int number = this.getNumber();
        int suit = this.getSuit();
        return number == 15 || number == 16 || number >= 2 && number <= 14 && suit >= 0 && suit <= 3;
    }

    public Comparable<?> getKey() {
        if (this._key == null) {
            this._key = this._value;
        }
        return this._key;
    }

    public int hashCode() {
        return this._value;
    }

    public boolean equals(Object other) {
        if (other instanceof Card) {
            return this._value == ((Card)other)._value;
        }
        return false;
    }

    @Override
    public int compareTo(Card other) {
        byte otherValue = other._value;
        if (this._value > otherValue) {
            return 1;
        }
        if (this._value < otherValue) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        int number = this.getNumber();
        if (number == 15) {
            return "RJ";
        }
        if (number == 16) {
            return "BJ";
        }
        StringBuilder sb = new StringBuilder();
        if (number >= 2 && number <= 9) {
            sb.append(Integer.toString(number));
        } else {
            switch (number) {
                case 10: {
                    sb.append('T');
                    break;
                }
                case 11: {
                    sb.append('J');
                    break;
                }
                case 12: {
                    sb.append('Q');
                    break;
                }
                case 13: {
                    sb.append('K');
                    break;
                }
                case 14: {
                    sb.append('A');
                    break;
                }
                default: {
                    sb.append('?');
                }
            }
        }
        switch (this.getSuit()) {
            case 0: {
                sb.append('s');
                break;
            }
            case 1: {
                sb.append('h');
                break;
            }
            case 2: {
                sb.append('c');
                break;
            }
            case 3: {
                sb.append('d');
                break;
            }
            default: {
                sb.append('?');
            }
        }
        return sb.toString();
    }
}

