/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.micasa.simulator.client;

import com.samskivert.util.Config;
import com.samskivert.util.RunQueue;
import com.threerings.crowd.chat.client.ChatDirector;
import com.threerings.crowd.client.LocationDirector;
import com.threerings.crowd.client.OccupantDirector;
import com.threerings.crowd.client.PlaceView;
import com.threerings.crowd.util.CrowdContext;
import com.threerings.micasa.client.MiCasaFrame;
import com.threerings.micasa.simulator.client.SimulatorClient;
import com.threerings.micasa.simulator.client.SimulatorFrame;
import com.threerings.micasa.util.MiCasaContext;
import com.threerings.parlor.client.ParlorDirector;
import com.threerings.parlor.util.ParlorContext;
import com.threerings.presents.client.Client;
import com.threerings.presents.dobj.DObjectManager;
import com.threerings.util.MessageManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JPanel;

public class SimpleClient
implements SimulatorClient {
    protected MiCasaContext _ctx;
    protected SimulatorFrame _frame;
    protected MessageManager _msgmgr;
    protected Config _config = new Config("micasa");
    protected Client _client;
    protected LocationDirector _locdir;
    protected OccupantDirector _occdir;
    protected ParlorDirector _pardtr;
    protected ChatDirector _chatdir;

    public SimpleClient(SimulatorFrame frame) throws IOException {
        this._ctx = this.createContext();
        this._client = new Client(null, RunQueue.AWT);
        this._msgmgr = new MessageManager(this.getMessageManagerPrefix());
        this._locdir = new LocationDirector((CrowdContext)this._ctx);
        this._occdir = new OccupantDirector((CrowdContext)this._ctx);
        this._pardtr = new ParlorDirector(this._ctx);
        this._chatdir = new ChatDirector((CrowdContext)this._ctx, null);
        this._frame = frame;
        this._frame.getFrame().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                if (SimpleClient.this._client.isLoggedOn()) {
                    SimpleClient.this._client.logoff(true);
                }
            }
        });
    }

    protected MiCasaContext createContext() {
        return new MiCasaContextImpl();
    }

    protected String getMessageManagerPrefix() {
        return "rsrc";
    }

    @Override
    public ParlorContext getParlorContext() {
        return this._ctx;
    }

    protected class MiCasaContextImpl
    implements MiCasaContext {
        protected MiCasaContextImpl() {
        }

        public Config getConfig() {
            return SimpleClient.this._config;
        }

        public Client getClient() {
            return SimpleClient.this._client;
        }

        public DObjectManager getDObjectManager() {
            return SimpleClient.this._client.getDObjectManager();
        }

        public LocationDirector getLocationDirector() {
            return SimpleClient.this._locdir;
        }

        public OccupantDirector getOccupantDirector() {
            return SimpleClient.this._occdir;
        }

        @Override
        public ParlorDirector getParlorDirector() {
            return SimpleClient.this._pardtr;
        }

        public ChatDirector getChatDirector() {
            return SimpleClient.this._chatdir;
        }

        @Override
        public MessageManager getMessageManager() {
            return SimpleClient.this._msgmgr;
        }

        public void setPlaceView(PlaceView view) {
            SimpleClient.this._frame.setPanel((JPanel)view);
        }

        public void clearPlaceView(PlaceView view) {
        }

        @Override
        public MiCasaFrame getFrame() {
            return (MiCasaFrame)((Object)SimpleClient.this._frame);
        }
    }
}

