/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.micasa.lobby.table;

import com.samskivert.swing.HGroupLayout;
import com.samskivert.swing.VGroupLayout;
import com.samskivert.swing.util.SwingUtil;
import com.threerings.crowd.client.PlaceView;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.micasa.Log;
import com.threerings.micasa.lobby.LobbyConfig;
import com.threerings.micasa.lobby.table.TableItem;
import com.threerings.micasa.lobby.table.TableLobbyObject;
import com.threerings.micasa.util.MiCasaContext;
import com.threerings.parlor.client.SeatednessObserver;
import com.threerings.parlor.client.TableConfigurator;
import com.threerings.parlor.client.TableDirector;
import com.threerings.parlor.client.TableObserver;
import com.threerings.parlor.data.Table;
import com.threerings.parlor.game.client.GameConfigurator;
import com.threerings.parlor.game.client.SwingGameConfigurator;
import com.threerings.parlor.game.data.GameConfig;
import com.threerings.presents.dobj.DObject;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TableListView
extends JPanel
implements PlaceView,
TableObserver,
ActionListener,
SeatednessObserver {
    protected MiCasaContext _ctx;
    protected LobbyConfig _config;
    protected TableDirector _tdtr;
    protected JPanel _matchList;
    protected JPanel _playList;
    protected TableConfigurator _tableFigger;
    protected GameConfigurator _figger;
    protected JButton _create;
    protected JLabel _pcount;

    public TableListView(MiCasaContext ctx, LobbyConfig config) {
        this._config = config;
        this._ctx = ctx;
        this._tdtr = new TableDirector(ctx, "tableSet", this);
        this._tdtr.addSeatednessObserver(this);
        HGroupLayout gl = new HGroupLayout(HGroupLayout.STRETCH);
        gl.setOffAxisPolicy(HGroupLayout.STRETCH);
        this.setLayout((LayoutManager)gl);
        VGroupLayout pgl = new VGroupLayout(VGroupLayout.STRETCH);
        pgl.setOffAxisPolicy(VGroupLayout.STRETCH);
        JPanel panel = new JPanel((LayoutManager)pgl);
        panel.add((Component)new JLabel("Pending tables"), VGroupLayout.FIXED);
        VGroupLayout mgl = new VGroupLayout(VGroupLayout.NONE);
        mgl.setOffAxisPolicy(VGroupLayout.STRETCH);
        mgl.setJustification(VGroupLayout.TOP);
        this._matchList = new JPanel((LayoutManager)mgl);
        this._matchList.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add(new JScrollPane(this._matchList));
        GameConfig gconfig = null;
        try {
            gconfig = config.getGameConfig();
            this._tableFigger = gconfig.createTableConfigurator();
            if (this._tableFigger == null) {
                Log.log.warning((Object)"Game config has not been set up to work with tables: it needs to return non-null from createTableConfigurator().", new Object[0]);
            }
            this._figger = gconfig.createConfigurator();
            this._tableFigger.init(this._ctx, this._figger);
            if (this._figger != null) {
                this._figger.init(this._ctx);
                this._figger.setGameConfig(gconfig);
                panel.add((Component)((SwingGameConfigurator)this._figger).getPanel(), VGroupLayout.FIXED);
            }
            this._create = new JButton("Create table");
            this._create.addActionListener(this);
            panel.add((Component)this._create, VGroupLayout.FIXED);
        }
        catch (Exception e) {
            Log.log.warning((Object)("Unable to create configurator interface [config=" + gconfig + "]."), new Object[]{e});
            panel.add((Component)new JLabel("Aiya! Can't create tables. Configuration borked."), VGroupLayout.FIXED);
        }
        this.add(panel);
        panel = new JPanel((LayoutManager)pgl);
        panel.add((Component)new JLabel("Games in progress"), VGroupLayout.FIXED);
        this._playList = new JPanel((LayoutManager)mgl);
        this._playList.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add(new JScrollPane(this._playList));
        this.add(panel);
    }

    public void willEnterPlace(PlaceObject place) {
        this._tdtr.setTableObject((DObject)place);
        TableLobbyObject tlobj = (TableLobbyObject)place;
        for (Table table : tlobj.tableSet) {
            this.tableAdded(table);
        }
    }

    public void didLeavePlace(PlaceObject place) {
        this._tdtr.clearTableObject();
        this._matchList.removeAll();
        this._playList.removeAll();
    }

    @Override
    public void tableAdded(Table table) {
        Log.log.info((Object)("Table added [table=" + table + "]."), new Object[0]);
        JPanel panel = table.inPlay() ? this._playList : this._matchList;
        panel.add(new TableItem(this._ctx, this._tdtr, table));
        SwingUtil.refresh((JComponent)panel);
    }

    @Override
    public void tableUpdated(Table table) {
        Log.log.info((Object)("Table updated [table=" + table + "]."), new Object[0]);
        TableItem item = this.getTableItem(table.tableId);
        if (item == null) {
            Log.log.warning((Object)("Received table updated notification for unknown table [table=" + table + "]."), new Object[0]);
            return;
        }
        item.tableUpdated(table);
        if (table.gameOid != -1 && item.getParent() == this._matchList) {
            this._matchList.remove(item);
            SwingUtil.refresh((JComponent)this._matchList);
            this._playList.add(item);
            SwingUtil.refresh((JComponent)this._playList);
        }
    }

    @Override
    public void tableRemoved(int tableId) {
        Log.log.info((Object)("Table removed [tableId=" + tableId + "]."), new Object[0]);
        TableItem item = this.getTableItem(tableId);
        if (item == null) {
            Log.log.warning((Object)("Received table removed notification for unknown table [tableId=" + tableId + "]."), new Object[0]);
            return;
        }
        JPanel panel = (JPanel)item.getParent();
        panel.remove(item);
        SwingUtil.refresh((JComponent)panel);
        item.tableRemoved();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this._tdtr.createTable(this._tableFigger.getTableConfig(), this._figger.getGameConfig());
    }

    @Override
    public void seatednessDidChange(boolean isSeated) {
        this._create.setEnabled(!isSeated);
    }

    protected TableItem getTableItem(int tableId) {
        TableItem child;
        int ccount = this._matchList.getComponentCount();
        int ii = 0;
        while (ii < ccount) {
            child = (TableItem)this._matchList.getComponent(ii);
            if (child.table.tableId == tableId) {
                return child;
            }
            ++ii;
        }
        ccount = this._playList.getComponentCount();
        ii = 0;
        while (ii < ccount) {
            child = (TableItem)this._playList.getComponent(ii);
            if (child.table.tableId == tableId) {
                return child;
            }
            ++ii;
        }
        return null;
    }
}

