/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.micasa.lobby;

import com.google.common.collect.Maps;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.micasa.Log;
import com.threerings.micasa.lobby.Lobby;
import com.threerings.micasa.lobby.LobbyService;
import com.threerings.micasa.util.MiCasaContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;

public class LobbySelector
extends JPanel
implements ActionListener,
LobbyService.CategoriesListener,
LobbyService.LobbiesListener {
    protected MiCasaContext _ctx;
    protected LobbyService _lservice;
    protected JComboBox _combo;
    protected JList _loblist;
    protected Map<String, DefaultListModel> _catlists = Maps.newHashMap();
    protected String _pendingCategory;
    protected static final String CAT_FIRST_ITEM = "<categories...>";

    public LobbySelector(MiCasaContext ctx) {
        this.setLayout(new BorderLayout());
        this._ctx = ctx;
        String[] options = new String[]{CAT_FIRST_ITEM};
        this._combo = new JComboBox<String>(options);
        this._combo.addActionListener(this);
        this.add((Component)this._combo, "North");
        this._loblist = new JList();
        this._loblist.setCellRenderer(new LobbyCellRenderer());
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Object item = LobbySelector.this._loblist.getSelectedValue();
                    LobbySelector.this.enterLobby((Lobby)((Object)item));
                }
            }
        };
        this._loblist.addMouseListener(ml);
        this.add((Component)this._loblist, "Center");
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._lservice = (LobbyService)this._ctx.getClient().requireService(LobbyService.class);
        this._lservice.getCategories(this);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String selcat;
        if (evt.getSource() == this._combo && !(selcat = (String)this._combo.getSelectedItem()).equals(CAT_FIRST_ITEM)) {
            this.selectCategory(selcat);
        }
    }

    @Override
    public void gotCategories(String[] categories) {
        String[] stringArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            String categorie = stringArray[n2];
            this._combo.addItem(categorie);
            ++n2;
        }
    }

    @Override
    public void gotLobbies(List<Lobby> lobbies) {
        DefaultListModel<Lobby> model = new DefaultListModel<Lobby>();
        for (Lobby lobby : lobbies) {
            model.addElement(lobby);
        }
        this._catlists.put(this._pendingCategory, model);
        this._combo.setSelectedItem(this._pendingCategory);
        this._pendingCategory = null;
    }

    public void requestFailed(String reason) {
        Log.log.info((Object)("Request failed [reason=" + reason + "]."), new Object[0]);
        this._pendingCategory = null;
    }

    protected void selectCategory(String category) {
        DefaultListModel model = this._catlists.get(category);
        if (model != null) {
            this._loblist.setModel(model);
        } else if (this._pendingCategory == null) {
            this._pendingCategory = category;
            this._lservice.getLobbies(category, this);
        } else {
            Log.log.info((Object)("Ignoring category select request because one is outstanding [pcat=" + this._pendingCategory + ", newcat=" + category + "]."), new Object[0]);
        }
    }

    protected void enterLobby(Lobby lobby) {
        PlaceObject plobj = this._ctx.getLocationDirector().getPlaceObject();
        if (plobj != null && plobj.getOid() == lobby.placeOid) {
            return;
        }
        this._ctx.getLocationDirector().moveTo(lobby.placeOid);
        Log.log.info((Object)("Entering lobby " + (Object)((Object)lobby) + "."), new Object[0]);
    }

    protected static class LobbyCellRenderer
    extends DefaultListCellRenderer {
        protected LobbyCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            value = ((Lobby)((Object)value)).name;
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

