/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.micasa.client;

import com.samskivert.util.Config;
import com.samskivert.util.RunQueue;
import com.threerings.crowd.chat.client.ChatDirector;
import com.threerings.crowd.client.LocationDirector;
import com.threerings.crowd.client.OccupantDirector;
import com.threerings.crowd.client.PlaceView;
import com.threerings.crowd.util.CrowdContext;
import com.threerings.micasa.client.ClientController;
import com.threerings.micasa.client.MiCasaFrame;
import com.threerings.micasa.util.MiCasaContext;
import com.threerings.parlor.client.ParlorDirector;
import com.threerings.presents.client.Client;
import com.threerings.presents.dobj.DObjectManager;
import com.threerings.util.MessageManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JPanel;

public class MiCasaClient {
    protected MiCasaContext _ctx;
    protected MiCasaFrame _frame;
    protected Config _config = new Config("micasa");
    protected Client _client;
    protected LocationDirector _locdir;
    protected OccupantDirector _occdir;
    protected ChatDirector _chatdir;
    protected ParlorDirector _pardtr;
    protected MessageManager _msgmgr;
    protected static final String MESSAGE_MANAGER_PREFIX = "rsrc.i18n";

    public void init(MiCasaFrame frame) throws IOException {
        this._ctx = this.createContextImpl();
        this.createContextServices();
        this._client.setServer("localhost", Client.DEFAULT_SERVER_PORTS);
        this._frame = frame;
        this._frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                if (MiCasaClient.this._client.isLoggedOn()) {
                    MiCasaClient.this._client.logoff(true);
                } else {
                    System.exit(0);
                }
            }
        });
        this._frame.setController(new ClientController(this._ctx, this._frame));
    }

    public MiCasaContext getContext() {
        return this._ctx;
    }

    protected MiCasaContext createContextImpl() {
        return new MiCasaContextImpl();
    }

    protected void createContextServices() throws IOException {
        this._client = new Client(null, RunQueue.AWT);
        this._locdir = new LocationDirector((CrowdContext)this._ctx);
        this._occdir = new OccupantDirector((CrowdContext)this._ctx);
        this._pardtr = new ParlorDirector(this._ctx);
        this._msgmgr = new MessageManager(MESSAGE_MANAGER_PREFIX);
        this._chatdir = new ChatDirector((CrowdContext)this._ctx, null);
    }

    protected class MiCasaContextImpl
    implements MiCasaContext {
        protected MiCasaContextImpl() {
        }

        public Client getClient() {
            return MiCasaClient.this._client;
        }

        public DObjectManager getDObjectManager() {
            return MiCasaClient.this._client.getDObjectManager();
        }

        public Config getConfig() {
            return MiCasaClient.this._config;
        }

        public LocationDirector getLocationDirector() {
            return MiCasaClient.this._locdir;
        }

        public OccupantDirector getOccupantDirector() {
            return MiCasaClient.this._occdir;
        }

        public ChatDirector getChatDirector() {
            return MiCasaClient.this._chatdir;
        }

        @Override
        public MessageManager getMessageManager() {
            return MiCasaClient.this._msgmgr;
        }

        @Override
        public ParlorDirector getParlorDirector() {
            return MiCasaClient.this._pardtr;
        }

        public void setPlaceView(PlaceView view) {
            MiCasaClient.this._frame.setPanel((JPanel)view);
        }

        public void clearPlaceView(PlaceView view) {
        }

        @Override
        public MiCasaFrame getFrame() {
            return MiCasaClient.this._frame;
        }
    }
}

