/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.micasa.client;

import com.samskivert.swing.util.SwingUtil;
import com.threerings.micasa.Log;
import com.threerings.micasa.client.MiCasaClient;
import com.threerings.micasa.client.MiCasaFrame;
import com.threerings.presents.client.Client;
import com.threerings.presents.client.ClientAdapter;
import com.threerings.presents.client.SessionObserver;
import com.threerings.presents.net.Credentials;
import com.threerings.presents.net.UsernamePasswordCreds;
import com.threerings.util.Name;
import java.applet.Applet;
import java.awt.Window;
import java.io.IOException;

public class MiCasaApplet
extends Applet {
    protected MiCasaClient _client;
    protected MiCasaFrame _frame;

    @Override
    public void init() {
        try {
            this._frame = new MiCasaFrame();
            this._client = new MiCasaClient();
            this._client.init(this._frame);
            Name username = new Name(this.requireParameter("username"));
            String authkey = this.requireParameter("authkey");
            String server = this.getCodeBase().getHost();
            Client client = this._client.getContext().getClient();
            client.setServer(server, Client.DEFAULT_SERVER_PORTS);
            client.setCredentials((Credentials)new UsernamePasswordCreds(username, authkey));
            client.addClientObserver((SessionObserver)new ClientAdapter(){

                public void clientDidLogoff(Client c) {
                    MiCasaApplet.this._frame.setVisible(false);
                }
            });
        }
        catch (IOException ioe) {
            Log.log.warning((Object)"Unable to create client.", new Object[]{ioe});
        }
    }

    protected String requireParameter(String name) throws IOException {
        String value = this.getParameter(name);
        if (value == null) {
            throw new IOException("Applet missing '" + name + "' parameter.");
        }
        return value;
    }

    @Override
    public void start() {
        if (this._client != null) {
            this._frame.setSize(800, 600);
            SwingUtil.centerWindow((Window)this._frame);
            this._frame.setVisible(true);
            this._client.getContext().getClient().logon();
        }
    }

    @Override
    public void stop() {
        if (this._client != null) {
            this._frame.setVisible(false);
            Client client = this._client.getContext().getClient();
            if (client.isLoggedOn()) {
                client.logoff(false);
            }
        }
    }
}

