/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.micasa.client;

import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.HGroupLayout;
import com.samskivert.swing.VGroupLayout;
import com.threerings.micasa.util.MiCasaContext;
import com.threerings.presents.client.Client;
import com.threerings.presents.client.ClientObserver;
import com.threerings.presents.client.LogonException;
import com.threerings.presents.client.SessionObserver;
import com.threerings.presents.net.Credentials;
import com.threerings.presents.net.UsernamePasswordCreds;
import com.threerings.util.MessageBundle;
import com.threerings.util.Name;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class LogonPanel
extends JPanel
implements ActionListener,
ClientObserver {
    protected MiCasaContext _ctx;
    protected MessageBundle _msgs;
    protected JTextField _username;
    protected JPasswordField _password;
    protected JButton _logon;
    protected JTextArea _status;

    public LogonPanel(MiCasaContext ctx) {
        this._ctx = ctx;
        this._msgs = this._ctx.getMessageManager().getBundle("micasa.logon");
        this.setLayout((LayoutManager)new VGroupLayout());
        JPanel box = new JPanel((LayoutManager)new VGroupLayout(VGroupLayout.NONE, VGroupLayout.STRETCH, 5, VGroupLayout.CENTER)){

            @Override
            public Dimension getPreferredSize() {
                Dimension psize = super.getPreferredSize();
                psize.width = Math.max(psize.width, 300);
                return psize;
            }
        };
        this.add(box);
        String tstr = null;
        try {
            tstr = System.getProperty("logon.title");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (tstr == null) {
            tstr = "Mi Casa!";
        }
        JLabel title = new JLabel(tstr, 0);
        title.setFont(new Font("Helvetica", 1, 24));
        box.add(title);
        JPanel bar = new JPanel((LayoutManager)new HGroupLayout(GroupLayout.STRETCH));
        bar.add((Component)new JLabel(this._msgs.get("m.username")), GroupLayout.FIXED);
        this._username = new JTextField();
        this._username.setActionCommand("skipToPassword");
        this._username.addActionListener(this);
        bar.add(this._username);
        box.add(bar);
        bar = new JPanel((LayoutManager)new HGroupLayout(GroupLayout.STRETCH));
        bar.add((Component)new JLabel(this._msgs.get("m.password")), GroupLayout.FIXED);
        this._password = new JPasswordField();
        this._password.setActionCommand("logon");
        this._password.addActionListener(this);
        bar.add(this._password);
        box.add(bar);
        HGroupLayout gl = new HGroupLayout(GroupLayout.NONE);
        gl.setJustification(GroupLayout.RIGHT);
        bar = new JPanel((LayoutManager)gl);
        this._logon = new JButton(this._msgs.get("m.logon"));
        this._logon.setActionCommand("logon");
        this._logon.addActionListener(this);
        bar.add(this._logon);
        box.add(bar);
        box.add(new JLabel(this._msgs.get("m.status")));
        this._status = new JTextArea(){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(10, 100);
            }
        };
        this._status.setEditable(false);
        JScrollPane scroller = new JScrollPane(this._status);
        box.add(scroller);
        this._ctx.getClient().addClientObserver((SessionObserver)this);
        this._username.requestFocusInWindow();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("skipToPassword")) {
            this._password.requestFocusInWindow();
        } else if (cmd.equals("logon")) {
            this.logon();
        } else {
            System.out.println("Unknown action event: " + cmd);
        }
    }

    public void clientWillLogon(Client client) {
    }

    public void clientDidLogon(Client client) {
        this._status.append(String.valueOf(this._msgs.get("m.logon_success")) + "\n");
    }

    public void clientDidLogoff(Client client) {
        this._status.append(String.valueOf(this._msgs.get("m.logged_off")) + "\n");
        this.setLogonEnabled(true);
    }

    public void clientDidClear(Client client) {
    }

    public void clientFailedToLogon(Client client, Exception cause) {
        String msg = cause instanceof LogonException ? MessageBundle.compose((String)"m.logon_failed", (Object)cause.getMessage()) : MessageBundle.tcompose((String)"m.logon_failed", (Object)cause.getMessage());
        this._status.append(String.valueOf(this._msgs.xlate(msg)) + "\n");
        this.setLogonEnabled(true);
    }

    public void clientObjectDidChange(Client client) {
    }

    public void clientConnectionFailed(Client client, Exception cause) {
        String msg = MessageBundle.tcompose((String)"m.connection_failed", (Object)cause.getMessage());
        this._status.append(String.valueOf(this._msgs.xlate(msg)) + "\n");
        this.setLogonEnabled(true);
    }

    public boolean clientWillLogoff(Client client) {
        return true;
    }

    protected void logon() {
        this.setLogonEnabled(false);
        Name username = new Name(this._username.getText().trim());
        String password = new String(this._password.getPassword()).trim();
        String server = this._ctx.getClient().getHostname();
        int port = this._ctx.getClient().getPorts()[0];
        String msg = MessageBundle.tcompose((String)"m.logging_on", (Object)server, (Object)String.valueOf(port));
        this._status.append(String.valueOf(this._msgs.xlate(msg)) + "\n");
        UsernamePasswordCreds creds = new UsernamePasswordCreds(username, password);
        Client client = this._ctx.getClient();
        client.setCredentials((Credentials)creds);
        client.logon();
    }

    protected void setLogonEnabled(boolean enabled) {
        this._username.setEnabled(enabled);
        this._password.setEnabled(enabled);
        this._logon.setEnabled(enabled);
    }
}

