/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.whirled.zone.server;

import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.data.PlaceConfig;
import com.threerings.crowd.server.LocationManager;
import com.threerings.presents.data.InvocationException;
import com.threerings.whirled.data.SceneModel;
import com.threerings.whirled.data.SceneUpdate;
import com.threerings.whirled.server.AbstractSceneMoveHandler;
import com.threerings.whirled.server.SceneManager;
import com.threerings.whirled.server.SceneRegistry;
import com.threerings.whirled.zone.Log;
import com.threerings.whirled.zone.client.ZoneService;
import com.threerings.whirled.zone.data.ZoneSummary;
import com.threerings.whirled.zone.data.ZonedBodyObject;
import com.threerings.whirled.zone.server.ZoneManager;

public class ZoneMoveHandler
extends AbstractSceneMoveHandler
implements ZoneManager.ResolutionListener {
    protected ZoneManager _zmgr;
    protected SceneRegistry _screg;
    protected int _sceneId;
    protected int _version;
    protected ZoneSummary _summary;

    public ZoneMoveHandler(LocationManager locmgr, ZoneManager zmgr, SceneRegistry screg, BodyObject body, int sceneId, int sceneVer, ZoneService.ZoneMoveListener listener) {
        super(locmgr, body, listener);
        this._zmgr = zmgr;
        this._screg = screg;
        this._sceneId = sceneId;
        this._version = sceneVer;
    }

    @Override
    public void zoneWasResolved(ZoneSummary summary) {
        String errmsg = this._zmgr.ratifyBodyEntry(this._body, summary.zoneId);
        if (errmsg != null) {
            this._listener.requestFailed(errmsg);
            return;
        }
        this._summary = summary;
        this.resolveScene();
    }

    @Override
    public void zoneFailedToResolve(int zoneId, Exception reason) {
        Log.log.warning((Object)("Unable to resolve zone [zoneId=" + zoneId + ", reason=" + reason + "]."), new Object[0]);
        this._listener.requestFailed("m.no_such_zone");
    }

    @Override
    protected void effectSceneMove(SceneManager scmgr) throws InvocationException {
        int ploid = scmgr.getPlaceObject().getOid();
        PlaceConfig config = this._locman.moveTo(this._body, ploid);
        ((ZonedBodyObject)this._body).setZoneId(this._summary.zoneId);
        ZoneService.ZoneMoveListener listener = (ZoneService.ZoneMoveListener)this._listener;
        SceneModel model = scmgr.getScene().getSceneModel();
        if (this._version != model.version) {
            SceneUpdate[] updates = null;
            if (this._version < model.version) {
                updates = scmgr.getUpdates(this._version);
            }
            if (updates != null) {
                listener.moveSucceededWithUpdates(ploid, config, this._summary, updates);
            } else {
                listener.moveSucceededWithScene(ploid, config, this._summary, model);
            }
        } else {
            listener.moveSucceeded(ploid, config, this._summary);
        }
        this._zmgr.bodyDidEnterZone(this._body, this._summary.zoneId);
    }

    protected void resolveScene() {
        this._screg.resolveScene(this._sceneId, this);
    }
}

