/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.whirled.spot.client;

import com.samskivert.util.ResultListener;
import com.threerings.crowd.chat.client.ChatDirector;
import com.threerings.crowd.client.LocationAdapter;
import com.threerings.crowd.client.LocationDirector;
import com.threerings.crowd.client.LocationObserver;
import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.data.PlaceConfig;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.presents.client.BasicDirector;
import com.threerings.presents.client.Client;
import com.threerings.presents.client.InvocationService;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.dobj.AttributeChangeListener;
import com.threerings.presents.dobj.AttributeChangedEvent;
import com.threerings.presents.dobj.ChangeListener;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.ObjectAccessException;
import com.threerings.presents.dobj.Subscriber;
import com.threerings.presents.util.PresentsContext;
import com.threerings.whirled.client.SceneDirector;
import com.threerings.whirled.data.SceneModel;
import com.threerings.whirled.data.ScenePlace;
import com.threerings.whirled.data.SceneUpdate;
import com.threerings.whirled.spot.Log;
import com.threerings.whirled.spot.client.SpotService;
import com.threerings.whirled.spot.data.ClusteredBodyObject;
import com.threerings.whirled.spot.data.Location;
import com.threerings.whirled.spot.data.Portal;
import com.threerings.whirled.spot.data.SpotCodes;
import com.threerings.whirled.spot.data.SpotScene;
import com.threerings.whirled.util.WhirledContext;

public class SpotSceneDirector
extends BasicDirector
implements SpotCodes,
Subscriber<DObject>,
AttributeChangeListener {
    protected WhirledContext _ctx;
    protected SpotService _sservice;
    protected SceneDirector _scdir;
    protected ClusteredBodyObject _self;
    protected ChatDirector _chatdir;
    protected Location _location;
    protected Location _pendingLoc;
    protected DObject _clobj;

    public SpotSceneDirector(WhirledContext ctx, LocationDirector locdir, SceneDirector scdir) {
        super((PresentsContext)ctx);
        this._ctx = ctx;
        this._scdir = scdir;
        locdir.addLocationObserver((LocationObserver)new LocationAdapter(){

            public void locationDidChange(PlaceObject place) {
                SpotSceneDirector.this.handleDeparture();
            }
        });
    }

    public void setChatDirector(ChatDirector chatdir) {
        this._chatdir = chatdir;
    }

    public Location getIntendedLocation() {
        return this._pendingLoc != null ? this._pendingLoc : this._location;
    }

    public boolean traversePortal(int portalId) {
        return this.traversePortal(portalId, null);
    }

    public boolean traversePortal(int portalId, ResultListener<PlaceConfig> rl) {
        int clSceneId;
        SpotScene scene = (SpotScene)((Object)this._scdir.getScene());
        if (scene == null) {
            Log.log.warning((Object)"Requested to traverse portal when we have no scene", new Object[]{"portalId", portalId});
            return false;
        }
        int sceneId = this._scdir.getScene().getId();
        if (sceneId != (clSceneId = ScenePlace.getSceneId((BodyObject)this._ctx.getClient().getClientObject()))) {
            Log.log.warning((Object)"Client and server differ in opinion of what scene we're in", new Object[]{"sSceneId", clSceneId, "cSceneId", sceneId});
            return false;
        }
        Portal dest = scene.getPortal(portalId);
        if (dest == null) {
            Log.log.warning((Object)"Requested to traverse non-existent portal", new Object[]{"portalId", portalId, "portals", scene.getPortals()});
            return false;
        }
        if (!this._scdir.prepareMoveTo(dest.targetSceneId, rl)) {
            Log.log.info((Object)"Portal traversal vetoed by scene director", new Object[]{"portalId", portalId});
            return false;
        }
        int sceneVer = 0;
        SceneModel pendingModel = this._scdir.getPendingModel();
        if (pendingModel != null) {
            sceneVer = pendingModel.version;
        }
        Log.log.info((Object)("Issuing traversePortal(" + sceneId + ", " + dest + ", " + sceneVer + ")."), new Object[0]);
        this._sservice.traversePortal(sceneId, portalId, sceneVer, new SpotService.SpotSceneMoveListener(){

            public void requestFailed(String cause) {
                SpotSceneDirector.this._scdir.requestFailed(cause);
            }

            @Override
            public void moveSucceeded(int placeId, PlaceConfig config) {
                SpotSceneDirector.this._scdir.moveSucceeded(placeId, config);
            }

            @Override
            public void moveSucceededWithUpdates(int placeId, PlaceConfig config, SceneUpdate[] updates) {
                SpotSceneDirector.this._scdir.moveSucceededWithUpdates(placeId, config, updates);
            }

            @Override
            public void moveSucceededWithScene(int placeId, PlaceConfig config, SceneModel model) {
                SpotSceneDirector.this._scdir.moveSucceededWithScene(placeId, config, model);
            }

            @Override
            public void moveRequiresServerSwitch(String hostname, int[] ports) {
                SpotSceneDirector.this._scdir.moveRequiresServerSwitch(hostname, ports);
            }

            @Override
            public void requestCancelled() {
                SpotSceneDirector.this._scdir.cancelMoveRequest();
            }
        });
        return true;
    }

    public void changeLocation(Location loc, final ResultListener<Location> listener) {
        if (loc.equivalent(this._location)) {
            Log.log.info((Object)("Not going to " + loc + "; we're at " + this._location + " and we're headed to " + this._pendingLoc + "."), new Object[0]);
            if (listener != null) {
                listener.requestCompleted((Object)this._location);
            }
            return;
        }
        if (this._pendingLoc != null) {
            Log.log.info((Object)("Not going to " + loc + "; we're at " + this._location + " and we're headed to " + this._pendingLoc + "."), new Object[0]);
            if (listener != null) {
                listener.requestCompleted((Object)this._pendingLoc);
            }
            return;
        }
        SpotScene scene = (SpotScene)((Object)this._scdir.getScene());
        if (scene == null) {
            Log.log.warning((Object)"Requested to change locations, but we're not currently in any scene", new Object[]{"loc", loc});
            if (listener != null) {
                listener.requestFailed(new Exception("m.cant_get_there"));
            }
            return;
        }
        int sceneId = this._scdir.getScene().getId();
        Log.log.info((Object)"Sending changeLocation request", new Object[]{"scid", sceneId, "loc", loc});
        this._pendingLoc = loc.clone();
        InvocationService.ConfirmListener clist = new InvocationService.ConfirmListener(){

            public void requestProcessed() {
                SpotSceneDirector.this._location = SpotSceneDirector.this._pendingLoc;
                SpotSceneDirector.this._pendingLoc = null;
                if (listener != null) {
                    listener.requestCompleted((Object)SpotSceneDirector.this._location);
                }
            }

            public void requestFailed(String reason) {
                SpotSceneDirector.this._pendingLoc = null;
                if (listener != null) {
                    listener.requestFailed(new Exception(reason));
                }
            }
        };
        this._sservice.changeLocation(sceneId, loc, clist);
    }

    public void joinCluster(int froid, final ResultListener<Void> listener) {
        SpotScene scene = (SpotScene)((Object)this._scdir.getScene());
        if (scene == null) {
            Log.log.warning((Object)"Requested to join cluster, but we're not currently in any scene", new Object[]{"froid", froid});
            if (listener != null) {
                listener.requestFailed(new Exception("m.cant_get_there"));
            }
            return;
        }
        Log.log.info((Object)"Joining cluster", new Object[]{"friend", froid});
        this._sservice.joinCluster(froid, new InvocationService.ConfirmListener(){

            public void requestProcessed() {
                if (listener != null) {
                    listener.requestCompleted(null);
                }
            }

            public void requestFailed(String reason) {
                if (listener != null) {
                    listener.requestFailed(new Exception(reason));
                }
            }
        });
    }

    public boolean requestClusterSpeak(String message) {
        return this.requestClusterSpeak(message, (byte)0);
    }

    public boolean requestClusterSpeak(String message, byte mode) {
        SpotScene scene = (SpotScene)((Object)this._scdir.getScene());
        if (scene == null) {
            Log.log.warning((Object)"Requested to speak to cluster, but we're not currently in any scene", new Object[]{"message", message});
            return false;
        }
        if (this._self.getClusterOid() <= 0) {
            Log.log.info((Object)"Ignoring cluster speak as we're not in a cluster", new Object[]{"cloid", this._self.getClusterOid()});
            return false;
        }
        if ((message = this._chatdir.filter(message, null, true)) != null) {
            this._sservice.clusterSpeak(message, mode);
        }
        return true;
    }

    public void objectAvailable(DObject object) {
        this.clearCluster(false);
        int oid = object.getOid();
        if (oid != this._self.getClusterOid()) {
            this._ctx.getDObjectManager().unsubscribeFromObject(oid, (Subscriber)this);
        } else {
            this._clobj = object;
            if (this._chatdir != null) {
                this._chatdir.addAuxiliarySource(object, "clusterChat");
            }
        }
    }

    public void requestFailed(int oid, ObjectAccessException cause) {
        Log.log.warning((Object)"Unable to subscribe to cluster chat object", new Object[]{"oid", oid, "cause", cause});
    }

    public void attributeChanged(AttributeChangedEvent event) {
        if (event.getName().equals(this._self.getClusterField()) && !event.getValue().equals(event.getOldValue())) {
            this.maybeUpdateCluster();
        }
    }

    public void clientDidLogon(Client client) {
        super.clientDidLogon(client);
        ClientObject clientObj = client.getClientObject();
        if (clientObj instanceof ClusteredBodyObject) {
            clientObj.addListener((ChangeListener)this);
            this._self = (ClusteredBodyObject)clientObj;
            this.maybeUpdateCluster();
        }
    }

    public void clientObjectDidChange(Client client) {
        super.clientObjectDidChange(client);
        ClientObject clientObj = client.getClientObject();
        clientObj.addListener((ChangeListener)this);
        this._self = (ClusteredBodyObject)clientObj;
    }

    public void clientDidLogoff(Client client) {
        super.clientDidLogoff(client);
        this._location = null;
        this._pendingLoc = null;
        this._sservice = null;
        this.clearCluster(true);
        client.getClientObject().removeListener((ChangeListener)this);
        this._self = null;
    }

    protected void fetchServices(Client client) {
        this._sservice = (SpotService)client.requireService(SpotService.class);
    }

    protected void handleDeparture() {
        this._location = null;
    }

    protected void maybeUpdateCluster() {
        int cloid = this._self.getClusterOid();
        if (this._clobj == null && cloid <= 0 || this._clobj != null && cloid == this._clobj.getOid()) {
            return;
        }
        this.clearCluster(false);
        if (this._chatdir != null && cloid > 0) {
            this._ctx.getDObjectManager().subscribeToObject(cloid, (Subscriber)this);
        }
    }

    protected void clearCluster(boolean force) {
        if (this._clobj != null && (force || this._clobj.getOid() != this._self.getClusterOid())) {
            if (this._chatdir != null) {
                this._chatdir.removeAuxiliarySource(this._clobj);
            }
            this._ctx.getDObjectManager().unsubscribeFromObject(this._clobj.getOid(), (Subscriber)this);
            this._clobj = null;
        }
    }
}

