/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.whirled.server;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.samskivert.jdbc.RepositoryUnit;
import com.samskivert.util.IntMap;
import com.samskivert.util.IntMaps;
import com.samskivert.util.Invoker;
import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.data.PlaceConfig;
import com.threerings.crowd.server.BodyLocator;
import com.threerings.crowd.server.LocationManager;
import com.threerings.crowd.server.PlaceManager;
import com.threerings.crowd.server.PlaceRegistry;
import com.threerings.presents.annotation.MainInvoker;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.server.InvocationManager;
import com.threerings.presents.server.InvocationProvider;
import com.threerings.whirled.Log;
import com.threerings.whirled.client.SceneService;
import com.threerings.whirled.data.Scene;
import com.threerings.whirled.data.SceneCodes;
import com.threerings.whirled.data.SceneMarshaller;
import com.threerings.whirled.data.SceneModel;
import com.threerings.whirled.server.SceneManager;
import com.threerings.whirled.server.SceneMoveHandler;
import com.threerings.whirled.server.SceneProvider;
import com.threerings.whirled.server.SceneSender;
import com.threerings.whirled.server.persist.SceneRepository;
import com.threerings.whirled.util.NoSuchSceneException;
import com.threerings.whirled.util.SceneFactory;
import com.threerings.whirled.util.UpdateList;
import java.util.List;

@Singleton
public class SceneRegistry
implements SceneCodes,
SceneProvider {
    @Inject
    protected SceneRepository _screp;
    @Inject
    protected ConfigFactory _confact;
    @Inject
    protected SceneFactory _scfact;
    @Inject
    @MainInvoker
    protected Invoker _invoker;
    @Inject
    protected BodyLocator _locator;
    @Inject
    protected PlaceRegistry _plreg;
    @Inject
    protected LocationManager _locman;
    protected IntMap<SceneManager> _scenemgrs = IntMaps.newHashIntMap();
    protected IntMap<List<ResolutionListener>> _penders = IntMaps.newHashIntMap();

    @Inject
    public SceneRegistry(InvocationManager invmgr) {
        invmgr.registerProvider((InvocationProvider)this, SceneMarshaller.class, "whirled");
    }

    public SceneManager getSceneManager(int sceneId) {
        return (SceneManager)((Object)this._scenemgrs.get(sceneId));
    }

    public SceneRepository getSceneRepository() {
        return this._screp;
    }

    public String where(int sceneId) {
        SceneManager scmgr = this.getSceneManager(sceneId);
        return scmgr == null ? "null:" + sceneId : scmgr.where();
    }

    public void resolveScene(int sceneId, ResolutionListener target) {
        SceneManager mgr = (SceneManager)((Object)this._scenemgrs.get(sceneId));
        if (mgr != null) {
            target.sceneWasResolved(mgr);
            return;
        }
        if (!this.addResolutionListener(sceneId, target)) {
            return;
        }
        final int fsceneId = sceneId;
        this._invoker.postUnit((Invoker.Unit)new RepositoryUnit("resolveScene(" + sceneId + ")"){
            protected SceneModel _model;
            protected UpdateList _updates;
            protected Object _extras;

            public void invokePersist() throws Exception {
                this._model = SceneRegistry.this._screp.loadSceneModel(fsceneId);
                this._updates = SceneRegistry.this._screp.loadUpdates(fsceneId);
                this._extras = SceneRegistry.this._screp.loadExtras(fsceneId, this._model);
            }

            public void handleSuccess() {
                SceneRegistry.this.processSuccessfulResolution(this._model, this._updates, this._extras);
            }

            public void handleFailure(Exception error) {
                SceneRegistry.this.processFailedResolution(fsceneId, error);
            }
        });
    }

    @Override
    public void moveTo(ClientObject caller, int sceneId, int sceneVer, SceneService.SceneMoveListener listener) {
        BodyObject body = this._locator.forClient(caller);
        this.resolveScene(sceneId, new SceneMoveHandler(this._locman, body, sceneVer, listener));
    }

    public void moveBody(BodyObject source, int sceneId) {
        this._locman.leaveOccupiedPlace(source);
        SceneSender.forcedMove(source.getClientObject(), sceneId);
    }

    public void leaveOccupiedScene(BodyObject source) {
        this._locman.leaveOccupiedPlace(source);
    }

    protected boolean addResolutionListener(int sceneId, ResolutionListener rl) {
        List penders = (List)this._penders.get(sceneId);
        boolean newList = false;
        if (penders == null) {
            penders = Lists.newArrayList();
            this._penders.put(sceneId, (Object)penders);
            newList = true;
        }
        penders.add(rl);
        return newList;
    }

    protected void processSuccessfulResolution(SceneModel model, final UpdateList updates, final Object extras) {
        try {
            final Scene scene = this._scfact.createScene(model, this._confact.createPlaceConfig(model));
            this._plreg.createPlace(scene.getPlaceConfig(), new PlaceRegistry.PreStartupHook(){

                public void invoke(PlaceManager pmgr) {
                    ((SceneManager)pmgr).setSceneData(scene, updates, extras, SceneRegistry.this);
                }
            });
        }
        catch (Exception e) {
            this.processFailedResolution(model.sceneId, e);
        }
    }

    protected void processFailedResolution(int sceneId, Exception cause) {
        List penders;
        if (!(cause instanceof NoSuchSceneException)) {
            Log.log.info((Object)("Failed to resolve scene [sceneId=" + sceneId + "]."), new Object[]{cause});
        }
        if ((penders = (List)this._penders.remove(sceneId)) != null) {
            for (ResolutionListener rl : penders) {
                try {
                    rl.sceneFailedToResolve(sceneId, cause);
                }
                catch (Exception e) {
                    Log.log.warning((Object)"Resolution listener choked.", new Object[]{e});
                }
            }
        }
    }

    protected void sceneManagerDidStart(SceneManager scmgr) {
        int sceneId = scmgr.getScene().getId();
        this._scenemgrs.put(sceneId, (Object)scmgr);
        Log.log.debug((Object)"Registering scene manager", new Object[]{"scid", sceneId, "scmgr", scmgr});
        List penders = (List)this._penders.remove(sceneId);
        if (penders != null) {
            for (ResolutionListener rl : penders) {
                try {
                    rl.sceneWasResolved(scmgr);
                }
                catch (Exception e) {
                    Log.log.warning((Object)"Resolution listener choked.", new Object[]{e});
                }
            }
        }
    }

    protected void unmapSceneManager(SceneManager scmgr) {
        if (this._scenemgrs.remove(scmgr.getScene().getId()) == null) {
            Log.log.warning((Object)("Requested to unmap unmapped scene manager [scmgr=" + (Object)((Object)scmgr) + "]."), new Object[0]);
            return;
        }
        Log.log.debug((Object)"Unmapped scene manager", new Object[]{"scmgr", scmgr});
    }

    public static interface ResolutionListener {
        public void sceneWasResolved(SceneManager var1);

        public void sceneFailedToResolve(int var1, Exception var2);
    }

    public static interface ConfigFactory {
        public PlaceConfig createPlaceConfig(SceneModel var1);
    }
}

