/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.whirled.server;

import com.google.inject.Inject;
import com.samskivert.jdbc.WriteOnlyUnit;
import com.samskivert.util.Invoker;
import com.threerings.crowd.data.Place;
import com.threerings.crowd.server.PlaceManager;
import com.threerings.presents.annotation.MainInvoker;
import com.threerings.whirled.Log;
import com.threerings.whirled.data.Scene;
import com.threerings.whirled.data.ScenePlace;
import com.threerings.whirled.data.SceneUpdate;
import com.threerings.whirled.server.SceneRegistry;
import com.threerings.whirled.util.UpdateList;

public class SceneManager
extends PlaceManager {
    protected Scene _scene;
    protected UpdateList _updates;
    protected SceneRegistry _screg;
    @Inject
    @MainInvoker
    protected Invoker _invoker;

    public Scene getScene() {
        return this._scene;
    }

    public SceneUpdate[] getUpdates(int fromVersion) {
        return this._updates.getUpdates(fromVersion);
    }

    public Place getLocation() {
        return new ScenePlace(this._plobj.getOid(), this._scene.getId());
    }

    public boolean isPersistent() {
        return true;
    }

    protected void setSceneData(Scene scene, UpdateList updates, Object extras, SceneRegistry screg) {
        this._scene = scene;
        this._screg = screg;
        this._updates = updates;
        if (!this._updates.validate(scene.getVersion())) {
            Log.log.warning((Object)("Provided with invalid updates; flushing [where=" + this.where() + ", sceneId=" + scene.getId() + ", version=" + scene.getVersion() + "]."), new Object[0]);
            this._updates = new UpdateList();
        }
        this.gotSceneData(extras);
    }

    protected void gotSceneData(Object extras) {
    }

    protected void didStartup() {
        super.didStartup();
        this._omgr.postRunnable(new Runnable(){

            @Override
            public void run() {
                SceneManager.this._screg.sceneManagerDidStart(SceneManager.this);
            }
        });
    }

    protected void didShutdown() {
        super.didShutdown();
        this._screg.unmapSceneManager(this);
    }

    protected void recordUpdate(final SceneUpdate update) {
        this._scene.updateReceived(update);
        this._updates.addUpdate(update);
        if (this.isPersistent()) {
            this._invoker.postUnit((Invoker.Unit)new WriteOnlyUnit("recordUpdate(" + update + ")"){

                public void invokePersist() throws Exception {
                    SceneManager.this._screg.getSceneRepository().applyAndRecordUpdate(SceneManager.this._scene.getSceneModel(), update);
                }
            });
        }
        this._plobj.postMessage("scene_update", new Object[]{update});
    }

    public String where() {
        return this._scene.getName() + " (" + super.where() + ":" + this._scene.getId() + ")";
    }

    protected void toString(StringBuilder buf) {
        super.toString(buf);
        buf.append(", scene=").append(this._scene);
    }
}

