/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.whirled.client;

import com.google.common.collect.Lists;
import com.samskivert.util.LRUHashMap;
import com.samskivert.util.ResultListener;
import com.threerings.crowd.client.LocationDirector;
import com.threerings.crowd.data.PlaceConfig;
import com.threerings.presents.client.BasicDirector;
import com.threerings.presents.client.Client;
import com.threerings.presents.client.InvocationDecoder;
import com.threerings.presents.client.InvocationService;
import com.threerings.presents.util.PresentsContext;
import com.threerings.whirled.Log;
import com.threerings.whirled.client.SceneDecoder;
import com.threerings.whirled.client.SceneReceiver;
import com.threerings.whirled.client.SceneService;
import com.threerings.whirled.client.persist.SceneRepository;
import com.threerings.whirled.data.Scene;
import com.threerings.whirled.data.SceneCodes;
import com.threerings.whirled.data.SceneModel;
import com.threerings.whirled.data.SceneUpdate;
import com.threerings.whirled.util.NoSuchSceneException;
import com.threerings.whirled.util.SceneFactory;
import com.threerings.whirled.util.WhirledContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class SceneDirector
extends BasicDirector
implements SceneCodes,
LocationDirector.FailureHandler,
SceneReceiver,
SceneService.SceneMoveListener {
    protected WhirledContext _ctx;
    protected SceneService _sservice;
    protected LocationDirector _locdir;
    protected SceneRepository _screp;
    protected SceneFactory _fact;
    protected Map<Integer, SceneModel> _scache = new LRUHashMap(10);
    protected Scene _scene;
    protected SceneModel _model;
    protected int _sceneId = -1;
    protected SceneModel _pendingModel;
    protected int _pendingSceneId = -1;
    protected int _previousSceneId = -1;
    protected MoveHandler _moveHandler = null;
    protected ArrayList<Runnable> _pendingForcedMoves = Lists.newArrayList();

    public SceneDirector(WhirledContext ctx, LocationDirector locdir, SceneRepository screp, SceneFactory fact) {
        super((PresentsContext)ctx);
        this._ctx = ctx;
        this._locdir = locdir;
        this.setSceneRepository(screp);
        this._fact = fact;
        this._locdir.setFailureHandler((LocationDirector.FailureHandler)this);
        this._ctx.getClient().getInvocationDirector().registerReceiver((InvocationDecoder)new SceneDecoder(this));
    }

    public void setSceneRepository(SceneRepository screp) {
        this._screp = screp;
        this._scache.clear();
    }

    public Scene getScene() {
        return this._scene;
    }

    public boolean movePending() {
        return this._pendingSceneId > 0;
    }

    public boolean moveTo(int sceneId) {
        if (sceneId < 0) {
            Log.log.warning((Object)("Refusing moveTo(): invalid sceneId " + sceneId + "."), new Object[0]);
            return false;
        }
        if (sceneId == this._sceneId) {
            Log.log.warning((Object)"Refusing request to move to the same scene", new Object[]{"sceneId", sceneId});
            return false;
        }
        if (!this.prepareMoveTo(sceneId, null)) {
            return false;
        }
        this.sendMoveRequest();
        return true;
    }

    public boolean prepareMoveTo(int sceneId, ResultListener<PlaceConfig> rl) {
        if (!this._locdir.mayMoveTo(sceneId, rl)) {
            return false;
        }
        boolean refuse = this._locdir.checkRepeatMove();
        if (this.movePending()) {
            if (refuse) {
                Log.log.warning((Object)"Refusing moveTo; We have a request outstanding", new Object[]{"psid", this._pendingSceneId, "nsid", sceneId});
                return false;
            }
            Log.log.warning((Object)"Overriding stale moveTo request", new Object[]{"psid", this._pendingSceneId, "nsid", sceneId});
        }
        long loading = System.currentTimeMillis();
        this._pendingModel = this.loadSceneModel(sceneId);
        System.out.println("loading scene id=" + sceneId + ", time=" + (System.currentTimeMillis() - loading));
        this._pendingSceneId = sceneId;
        return true;
    }

    public SceneModel getPendingModel() {
        return this._pendingModel;
    }

    public int getPendingSceneId() {
        return this._pendingSceneId;
    }

    @Override
    public void moveSucceeded(int placeId, PlaceConfig config) {
        this._locdir.didMoveTo(placeId, config);
        this._previousSceneId = this._sceneId;
        this.clearScene();
        this._sceneId = this._pendingSceneId;
        this._pendingSceneId = -1;
        this._model = this.loadSceneModel(this._sceneId);
        if (this._model == null) {
            Log.log.warning((Object)("Aiya! Unable to load scene [sid=" + this._sceneId + ", plid=" + placeId + "]."), new Object[0]);
            return;
        }
        this._scene = this._fact.createScene(this._model, config);
        this.handlePendingForcedMove();
    }

    @Override
    public void moveSucceededWithUpdates(int placeId, PlaceConfig config, SceneUpdate[] updates) {
        Log.log.info((Object)"Got updates", new Object[]{"placeId", placeId, "config", config, "updates", updates});
        SceneModel model = this.loadSceneModel(this._pendingSceneId);
        boolean failure = false;
        for (SceneUpdate element : updates) {
            try {
                element.validate(model);
            }
            catch (IllegalStateException ise) {
                Log.log.warning((Object)"Scene update failed validation", new Object[]{"model", model, "update", element, "error", ise.getMessage()});
                failure = true;
                break;
            }
            try {
                element.apply(model);
            }
            catch (Exception e) {
                Log.log.warning((Object)"Failure applying scene update", new Object[]{"model", model, "update", element, e});
                failure = true;
                break;
            }
        }
        if (failure) {
            try {
                this._screp.deleteSceneModel(this._pendingSceneId);
            }
            catch (IOException ioe) {
                Log.log.warning((Object)"Failure removing booched scene model", new Object[]{"sceneId", this._pendingSceneId, ioe});
            }
            this.requestFailed("m.internal_error");
            return;
        }
        this.persistSceneModel(model);
        this.moveSucceeded(placeId, config);
    }

    @Override
    public void moveSucceededWithScene(int placeId, PlaceConfig config, SceneModel model) {
        Log.log.info((Object)"Got updated scene model", new Object[]{"placeId", placeId, "config", config, "scene", model.sceneId + "/" + model.name + "/" + model.version});
        this.persistSceneModel(model);
        this._scache.put(model.sceneId, model);
        this.moveSucceeded(placeId, config);
    }

    @Override
    public void moveRequiresServerSwitch(String hostname, int[] ports) {
        this._ctx.getClient().moveToServer(hostname, ports, new InvocationService.ConfirmListener(){

            public void requestProcessed() {
                SceneDirector.this.sendMoveRequest();
            }

            public void requestFailed(String reason) {
                SceneDirector.this.requestFailed(reason);
            }
        });
    }

    public void requestFailed(String reason) {
        this._locdir.failedToMoveTo(this._pendingSceneId, reason);
    }

    public void updateReceived(SceneUpdate update) {
        this._scene.updateReceived(update);
        this.persistSceneModel(this._scene.getSceneModel());
    }

    public void didLeaveScene() {
        this._locdir.didLeavePlace();
        this.clearScene();
    }

    public void setMoveHandler(MoveHandler handler) {
        if (this._moveHandler != null) {
            Log.log.warning((Object)"Requested to set move handler, but we've already got one. The conflicting entities will likely need to perform more sophisticated coordination to deal with failures.", new Object[]{"old", this._moveHandler, "new", handler});
        } else {
            this._moveHandler = handler;
        }
    }

    @Override
    public void forcedMove(final int sceneId) {
        if (this.movePending()) {
            if (this._pendingSceneId == sceneId) {
                Log.log.info((Object)"Dropping forced move because we have a move pending", new Object[]{"pendId", this._pendingSceneId, "reqId", sceneId});
            } else {
                Log.log.info((Object)"Delaying forced move because we have a move pending", new Object[]{"pendId", this._pendingSceneId, "reqId", sceneId});
                this.addPendingForcedMove(new Runnable(){

                    @Override
                    public void run() {
                        SceneDirector.this.forcedMove(sceneId);
                    }
                });
            }
            return;
        }
        Log.log.info((Object)"Moving at request of server", new Object[]{"sceneId", sceneId});
        this.didLeaveScene();
        this.moveTo(sceneId);
    }

    public void recoverFailedMove(int placeId) {
        if (this._sceneId > 0) {
            return;
        }
        int justAttemptedSceneId = this._pendingSceneId;
        this._pendingSceneId = -1;
        this.clearScene();
        if (this._previousSceneId != -1 && this._previousSceneId != justAttemptedSceneId) {
            if (this._moveHandler != null) {
                this._moveHandler.recoverMoveTo(this._previousSceneId);
            } else {
                this.moveTo(this._previousSceneId);
            }
        }
        this.handlePendingForcedMove();
    }

    protected void sendMoveRequest() {
        int sceneVers = 0;
        if (this._pendingModel != null) {
            sceneVers = this._pendingModel.version;
        }
        Log.log.info((Object)("Issuing moveTo(" + this._pendingSceneId + ", " + sceneVers + ")."), new Object[0]);
        this._sservice.moveTo(this._pendingSceneId, sceneVers, this);
    }

    protected void clearScene() {
        this._sceneId = -1;
        this._model = null;
        this._scene = null;
    }

    protected SceneModel loadSceneModel(int sceneId) {
        Integer key = sceneId;
        SceneModel model = this._scache.get(key);
        if (model == null) {
            try {
                model = this._screp.loadSceneModel(sceneId);
                this._scache.put(key, model);
            }
            catch (NoSuchSceneException noSuchSceneException) {
            }
            catch (IOException ioe) {
                Log.log.warning((Object)"Error loading scene", new Object[]{"scid", sceneId, "error", ioe});
            }
        }
        return model;
    }

    protected void persistSceneModel(SceneModel model) {
        try {
            this._screp.storeSceneModel(model);
        }
        catch (IOException ioe) {
            Log.log.warning((Object)"Failed to update repository with updated scene", new Object[]{"sceneId", model.sceneId, "nvers", model.version, ioe});
        }
    }

    public void clientDidLogoff(Client client) {
        super.clientDidLogoff(client);
        this.clearScene();
        this._scache.clear();
        this._pendingSceneId = -1;
        this._pendingModel = null;
        this._pendingForcedMoves.clear();
        this._previousSceneId = -1;
        this._sservice = null;
    }

    public void cancelMoveRequest() {
        this._pendingSceneId = -1;
        this._pendingModel = null;
        this.handlePendingForcedMove();
    }

    protected void registerServices(Client client) {
        client.addServiceGroup("whirled");
    }

    protected void fetchServices(Client client) {
        this._sservice = (SceneService)client.requireService(SceneService.class);
    }

    public void addPendingForcedMove(Runnable move) {
        this._pendingForcedMoves.add(move);
    }

    protected void handlePendingForcedMove() {
        if (!this._pendingForcedMoves.isEmpty()) {
            this._ctx.getClient().getRunQueue().postRunnable(this._pendingForcedMoves.remove(0));
        }
    }

    public static interface MoveHandler {
        public void recoverMoveTo(int var1);
    }
}

