/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.stage.tools.viewer;

import com.samskivert.swing.Controller;
import com.samskivert.util.RandomUtil;
import com.threerings.cast.CharacterDescriptor;
import com.threerings.cast.CharacterManager;
import com.threerings.cast.CharacterSprite;
import com.threerings.cast.ComponentRepository;
import com.threerings.cast.util.CastUtil;
import com.threerings.media.image.ColorPository;
import com.threerings.media.sprite.PathObserver;
import com.threerings.media.sprite.Sprite;
import com.threerings.media.util.LineSegmentPath;
import com.threerings.media.util.Path;
import com.threerings.media.util.Pathable;
import com.threerings.media.util.PerformanceMonitor;
import com.threerings.media.util.PerformanceObserver;
import com.threerings.stage.Log;
import com.threerings.stage.client.StageScenePanel;
import com.threerings.stage.data.StageLocation;
import com.threerings.stage.data.StageScene;
import com.threerings.stage.util.StageContext;
import com.threerings.whirled.spot.data.Location;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class ViewerScenePanel
extends StageScenePanel
implements PerformanceObserver,
PathObserver {
    protected static final int DEFAULT_NUM_DECOYS = 10;
    protected StageLocation _defloc;
    protected CharacterManager _charmgr;
    protected CharacterDescriptor _descUser;
    protected CharacterDescriptor _descDecoy;
    protected CharacterSprite _sprite;
    protected CharacterSprite[] _decoys;
    protected static final String[] COMP_CLASSES = new String[]{"legs", "feet", "hand_left", "hand_right", "torso", "head", "hair", "hat", "eyepatch"};
    protected static final String[] COLOR_CLASSES = new String[]{"skin", "hair", "textile_p", "textile_s"};

    public ViewerScenePanel(StageContext ctx, CharacterManager charmgr) {
        super(ctx, new Controller(){});
        this._charmgr = charmgr;
        this._descUser = CastUtil.getRandomDescriptor((ComponentRepository)ctx.getComponentRepository(), (String)"female", (String[])COMP_CLASSES, (ColorPository)ctx.getColorPository(), (String[])COLOR_CLASSES);
        this._descDecoy = CastUtil.getRandomDescriptor((ComponentRepository)ctx.getComponentRepository(), (String)"male", (String[])COMP_CLASSES, (ColorPository)ctx.getColorPository(), (String[])COLOR_CLASSES);
        this._sprite = this.createSprite(this._descUser);
        this.setFollowsPathable((Pathable)this._sprite, (byte)0);
        PerformanceMonitor.register((PerformanceObserver)this, (String)"paint", (long)1000L);
    }

    public void setScene(StageScene scene, Location defloc) {
        this.setScene(scene);
        this._defloc = (StageLocation)defloc;
        Point defpos = this.getScreenCoords(this._defloc.x, this._defloc.y);
        this._sprite.setLocation(defpos.x, defpos.y);
        if (this._decoys != null) {
            for (CharacterSprite decoy : this._decoys) {
                decoy.setLocation(defpos.x, defpos.y);
            }
            this.createDecoyPaths();
        }
    }

    protected CharacterSprite createSprite(CharacterDescriptor desc) {
        CharacterSprite s = this._charmgr.getCharacter(desc);
        if (s != null) {
            s.setActionSequence("standing");
            if (this._defloc != null) {
                Point defpos = this.getScreenCoords(this._defloc.x, this._defloc.y);
                s.setLocation(defpos.x, defpos.y);
            } else {
                s.setLocation(300, 300);
            }
            s.addSpriteObserver((Object)this);
            this._spritemgr.addSprite((Sprite)s);
        }
        return s;
    }

    public void createDecoys() {
        int decoys = 10;
        try {
            decoys = Integer.parseInt(System.getProperty("decoys"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this._decoys == null) {
            this._decoys = new CharacterSprite[decoys];
            for (int ii = 0; ii < decoys; ++ii) {
                this._decoys[ii] = this.createSprite(this._descDecoy);
            }
        }
        this.createDecoyPaths();
    }

    protected void createDecoyPaths() {
        if (this._decoys != null) {
            for (CharacterSprite decoy : this._decoys) {
                if (decoy == null) continue;
                this.createRandomPath(decoy);
            }
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        PerformanceMonitor.tick((PerformanceObserver)this, (String)"paint");
    }

    public void checkpoint(String name, int ticks) {
        Log.log.info((Object)(name + " [ticks=" + ticks + "]."), new Object[0]);
    }

    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        switch (e.getModifiers()) {
            case 16: {
                this.createPath(this._sprite, x, y);
                break;
            }
            case 8: {
                if (this._decoys == null) break;
                for (CharacterSprite decoy : this._decoys) {
                    this.createPath(decoy, x, y);
                }
                break;
            }
        }
    }

    protected boolean createPath(CharacterSprite s, int x, int y) {
        LineSegmentPath path = (LineSegmentPath)this.getPath((Sprite)s, x, y, false);
        if (path == null) {
            s.cancelMove();
            return false;
        }
        path.setVelocity(0.1f);
        s.move((Path)path);
        return true;
    }

    protected void createRandomPath(CharacterSprite s) {
        int y;
        int x;
        while (!this.createPath(s, x = this._vbounds.x + RandomUtil.getInt((int)this._vbounds.width), y = this._vbounds.y + RandomUtil.getInt((int)this._vbounds.height))) {
        }
    }

    public void pathCancelled(Sprite sprite, Path path) {
    }

    public void pathCompleted(Sprite sprite, Path path, long when) {
        if (sprite != this._sprite) {
            this.createRandomPath((CharacterSprite)sprite);
        }
    }
}

