/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.stage.tools.editor;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.HGroupLayout;
import com.samskivert.util.StringUtil;
import com.threerings.media.image.ColorPository;
import com.threerings.media.tile.NoSuchTileSetException;
import com.threerings.media.tile.RecolorableTileSet;
import com.threerings.media.tile.TileSet;
import com.threerings.media.tile.TileUtil;
import com.threerings.miso.client.MisoScenePanel;
import com.threerings.miso.client.SceneObject;
import com.threerings.stage.tools.editor.EditorDialog;
import com.threerings.stage.tools.editor.EditorScenePanel;
import com.threerings.stage.tools.editor.util.EditorContext;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;

public class ObjectEditorDialog
extends EditorDialog {
    protected JTextField _action;
    protected JSlider _priority;
    protected SceneObject _scobj;
    protected JComboBox _primary;
    protected JComboBox _secondary;
    protected JComboBox _tertiary;
    protected JComboBox _quaternary;
    protected static final ZationChoice[] NO_CHOICES = new ZationChoice[]{new ZationChoice(0, "<none>")};

    public ObjectEditorDialog(EditorContext ctx, EditorScenePanel panel) {
        super("Edit object attributes", ctx, panel);
    }

    @Override
    public void addComponents(JComponent panel) {
        JPanel sub = new JPanel((LayoutManager)new HGroupLayout(HGroupLayout.STRETCH));
        sub.add((Component)new JLabel("Object action command:"), HGroupLayout.FIXED);
        this._action = new JTextField();
        sub.add(this._action);
        this._action.addActionListener(this);
        this._action.setActionCommand("ok");
        panel.add(sub);
        sub = new JPanel((LayoutManager)new HGroupLayout(HGroupLayout.STRETCH));
        sub.add((Component)new JLabel("Render priority:"), HGroupLayout.FIXED);
        this._priority = new JSlider(-5, 5);
        sub.add(this._priority);
        this._priority.setMajorTickSpacing(5);
        this._priority.setMinorTickSpacing(1);
        this._priority.setPaintTicks(true);
        panel.add(sub);
        JPanel zations = HGroupLayout.makeButtonBox((GroupLayout.Justification)HGroupLayout.LEFT, (Component[])new Component[0]);
        zations.add(new JLabel("Colorizations:"));
        this._primary = new JComboBox<ZationChoice>(NO_CHOICES);
        zations.add(this._primary);
        this._secondary = new JComboBox<ZationChoice>(NO_CHOICES);
        zations.add(this._secondary);
        this._tertiary = new JComboBox<ZationChoice>(NO_CHOICES);
        zations.add(this._tertiary);
        this._quaternary = new JComboBox<ZationChoice>(NO_CHOICES);
        zations.add(this._quaternary);
        panel.add(zations);
    }

    public void prepare(SceneObject scobj) {
        String title;
        this._scobj = scobj;
        int tsid = TileUtil.getTileSetId((int)scobj.info.tileId);
        int tidx = TileUtil.getTileIndex((int)scobj.info.tileId);
        TileSet tset = null;
        try {
            tset = this._ctx.getTileManager().getTileSet(tsid);
            title = tset.getName() + ": " + tidx;
        }
        catch (NoSuchTileSetException nstse) {
            title = "Error(" + tsid + "): " + tidx;
        }
        title = title + " (" + StringUtil.coordsToString((int)this._scobj.info.x, (int)this._scobj.info.y) + ")";
        this.setTitle(title);
        String atext = scobj.info.action == null ? "" : scobj.info.action;
        this._action.setText(atext);
        this._priority.setValue(scobj.getPriority());
        Object[] pzations = null;
        Object[] szations = null;
        Object[] tzations = null;
        Object[] qzations = null;
        if (tset != null) {
            String[] zations = null;
            if (tset instanceof RecolorableTileSet) {
                zations = ((RecolorableTileSet)tset).getColorizations();
            }
            if (zations != null) {
                pzations = this.computeZations(zations, 0);
                szations = this.computeZations(zations, 1);
                tzations = this.computeZations(zations, 2);
                qzations = this.computeZations(zations, 3);
            }
        }
        this.configureZations(this._primary, pzations, this._scobj.info.getPrimaryZation());
        this.configureZations(this._secondary, szations, this._scobj.info.getSecondaryZation());
        this.configureZations(this._tertiary, tzations, this._scobj.info.getTertiaryZation());
        this.configureZations(this._quaternary, qzations, this._scobj.info.getQuaternaryZation());
        this._action.setCaretPosition(0);
        this._action.moveCaretPosition(atext.length());
        this._action.requestFocusInWindow();
    }

    protected Object[] computeZations(String[] zations, int index) {
        if (zations.length <= index || StringUtil.isBlank((String)zations[index])) {
            return null;
        }
        ColorPository cpos = this._ctx.getColorPository();
        ColorPository.ColorRecord[] crecs = cpos.enumerateColors(zations[index]);
        if (crecs == null) {
            return null;
        }
        Object[] czations = new Object[crecs.length + 1];
        czations[0] = new ZationChoice(0, "<none>");
        for (int ii = 0; ii < crecs.length; ++ii) {
            czations[ii + 1] = new ZationChoice(crecs[ii].colorId, crecs[ii].name);
        }
        Arrays.sort(czations);
        return czations;
    }

    protected void configureZations(JComboBox combo, Object[] zations, int colorId) {
        int selidx = 0;
        combo.setEnabled(zations != null);
        if (zations != null) {
            combo.removeAllItems();
            for (int ii = 0; ii < zations.length; ++ii) {
                combo.addItem(zations[ii]);
                if (((ZationChoice)zations[ii]).colorId != colorId) continue;
                selidx = ii;
            }
        }
        combo.setSelectedIndex(selidx);
    }

    @Override
    public void accepted() {
        this._scobj.info.action = this._action.getText();
        byte prio = (byte)this._priority.getValue();
        if (prio != this._scobj.getPriority()) {
            this._scobj.setPriority(prio);
        }
        int ozations = this._scobj.info.zations;
        ZationChoice pchoice = (ZationChoice)this._primary.getSelectedItem();
        ZationChoice schoice = (ZationChoice)this._secondary.getSelectedItem();
        ZationChoice tchoice = (ZationChoice)this._tertiary.getSelectedItem();
        ZationChoice qchoice = (ZationChoice)this._quaternary.getSelectedItem();
        this._scobj.info.setZations(pchoice.colorId, schoice.colorId, tchoice.colorId, qchoice.colorId);
        if (ozations != this._scobj.info.zations) {
            this._scobj.refreshObjectTile((MisoScenePanel)this._panel);
        }
        this._panel.objectEditorDismissed();
    }

    @Override
    public void cancelled() {
        this._panel.objectEditorDismissed();
    }

    protected static class ZationChoice
    implements Comparable<ZationChoice> {
        public byte colorId;
        public String name;
        protected static final Comparator<String> NULLS_OK = Ordering.natural().nullsFirst();

        public ZationChoice(int colorId, String name) {
            this.colorId = (byte)colorId;
            this.name = name;
        }

        @Override
        public int compareTo(ZationChoice that) {
            return ComparisonChain.start().compare((Object)this.name, (Object)that.name, NULLS_OK).compare((int)this.colorId, (int)that.colorId).result();
        }

        public String toString() {
            return this.name;
        }
    }
}

