/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.stage.tools.editor;

import com.samskivert.swing.RuntimeAdjust;
import com.samskivert.swing.util.SwingUtil;
import com.samskivert.util.DebugChords;
import com.samskivert.util.StringUtil;
import com.threerings.cast.ComponentRepository;
import com.threerings.cast.bundle.BundledComponentRepository;
import com.threerings.media.FrameManager;
import com.threerings.media.image.ColorPository;
import com.threerings.media.image.ImageManager;
import com.threerings.media.tile.TileSetRepository;
import com.threerings.media.tile.bundle.BundledTileSetRepository;
import com.threerings.media.util.ModeUtil;
import com.threerings.miso.tile.MisoTileManager;
import com.threerings.resource.ResourceManager;
import com.threerings.resource.file.FileResourceManager;
import com.threerings.stage.Log;
import com.threerings.stage.tools.editor.EditorConfig;
import com.threerings.stage.tools.editor.EditorFrame;
import com.threerings.stage.tools.editor.EditorTileManager;
import com.threerings.stage.tools.editor.util.EditorContext;
import com.threerings.stage.tools.xml.StageSceneWriter;
import com.threerings.util.KeyDispatcher;
import com.threerings.util.KeyboardManager;
import com.threerings.util.MessageBundle;
import com.threerings.util.MessageManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.logging.LogManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;

public class EditorApp
implements Runnable {
    protected EditorContext _ctx;
    protected EditorFrame _frame;
    protected FrameManager _framemgr;
    protected FileResourceManager _rmgr;
    protected ImageManager _imgr;
    protected MisoTileManager _tilemgr;
    protected TileSetRepository _tsrepo;
    protected ColorPository _colpos;
    protected MessageManager _msgmgr;
    protected KeyboardManager _kbdmgr;
    protected BundledComponentRepository _crepo;
    protected KeyDispatcher _keydisp;
    protected static RuntimeAdjust.BooleanAdjust _viewFullScreen = new RuntimeAdjust.BooleanAdjust("Toggles whether or not the scene editor uses full screen mode.", "stage.editor.full_screen", EditorConfig.config, false);

    public EditorApp(String[] args) throws IOException {
        String target;
        String string = target = args.length > 0 ? args[0] : null;
        if (System.getProperty("no_log_redir") != null) {
            Log.log.info((Object)"Logging to console only.", new Object[0]);
        } else {
            String dlog = EditorApp.localDataDir("editor.log");
            try {
                PrintStream logOut = new PrintStream(new BufferedOutputStream(new FileOutputStream(dlog)), true);
                System.setOut(logOut);
                System.setErr(logOut);
                LogManager.getLogManager().readConfiguration();
                Log.log.info((Object)("Opened debug log '" + dlog + "'."), new Object[0]);
            }
            catch (IOException ioe) {
                Log.log.warning((Object)"Failed to open debug log", new Object[]{"path", dlog, "error", ioe});
            }
        }
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        this._frame = this.createEditorFrame();
        this._framemgr = FrameManager.newInstance((FrameManager.ManagedRoot)this._frame);
        this._rmgr = new FileResourceManager("rsrc");
        JPanel progressPanel = new JPanel(new BorderLayout());
        final JLabel progressLabel = new JLabel();
        final JProgressBar progress = new JProgressBar(0, 100);
        final JPanel spacer = new JPanel();
        progressPanel.add((Component)progressLabel, "Center");
        progressPanel.add((Component)progress, "South");
        progressPanel.setPreferredSize(new Dimension(300, 80));
        spacer.add(progressPanel);
        this._frame.getContentPane().add(spacer);
        final EditorFrame frameRef = this._frame;
        FileResourceManager.InitObserver obs = new FileResourceManager.InitObserver(){

            public void progress(int percent, long remaining) {
                String msg = "Unpacking...";
                if (remaining >= 0L) {
                    msg = msg + " " + remaining + " seconds remaining.";
                }
                progressLabel.setText(msg);
                progress.setValue(percent);
                if (percent >= 100) {
                    frameRef.getContentPane().remove(spacer);
                    EditorApp.this.finishInit(target);
                }
            }

            public void initializationFailed(Exception e) {
                Log.log.warning((Object)"Failed unpacking bundles", new Object[]{"e", e, e});
            }
        };
        obs = new FileResourceManager.AWTInitObserver(obs);
        this._rmgr.initBundles(null, "config/resource/editor.properties", obs);
    }

    public void finishInit(String target) {
        this._msgmgr = new MessageManager("rsrc.i18n");
        this._imgr = new ImageManager((ResourceManager)this._rmgr, (Component)((Object)this._frame));
        this._tilemgr = new EditorTileManager((ResourceManager)this._rmgr, this._imgr);
        try {
            this._tsrepo = new BundledTileSetRepository((ResourceManager)this._rmgr, this._imgr, "tilesets");
            this._tilemgr.setTileSetRepository(this._tsrepo);
            this._crepo = new BundledComponentRepository((ResourceManager)this._rmgr, this._imgr, "components");
        }
        catch (IOException e) {
            Log.log.warning((Object)"Exception loading tilesets and and icon manager", new Object[]{"Exception", e});
            return;
        }
        this._colpos = ColorPository.loadColorPository((ResourceManager)this._rmgr);
        this._kbdmgr = new KeyboardManager();
        this._keydisp = new KeyDispatcher((Window)((Object)this._frame));
        this._ctx = new EditorContextImpl();
        this._frame.init(this._ctx, target);
        DebugChords.activate();
        if (target != null) {
            this._frame.openScene(target);
        }
    }

    public static String localDataDir(String subdir) {
        String appdir = System.getProperty("appdir");
        if (StringUtil.isBlank((String)appdir)) {
            appdir = ".narya-editor";
            String home = System.getProperty("user.home");
            if (!StringUtil.isBlank((String)home)) {
                appdir = home + File.separator + appdir;
            }
        }
        return appdir + File.separator + subdir;
    }

    @Override
    public void run() {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = env.getDefaultScreenDevice();
        DisplayMode pmode = null;
        try {
            DisplayMode cmode = gd.getDisplayMode();
            pmode = ModeUtil.getDisplayMode((GraphicsDevice)gd, (int)cmode.getWidth(), (int)cmode.getHeight(), (int)16, (int)15);
        }
        catch (Throwable t) {
            Log.log.warning((Object)"Failed to probe display mode.", new Object[]{t});
        }
        if (_viewFullScreen.getValue() && gd.isFullScreenSupported() && pmode != null) {
            Log.log.info((Object)"Switching to screen mode", new Object[]{"mode", ModeUtil.toString((DisplayMode)pmode)});
            this._frame.setUndecorated(true);
            gd.setFullScreenWindow((Window)((Object)this._frame));
            gd.setDisplayMode(pmode);
            this._frame.pack();
        } else {
            this._frame.setSize(1024, 768);
            SwingUtil.centerWindow((Window)((Object)this._frame));
            this._frame.setVisible(true);
            SwingUtil.refresh((JComponent)((JComponent)this._frame.getContentPane()));
        }
        this._framemgr.start();
    }

    protected EditorFrame createEditorFrame() {
        return new EditorFrame(new StageSceneWriter());
    }

    protected void enumerateSceneTypes(List<String> types) {
        types.add("world");
    }

    public static void main(String[] args) {
        try {
            EditorApp app = new EditorApp(args);
            EventQueue.invokeLater(app);
        }
        catch (IOException ioe) {
            Log.log.warning((Object)"Unable to initialize editor.", new Object[]{ioe});
        }
    }

    protected class EditorContextImpl
    implements EditorContext {
        protected EditorContextImpl() {
        }

        public MisoTileManager getTileManager() {
            return EditorApp.this._tilemgr;
        }

        public FrameManager getFrameManager() {
            return EditorApp.this._framemgr;
        }

        @Override
        public ResourceManager getResourceManager() {
            return EditorApp.this._rmgr;
        }

        @Override
        public ImageManager getImageManager() {
            return EditorApp.this._imgr;
        }

        @Override
        public MessageManager getMessageManager() {
            return EditorApp.this._msgmgr;
        }

        @Override
        public KeyboardManager getKeyboardManager() {
            return EditorApp.this._kbdmgr;
        }

        @Override
        public ComponentRepository getComponentRepository() {
            return EditorApp.this._crepo;
        }

        @Override
        public KeyDispatcher getKeyDispatcher() {
            return EditorApp.this._keydisp;
        }

        @Override
        public String xlate(String message) {
            return this.xlate("stage.editor", message);
        }

        @Override
        public String xlate(String bundle, String message) {
            MessageBundle mbundle = EditorApp.this._msgmgr.getBundle(bundle);
            if (mbundle == null) {
                Log.log.warning((Object)"Requested to translate message with non-existent bundle", new Object[]{"bundle", bundle, "message", message});
                return message;
            }
            return mbundle.xlate(message);
        }

        @Override
        public TileSetRepository getTileSetRepository() {
            return EditorApp.this._tsrepo;
        }

        @Override
        public ColorPository getColorPository() {
            return EditorApp.this._colpos;
        }

        @Override
        public void enumerateSceneTypes(List<String> types) {
            EditorApp.this.enumerateSceneTypes(types);
        }
    }
}

