/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.stage.data;

import com.google.common.collect.Lists;
import com.threerings.crowd.data.PlaceConfig;
import com.threerings.miso.data.ObjectInfo;
import com.threerings.stage.Log;
import com.threerings.stage.data.StageMisoSceneModel;
import com.threerings.stage.data.StageSceneModel;
import com.threerings.whirled.data.SceneImpl;
import com.threerings.whirled.data.SceneUpdate;
import com.threerings.whirled.spot.data.Portal;
import com.threerings.whirled.spot.data.SpotScene;
import com.threerings.whirled.spot.data.SpotSceneImpl;
import com.threerings.whirled.spot.data.SpotSceneModel;
import java.util.ArrayList;
import java.util.Iterator;

public class StageScene
extends SceneImpl
implements SpotScene,
Cloneable {
    protected StageSceneModel _model;
    protected SpotSceneImpl _sdelegate;
    protected ArrayList<ObjectInfo> _objects = Lists.newArrayList();

    public StageScene(StageSceneModel model, PlaceConfig config) {
        super(model, config);
        this._model = model;
        this._sdelegate = new SpotSceneImpl(SpotSceneModel.getSceneModel(this._model));
        this.readInterestingObjects();
    }

    public String getType() {
        return this._model.type;
    }

    public int getZoneId() {
        return this._model.zoneId;
    }

    public void setType(String type) {
        this._model.type = type;
    }

    public int getDefaultColor(int classId) {
        return this._model.getDefaultColor(classId);
    }

    public void setDefaultColor(int classId, int colorId) {
        this._model.setDefaultColor(classId, colorId);
    }

    public Iterator<ObjectInfo> enumerateObjects() {
        return this._objects.iterator();
    }

    public void addObject(ObjectInfo info) {
        this._objects.add(info);
        StageMisoSceneModel mmodel = StageMisoSceneModel.getSceneModel(this._model);
        if (mmodel != null && !mmodel.addObject(info)) {
            Log.log.warning((Object)("Scene model rejected object add [scene=" + this + ", object=" + info + "]."), new Object[0]);
        }
    }

    public boolean removeObject(ObjectInfo info) {
        boolean removed = this._objects.remove(info);
        StageMisoSceneModel mmodel = StageMisoSceneModel.getSceneModel(this._model);
        if (mmodel != null) {
            removed = mmodel.removeObject(info) || removed;
        }
        return removed;
    }

    @Override
    public void updateReceived(SceneUpdate update) {
        super.updateReceived(update);
        this._sdelegate.updateReceived();
        this.readInterestingObjects();
    }

    public StageScene clone() throws CloneNotSupportedException {
        return new StageScene((StageSceneModel)this._model.clone(), this._config);
    }

    @Override
    public Portal getPortal(int portalId) {
        return this._sdelegate.getPortal(portalId);
    }

    @Override
    public int getPortalCount() {
        return this._sdelegate.getPortalCount();
    }

    @Override
    public Iterator<Portal> getPortals() {
        return this._sdelegate.getPortals();
    }

    @Override
    public short getNextPortalId() {
        return this._sdelegate.getNextPortalId();
    }

    @Override
    public Portal getDefaultEntrance() {
        return this._sdelegate.getDefaultEntrance();
    }

    @Override
    public void addPortal(Portal portal) {
        this._sdelegate.addPortal(portal);
    }

    @Override
    public void removePortal(Portal portal) {
        this._sdelegate.removePortal(portal);
    }

    @Override
    public void setDefaultEntrance(Portal portal) {
        this._sdelegate.setDefaultEntrance(portal);
    }

    protected void readInterestingObjects() {
        this._objects.clear();
        StageMisoSceneModel mmodel = StageMisoSceneModel.getSceneModel(this._model);
        if (mmodel != null) {
            mmodel.getInterestingObjects(this._objects);
        }
    }
}

