/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.stage.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.samskivert.swing.Controller;
import com.samskivert.swing.ControllerProvider;
import com.samskivert.swing.util.SwingUtil;
import com.samskivert.util.Tuple;
import com.threerings.crowd.client.PlaceView;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.media.tile.ObjectTile;
import com.threerings.media.tile.TileSet;
import com.threerings.media.tile.UniformTileSet;
import com.threerings.miso.client.MisoScenePanel;
import com.threerings.miso.client.SceneObject;
import com.threerings.miso.data.MisoSceneModel;
import com.threerings.miso.data.ObjectInfo;
import com.threerings.miso.util.MisoContext;
import com.threerings.miso.util.MisoSceneMetrics;
import com.threerings.miso.util.MisoUtil;
import com.threerings.stage.Log;
import com.threerings.stage.client.SceneColorizer;
import com.threerings.stage.data.StageLocation;
import com.threerings.stage.data.StageMisoSceneModel;
import com.threerings.stage.data.StageScene;
import com.threerings.stage.util.StageContext;
import com.threerings.stage.util.StageSceneUtil;
import com.threerings.whirled.data.SceneUpdate;
import com.threerings.whirled.spot.data.Cluster;
import com.threerings.whirled.spot.data.Location;
import com.threerings.whirled.spot.data.Portal;
import com.threerings.whirled.spot.data.SceneLocation;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

public class StageScenePanel
extends MisoScenePanel
implements ControllerProvider,
KeyListener,
PlaceView {
    public static final String LOCATION_CLICKED = "LocationClicked";
    public static final String CLUSTER_CLICKED = "ClusterClicked";
    public static final int SHOW_CLUSTERS = 2;
    public static final int SHOW_PLOTS = 4;
    protected StageContext _ctx;
    protected Controller _ctrl;
    protected StageScene _scene;
    protected List<SceneObject> _portobjs = Lists.newArrayList();
    protected Map<Cluster, Shape> _clusters = Maps.newHashMap();
    protected Map<Cluster, Shape> _clusterWells = Maps.newHashMap();
    protected SceneColorizer _rizer;
    protected static final int PORTAL_ICON_WIDTH = 48;
    protected static final int PORTAL_ICON_HEIGHT = 48;
    protected static final int MAX_LOCATION_DIST = 25;
    protected static final int CLUSTER_PAD = 4;
    protected static final Stroke CLUSTER_STROKE = new BasicStroke(4.0f);
    protected static final Color CLUSTER_COLOR = Color.ORANGE;
    protected static final Composite HIGHLIGHT_ALPHA = AlphaComposite.getInstance(3, 0.3f);
    protected static final Composite SHOWN_ALPHA = AlphaComposite.getInstance(3, 0.15f);
    protected static final Composite INACTIVE_PORTAL_ALPHA = HIGHLIGHT_ALPHA;
    protected static final int CLUSTER_SLOP = 25;

    public StageScenePanel(StageContext ctx, Controller ctrl) {
        super((MisoContext)ctx, StageSceneUtil.getMetrics());
        this._ctx = ctx;
        this._ctrl = ctrl;
        this._ctrl.setControlledPanel((JComponent)((Object)this));
        this.setLayout(null);
    }

    public SceneColorizer getColorizer() {
        return this._rizer;
    }

    protected TileSet.Colorizer getColorizer(ObjectInfo oinfo) {
        return this._rizer.getColorizer(oinfo);
    }

    public StageScene getScene() {
        return this._scene;
    }

    public void setScene(StageScene scene) {
        this._scene = scene;
        if (this._scene != null) {
            this._rizer = new SceneColorizer(this._ctx.getColorPository(), scene);
            this.recomputePortals();
            this.setSceneModel((MisoSceneModel)StageMisoSceneModel.getSceneModel(scene.getSceneModel()));
        } else {
            Log.log.warning((Object)"Zoiks! We can't display a null scene!", new Object[0]);
        }
    }

    public void sceneUpdated(SceneUpdate update) {
        this.recomputePortals();
        this.refreshScene();
    }

    protected void recomputePortals() {
        UniformTileSet ots = this.loadPortalTileSet();
        this._portobjs.clear();
        Iterator<Portal> iter = this._scene.getPortals();
        while (iter.hasNext()) {
            Portal portal = iter.next();
            StageLocation loc = (StageLocation)portal.loc;
            Point p = this.getScreenCoords(loc.x, loc.y);
            int tx = MisoUtil.fullToTile((int)loc.x);
            int ty = MisoUtil.fullToTile((int)loc.y);
            Point ts = MisoUtil.tileToScreen((MisoSceneMetrics)this._metrics, (int)tx, (int)ty, (Point)new Point());
            ObjectInfo info = new ObjectInfo(0, tx, ty);
            info.action = "portal:" + portal.portalId;
            PortalObjectTile tile = new PortalObjectTile(ts.x + this._metrics.tilehwid - p.x + 24, ts.y + this._metrics.tilehei - p.y + 24);
            tile.setImage(ots.getTileMirage((int)loc.orient));
            this._portobjs.add(new SceneObject(this, info, tile){

                public boolean setHovered(boolean hovered) {
                    ((PortalObjectTile)this.tile).hovered = hovered;
                    return StageScenePanel.this.isResponsive();
                }
            });
        }
    }

    protected void recomputeVisible() {
        super.recomputeVisible();
        int ll = this._portobjs.size();
        for (int ii = 0; ii < ll; ++ii) {
            SceneObject pobj = this._portobjs.get(ii);
            if (pobj.bounds == null || !this._vbounds.intersects(pobj.bounds)) continue;
            this._vizobjs.add(pobj);
        }
    }

    public Controller getController() {
        return this._ctrl;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 18) {
            this.setShowFlags(1, true);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 18) {
            this.setShowFlags(1, this.defaultShowTips());
        }
    }

    public void willEnterPlace(PlaceObject plobj) {
    }

    public void didLeavePlace(PlaceObject plobj) {
    }

    protected boolean defaultShowTips() {
        return false;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    protected boolean handleMousePressed(Object hobject, MouseEvent event) {
        if (super.handleMousePressed(hobject, event)) {
            return true;
        }
        if (event.getButton() == 1) {
            if (hobject instanceof Cluster) {
                Tuple actarg = new Tuple(hobject, (Object)event.getPoint());
                Controller.postAction((Component)((Object)this), (String)CLUSTER_CLICKED, (Object)actarg);
            } else {
                Point lc = MisoUtil.screenToFull((MisoSceneMetrics)this._metrics, (int)event.getX(), (int)event.getY(), (Point)new Point());
                Controller.postAction((Component)((Object)this), (String)LOCATION_CLICKED, (Object)new StageLocation(lc.x, lc.y, 0));
            }
            return true;
        }
        return false;
    }

    protected void showFlagsDidChange(int oldflags) {
        super.showFlagsDidChange(oldflags);
        if ((oldflags & 2) != (this._showFlags & 2)) {
            for (Shape shape : this._clusters.values()) {
                this.dirtyCluster(shape);
            }
        }
    }

    protected void clusterUpdated(Cluster cluster) {
        List<SceneLocation> spots = StageSceneUtil.getClusterLocs(cluster);
        Rectangle cbounds = null;
        int ll = spots.size();
        for (int ii = 0; ii < ll; ++ii) {
            StageLocation loc = (StageLocation)spots.get((int)ii).loc;
            Point sp = this.getScreenCoords(loc.x, loc.y);
            if (cbounds == null) {
                cbounds = new Rectangle(sp.x, sp.y, 0, 0);
                continue;
            }
            cbounds.add(sp.x, sp.y);
        }
        if (cbounds == null) {
            this.removeCluster(cluster.clusterOid);
        } else {
            this.updateCluster(cluster, cbounds);
        }
    }

    public void updateCluster(Cluster cluster, Rectangle bounds) {
        this.dirtyCluster(cluster);
        Ellipse2D.Float shape = new Ellipse2D.Float(bounds.x, bounds.y, bounds.width, bounds.height);
        this._clusters.put(cluster, shape);
        Ellipse2D.Float mshape = new Ellipse2D.Float(bounds.x - 25, bounds.y - 25, bounds.width + 50, bounds.height + 50);
        this._clusterWells.put(cluster, mshape);
        this.dirtyCluster(shape);
    }

    public boolean removeCluster(int clusterOid) {
        Cluster key = new Cluster();
        key.clusterOid = clusterOid;
        this._clusterWells.remove(key);
        Shape shape = this._clusters.remove(key);
        if (shape == null) {
            return false;
        }
        this.dirtyCluster(shape);
        if (this._hobject instanceof Cluster && ((Cluster)this._hobject).clusterOid == clusterOid) {
            this._hobject = null;
        }
        return true;
    }

    protected void hoverObjectChanged(Object oldHover, Object newHover) {
        super.hoverObjectChanged(oldHover, newHover);
        if (oldHover instanceof Cluster) {
            this.dirtyCluster((Cluster)oldHover);
        }
        if (newHover instanceof Cluster) {
            this.dirtyCluster((Cluster)newHover);
        }
    }

    protected Object computeOverHover(int mx, int my) {
        return null;
    }

    protected Object computeUnderHover(int mx, int my) {
        Cluster cluster;
        if (!this.isResponsive()) {
            return null;
        }
        if (this._hobject instanceof Cluster && this.containsPoint(cluster = (Cluster)this._hobject, mx, my)) {
            return cluster;
        }
        for (Cluster cluster2 : this._clusters.keySet()) {
            if (!this.containsPoint(cluster2, mx, my)) continue;
            return cluster2;
        }
        return null;
    }

    protected boolean containsPoint(Cluster cluster, int mx, int my) {
        Shape shape = this._clusterWells.get(cluster);
        return shape == null ? false : shape.contains(mx, my);
    }

    protected void dirtyCluster(Cluster cluster) {
        if (cluster != null) {
            this.dirtyCluster(this._clusters.get(cluster));
        }
    }

    protected void dirtyCluster(Shape shape) {
        if (shape != null) {
            Rectangle r = shape.getBounds();
            this._remgr.invalidateRegion(r.x - 2, r.y - 2, r.width + 6, r.height + 6);
        }
    }

    public Portal getPortal(int fullX, int fullY) {
        Iterator<Portal> iter = this._scene.getPortals();
        while (iter.hasNext()) {
            Portal portal = iter.next();
            StageLocation loc = (StageLocation)portal.loc;
            if (loc.x != fullX || loc.y != fullY) continue;
            return portal;
        }
        return null;
    }

    protected void paintBaseDecorations(Graphics2D gfx, Rectangle clip) {
        super.paintBaseDecorations(gfx, clip);
        this.paintClusters(gfx, clip);
    }

    protected void paintClusters(Graphics2D gfx, Rectangle clip) {
        Object oalias = SwingUtil.activateAntiAliasing((Graphics2D)gfx);
        Composite ocomp = gfx.getComposite();
        Stroke ostroke = gfx.getStroke();
        gfx.setStroke(CLUSTER_STROKE);
        gfx.setColor(CLUSTER_COLOR);
        if (this.checkShowFlag(2)) {
            for (Cluster cluster : this._clusters.keySet()) {
                this.drawCluster(gfx, clip, cluster);
            }
        } else if (this._hobject instanceof Cluster) {
            this.drawCluster(gfx, clip, (Cluster)this._hobject);
        }
        gfx.setComposite(ocomp);
        gfx.setStroke(ostroke);
        SwingUtil.restoreAntiAliasing((Graphics2D)gfx, (Object)oalias);
    }

    protected void drawCluster(Graphics2D gfx, Rectangle clip, Cluster cluster) {
        Shape shape = this._clusters.get(cluster);
        if (shape != null && shape.intersects(clip)) {
            if (this._hobject == cluster) {
                gfx.setComposite(HIGHLIGHT_ALPHA);
            } else {
                gfx.setComposite(SHOWN_ALPHA);
            }
            gfx.draw(shape);
        }
    }

    protected boolean isPortal(Location loc) {
        if (this._scene == null) {
            return false;
        }
        Iterator<Portal> iter = this._scene.getPortals();
        while (iter.hasNext()) {
            if (!loc.equals(iter.next().loc)) continue;
            return true;
        }
        return false;
    }

    protected UniformTileSet loadPortalTileSet() {
        return this._ctx.getTileManager().loadTileSet("media/stage/portal_arrows.png", 48, 48);
    }

    protected class PortalObjectTile
    extends ObjectTile {
        public boolean hovered;

        public PortalObjectTile(int ox, int oy) {
            this.setOrigin(ox, oy);
        }

        public void paint(Graphics2D gfx, int x, int y) {
            Composite ocomp = gfx.getComposite();
            if (!StageScenePanel.this.isResponsive() || !this.hovered) {
                gfx.setComposite(INACTIVE_PORTAL_ALPHA);
            }
            super.paint(gfx, x, y);
            gfx.setComposite(ocomp);
        }
    }
}

