/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.puzzle.drop.data;

import com.samskivert.util.StringUtil;
import com.threerings.puzzle.Log;
import com.threerings.puzzle.data.Board;
import com.threerings.puzzle.drop.data.DropPieceCodes;
import com.threerings.puzzle.drop.util.DropBoardUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;

public class DropBoard
extends Board
implements DropPieceCodes {
    public static final int RADIAL_ROTATION = 0;
    public static final int INPLACE_ROTATION = 1;
    public static final PieceOperation CLEAR_OP = new PieceOperation(){

        @Override
        public boolean execute(DropBoard board, int col, int row) {
            board.setPiece(col, row, -1);
            return true;
        }
    };
    protected int[] _board;
    protected int _bwid;
    protected int _bhei;
    protected transient Rectangle _bounds;
    protected static final int[][][] ROTATE_DX = new int[][][]{new int[][]{{0, 0, 0, 0}, {0, 0, 0, 0}}, new int[][]{{-1, 1, 0, 0}, {-1, 0, 0, 1}}};
    protected static final int[][][] ROTATE_DY = new int[][][]{new int[][]{{0, 0, 0, 0}, {0, 0, 0, 0}}, new int[][]{{-1, 0, 0, 1}, {0, 0, -1, 1}}};
    protected static final int[] ORIENT_WIDTHS = new int[]{2, 1, 2, 1};
    protected static final int[] ORIENT_HEIGHTS = new int[]{1, 2, 1, 2};
    protected static final int[] ORIENT_ORIGIN_DX = new int[]{-1, 0, 0, 0};
    protected static final int[] ORIENT_ORIGIN_DY = new int[]{0, 0, 0, 1};
    protected static final int[] COERCE_DX = new int[]{0, 1, -1};
    protected static final SetSegmentOperation _setSegmentOp = new SetSegmentOperation();
    protected static final SetPieceOperation _setPieceOp = new SetPieceOperation();
    protected static final int DEFAULT_PAD_WIDTH = 3;

    public DropBoard() {
        this(null, 0, 0);
    }

    public DropBoard(int bwid, int bhei) {
        this(new int[bwid * bhei], bwid, bhei);
        this.fill(-1);
    }

    public DropBoard(int bwid, int bhei, int piece) {
        this(new int[bwid * bhei], bwid, bhei);
        this.fill(piece);
    }

    public DropBoard(int[] board, int bwid, int bhei) {
        this._board = board;
        this._bwid = bwid;
        this._bhei = bhei;
    }

    public int getWidth() {
        return this._bwid;
    }

    public int getHeight() {
        return this._bhei;
    }

    public int getPiece(int col, int row) {
        if (!this.inBounds(col, row)) {
            Log.log.warning((Object)"Requested piece from invalid coordinate", new Object[]{"col", col, "row", row, "width", this._bwid, "height", this._bhei});
        }
        try {
            return this._board[this.coordsToIndex(col, row)];
        }
        catch (Exception e) {
            Log.log.warning((Object)"Failed getting piece", new Object[]{"col", col, "row", row, e});
            return -1;
        }
    }

    public int getNextPiece() {
        return -1;
    }

    public int getDropDistance(int col, int row) {
        int dist = 0;
        for (int yy = row + 1; yy < this._bhei; ++yy) {
            if (this.getPiece(col, yy) != -1) {
                return dist;
            }
            ++dist;
        }
        return dist;
    }

    public boolean isRowEmpty(int row) {
        for (int col = 0; col < this._bwid; ++col) {
            if (this.getPiece(col, row) == -1) continue;
            return false;
        }
        return true;
    }

    public boolean isValidDrop(int[] rows, int[] cols, float pctdone) {
        int bottom = this._bhei - 1;
        for (int ii = 0; ii < rows.length; ++ii) {
            if (rows[ii] >= bottom) {
                return false;
            }
            int row = rows[ii] + 1;
            if (row < 0 || this.getPiece(cols[ii], row) == -1) continue;
            return false;
        }
        return true;
    }

    public boolean inBounds(int col, int row) {
        return col >= 0 && row >= 0 && col < this.getWidth() && row < this.getHeight();
    }

    public boolean isBlockEmpty(int col, int row, int wid, int hei) {
        for (int ypos = row; ypos > row - hei; --ypos) {
            for (int xpos = col; xpos < col + wid; ++xpos) {
                if (ypos < 0) {
                    if (xpos >= 0 && xpos < this._bwid && this.getPiece(xpos, 0) == -1) continue;
                    return false;
                }
                if (xpos < 0 || xpos >= this._bwid || ypos >= this._bhei) {
                    return false;
                }
                if (this.getPiece(xpos, ypos) == -1) continue;
                return false;
            }
        }
        return true;
    }

    public int[] getForgivingRotation(int[] rows, int[] cols, int orient, int dir, int rtype, float pctdone, boolean canPopup) {
        int px = cols[0];
        int py = rows[0];
        for (int ii = 0; ii < 4; ++ii) {
            int oidx = orient / 2;
            px += ROTATE_DX[rtype][dir][oidx];
            py += ROTATE_DY[rtype][dir][oidx];
            orient = DropBoardUtil.getRotatedOrientation(orient, dir);
            oidx = orient / 2;
            int ox = px + ORIENT_ORIGIN_DX[oidx];
            int oy = py + ORIENT_ORIGIN_DY[oidx];
            if ((double)pctdone > 0.5) {
                ++oy;
            }
            for (int cx : COERCE_DX) {
                if (!this.isBlockEmpty(ox + cx, oy, ORIENT_WIDTHS[oidx], ORIENT_HEIGHTS[oidx])) continue;
                return new int[]{orient, px + cx, py, 0};
            }
            if (!canPopup || rtype != 0 || orient != 7 || !this.isBlockEmpty(ox, oy - 1, ORIENT_WIDTHS[oidx], ORIENT_HEIGHTS[oidx])) continue;
            return new int[]{orient, px, py - 1, 1};
        }
        Log.log.warning((Object)"**** We're horked and couldn't rotate at all!", new Object[0]);
        return null;
    }

    public Point getForgivingMove(int col, int row, int wid, int hei, int dx, int dy, float pctdone) {
        int xpos = col + dx;
        int ypos = row + dy;
        if ((double)pctdone >= 0.5) {
            ++ypos;
        }
        return this.isBlockEmpty(xpos, ypos, wid, hei) ? new Point(xpos, row + dy) : null;
    }

    public void getColumnLevels(byte[] columns) {
        int bwid = this.getWidth();
        int bhei = this.getHeight();
        for (int col = 0; col < bwid; ++col) {
            int dist = this.getDropDistance(col, -1);
            columns[col] = (byte)(bhei - dist);
        }
    }

    public void applyRisingPieces(int[] pieces) {
        int xx;
        int end = this._bhei - 1;
        for (int yy = 0; yy < end; ++yy) {
            for (xx = 0; xx < this._bwid; ++xx) {
                this.setPiece(xx, yy, this.getPiece(xx, yy + 1));
            }
        }
        int ypos = this._bhei - 1;
        for (xx = 0; xx < this._bwid; ++xx) {
            this.setPiece(xx, ypos, pieces[xx]);
        }
    }

    public boolean rowContainsPieces(int row, int blankPiece) {
        for (int x = 0; x < this._bwid; ++x) {
            if (this.getPiece(x, row) == blankPiece) continue;
            return true;
        }
        return false;
    }

    public void fill(int piece) {
        Arrays.fill(this._board, piece);
    }

    public boolean setPiece(int col, int row, int piece) {
        if (col >= 0 && row >= 0 && col < this._bwid && row < this._bhei) {
            this._board[this.coordsToIndex((int)col, (int)row)] = piece;
            return true;
        }
        Log.log.warning((Object)"Attempt to set piece outside board bounds", new Object[]{"col", col, "row", row, "p", piece});
        return false;
    }

    public void setRect(int x, int y, int width, int height, int piece) {
        for (int yy = y; yy > y - height; --yy) {
            for (int xx = x; xx < x + width; ++xx) {
                this.setPiece(xx, yy, piece);
            }
        }
    }

    public boolean setSegment(int dir, int col, int row, int len, int piece) {
        _setPieceOp.init(piece);
        this.applyOp(dir, col, row, len, _setPieceOp);
        return !_setPieceOp.getError();
    }

    public void setSegment(int dir, int col, int row, int[] pieces) {
        _setSegmentOp.init(dir, pieces);
        this.applyOp(dir, col, row, pieces.length, _setSegmentOp);
    }

    public void applyOp(int dir, int col, int row, PieceOperation op) {
        int len = dir == 0 ? this._bwid - col : row + 1;
        this.applyOp(dir, col, row, len, op);
    }

    public void applyOp(int dir, int col, int row, int len, PieceOperation op) {
        if (dir == 0) {
            int end = Math.min(col + len, this._bwid);
            for (int ii = col; ii < end && op.execute(this, ii, row); ++ii) {
            }
        } else {
            int end = Math.max(row - len, -1);
            for (int ii = row; ii > end && op.execute(this, col, ii); --ii) {
            }
        }
    }

    public void applyOp(int col, int row, PieceOperation op) {
        op.execute(this, col, row);
    }

    @Override
    public void dump() {
        this.dumpAndCompare(null);
    }

    @Override
    public void dumpAndCompare(Board other) {
        if (other != null && !(other instanceof DropBoard)) {
            throw new IllegalArgumentException("Can't compare drop board to non-drop-board.");
        }
        DropBoard dother = (DropBoard)other;
        int padwid = this.getPadWidth();
        if (other != null) {
            padwid *= 2;
        }
        for (int y = 0; y < this._bhei; ++y) {
            StringBuilder buf = new StringBuilder();
            for (int x = 0; x < this._bwid; ++x) {
                int opiece;
                int piece = this.getPiece(x, y);
                String str = this.formatPiece(piece);
                if (dother != null && (opiece = dother.getPiece(x, y)) != piece) {
                    str = str + "|" + this.formatPiece(opiece);
                }
                buf.append(StringUtil.pad((String)str, (int)padwid));
            }
            System.err.println(buf.toString());
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[wid=").append(this._bwid);
        buf.append(", hei=").append(this._bhei);
        return buf.append("]").toString();
    }

    @Override
    public boolean equals(Board other) {
        if (!this.getClass().getName().equals(other.getClass().getName())) {
            throw new IllegalArgumentException("Can't compare board of different class types [src=" + this.getClass().getName() + ", other=" + other.getClass().getName() + "].");
        }
        DropBoard dother = (DropBoard)other;
        if (dother.getWidth() != this._bwid || dother.getHeight() != this._bhei) {
            return false;
        }
        for (int xx = 0; xx < this._bwid; ++xx) {
            for (int yy = 0; yy < this._bhei; ++yy) {
                if (this.getPiece(xx, yy) == dother.getPiece(xx, yy)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isValidPosition(int x, int y) {
        return x >= 0 && y >= 0 && x < this._bwid && y < this._bhei;
    }

    public Rectangle getBounds() {
        if (this._bounds == null) {
            this._bounds = new Rectangle(0, 0, this._bwid, this._bhei);
        }
        return this._bounds;
    }

    public int size() {
        return this._bwid * this._bhei;
    }

    public void copyInto(DropBoard board) {
        if (board.getWidth() != this._bwid || board.getHeight() != this._bhei) {
            Log.log.warning((Object)"Can't copy board into destination board with different dimensions", new Object[]{"src", this, "dest", board});
            return;
        }
        int[] dest = board.getBoard();
        System.arraycopy(this._board, 0, dest, 0, this._bwid * this._bhei);
    }

    public int[] getBoard() {
        return this._board;
    }

    public void setBoard(int[] board, int bwid, int bhei) {
        this._board = board;
        this._bwid = bwid;
        this._bhei = bhei;
    }

    public void setBoard(int[] board) {
        int size = this.size();
        if (board.length < size) {
            Log.log.warning((Object)"Attempt to set board with invalid data size", new Object[]{"len", board.length, "expected", size});
            return;
        }
        this._board = board;
    }

    @Override
    public DropBoard clone() {
        DropBoard board = (DropBoard)super.clone();
        board._board = (int[])this._board.clone();
        return board;
    }

    protected int coordsToIndex(int col, int row) {
        return row * this._bwid + col;
    }

    protected int indexToCol(int idx) {
        return idx % this._bwid;
    }

    protected int indexToRow(int idx) {
        return idx / this._bwid;
    }

    protected int getPadWidth() {
        return 3;
    }

    protected String formatPiece(int piece) {
        return piece == -1 ? "." : String.valueOf(piece);
    }

    protected static class SetPieceOperation
    implements PieceOperation {
        protected int _piece;
        protected boolean _error;

        protected SetPieceOperation() {
        }

        public void init(int piece) {
            this._piece = piece;
            this._error = false;
        }

        public boolean getError() {
            return this._error;
        }

        @Override
        public boolean execute(DropBoard board, int col, int row) {
            if (!board.setPiece(col, row, this._piece)) {
                this._error = true;
            }
            return true;
        }
    }

    protected static class SetSegmentOperation
    implements PieceOperation {
        protected int _dir;
        protected int _idx;
        protected int[] _pieces;

        protected SetSegmentOperation() {
        }

        public void init(int dir, int[] pieces) {
            this._dir = dir;
            this._pieces = pieces;
            this._idx = dir == 0 ? this._pieces.length - 1 : 0;
        }

        @Override
        public boolean execute(DropBoard board, int col, int row) {
            if (this._dir == 0) {
                board.setPiece(col, row, this._pieces[this._idx--]);
            } else {
                board.setPiece(col, row, this._pieces[this._idx++]);
            }
            return true;
        }
    }

    public static interface PieceOperation {
        public boolean execute(DropBoard var1, int var2, int var3);
    }
}

