/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.puzzle.data;

import com.threerings.io.Streamable;
import java.util.Random;

public abstract class Board
implements Cloneable,
Streamable {
    protected transient BoardRandom _rando;

    public abstract void dump();

    public abstract void dumpAndCompare(Board var1);

    public abstract boolean equals(Board var1);

    public Board clone() {
        try {
            Board board = (Board)super.clone();
            board._rando = this._rando.clone();
            return board;
        }
        catch (CloneNotSupportedException cnse) {
            throw new AssertionError((Object)cnse);
        }
    }

    public void initializeSeed(long seed) {
        this._rando = new BoardRandom(seed);
        this.populate();
    }

    public Random getRandom() {
        return this._rando;
    }

    protected void populate() {
    }

    public void seedFromEvent(int pidx, int gevent) {
        if (this.isSeedingEvent(pidx, gevent)) {
            int jj = this.getSeedForEvent(pidx, gevent);
            for (int ii = 0; ii < jj; ++ii) {
                this._rando.next(0);
            }
        }
    }

    protected boolean isSeedingEvent(int pidx, int gevent) {
        return false;
    }

    protected int getSeedForEvent(int pidx, int gevent) {
        return (pidx ^ gevent) % 7;
    }

    protected static class BoardRandom
    extends Random
    implements Cloneable {
        protected long _seed;
        protected double _nextNextGaussian;
        protected boolean _haveNextNextGaussian = false;
        private static final long multiplier = 25214903917L;
        private static final long addend = 11L;
        private static final long mask = 0xFFFFFFFFFFFFL;

        public BoardRandom(long seed) {
            super(0L);
            this.setSeed(seed);
        }

        @Override
        public synchronized void setSeed(long seed) {
            this._seed = (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
        }

        @Override
        protected synchronized int next(int bits) {
            long nextseed;
            this._seed = nextseed = this._seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
            return (int)(nextseed >>> 48 - bits);
        }

        @Override
        public void nextBytes(byte[] bytes) {
            this.unimplemented();
        }

        @Override
        public int nextInt(int n) {
            int val;
            int bits;
            if (n <= 0) {
                throw new IllegalArgumentException("n must be positive");
            }
            if ((n & -n) == n) {
                return (int)((long)n * (long)this.next(31) >> 31);
            }
            while ((bits = this.next(31)) - (val = bits % n) + (n - 1) < 0) {
            }
            return val;
        }

        @Override
        public double nextDouble() {
            long l = ((long)this.next(26) << 27) + (long)this.next(27);
            return (double)l / 9.007199254740992E15;
        }

        @Override
        public synchronized double nextGaussian() {
            double v2;
            double v1;
            double s;
            if (this._haveNextNextGaussian) {
                this._haveNextNextGaussian = false;
                return this._nextNextGaussian;
            }
            while ((s = (v1 = 2.0 * this.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.nextDouble() - 1.0) * v2) >= 1.0 || s == 0.0) {
            }
            double multiplier = Math.sqrt(-2.0 * Math.log(s) / s);
            this._nextNextGaussian = v2 * multiplier;
            this._haveNextNextGaussian = true;
            return v1 * multiplier;
        }

        public BoardRandom clone() {
            try {
                return (BoardRandom)super.clone();
            }
            catch (CloneNotSupportedException cnse) {
                throw new AssertionError((Object)cnse);
            }
        }

        private final void unimplemented() {
            throw new RuntimeException("The Random method you attempted to call has not been implemented by BoardRandom.");
        }
    }
}

