/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.parlor.card.data;

import com.threerings.parlor.card.data.Card;
import com.threerings.parlor.card.data.CardCodes;
import com.threerings.parlor.card.data.Hand;
import com.threerings.util.StreamableArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class Deck
extends StreamableArrayList<Card>
implements CardCodes {
    public Deck() {
        this.reset(false);
    }

    public Deck(boolean includeJokers) {
        this.reset(includeJokers);
    }

    public void reset(boolean includeJokers) {
        this.clear();
        for (int ii = 0; ii <= 3; ++ii) {
            for (int j = 2; j <= 14; ++j) {
                this.add(new Card(j, ii));
            }
        }
        if (includeJokers) {
            this.add(new Card(15, 3));
            this.add(new Card(16, 3));
        }
    }

    public void shuffle() {
        Collections.shuffle(this);
    }

    public void shuffle(Random r) {
        Collections.shuffle(this, r);
    }

    public Hand dealHand(int size) {
        int dsize = this.size();
        if (dsize < size) {
            return null;
        }
        Hand hand = new Hand();
        List sublist = this.subList(dsize - size, dsize);
        hand.addAll(sublist);
        sublist.clear();
        return hand;
    }

    public void returnHand(Hand hand) {
        this.addAll((Collection)((Object)hand));
        hand.clear();
    }
}

