/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.micasa.lobby;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.samskivert.util.StringUtil;
import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.data.PlaceConfig;
import com.threerings.crowd.server.PlaceRegistry;
import com.threerings.micasa.Log;
import com.threerings.micasa.lobby.Lobby;
import com.threerings.micasa.lobby.LobbyConfig;
import com.threerings.micasa.lobby.LobbyManager;
import com.threerings.micasa.lobby.LobbyMarshaller;
import com.threerings.micasa.lobby.LobbyProvider;
import com.threerings.micasa.lobby.LobbyService;
import com.threerings.micasa.server.MiCasaConfig;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.server.InvocationManager;
import com.threerings.presents.server.InvocationProvider;
import com.threerings.util.StreamableArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class LobbyRegistry
implements LobbyProvider {
    @Inject
    protected PlaceRegistry _plreg;
    protected Map<String, List<Lobby>> _lobbies = Maps.newHashMap();
    protected int _defLobbyOid = -1;
    protected static final String LOBIDS_KEY = "lobby_ids";

    @Inject
    public LobbyRegistry(InvocationManager invmgr) {
        invmgr.registerProvider((InvocationProvider)this, LobbyMarshaller.class, "presents");
    }

    public void init() {
        String[] lmgrs = null;
        if ((lmgrs = MiCasaConfig.config.getValue(LOBIDS_KEY, lmgrs)) == null || lmgrs.length == 0) {
            Log.log.warning((Object)"No lobbies specified in config file (via 'lobby_ids' parameter).", new Object[0]);
        } else {
            for (String lmgr : lmgrs) {
                this.loadLobby(lmgr);
            }
        }
    }

    public int getDefaultLobbyOid() {
        return this._defLobbyOid;
    }

    protected void loadLobby(String lobbyId) {
        try {
            Properties props = MiCasaConfig.config.getSubProperties(lobbyId);
            String cfgClass = props.getProperty("config");
            if (StringUtil.isBlank((String)cfgClass)) {
                throw new Exception("Missing 'config' definition in lobby configuration.");
            }
            LobbyConfig config = (LobbyConfig)((Object)Class.forName(cfgClass).newInstance());
            config.init(props);
            LobbyManager lobmgr = (LobbyManager)this._plreg.createPlace((PlaceConfig)config);
            lobmgr.init(this, props);
        }
        catch (Exception e) {
            Log.log.warning((Object)("Unable to create lobby manager [lobbyId=" + lobbyId + ", error=" + e + "]."), new Object[0]);
        }
    }

    public void getLobbies(BodyObject requester, String category, List<Lobby> target) {
        List<Lobby> list = this._lobbies.get(category);
        if (list != null) {
            target.addAll(list);
        }
    }

    public String[] getCategories(BodyObject requester) {
        String[] cats = new String[this._lobbies.size()];
        Iterator<String> iter = this._lobbies.keySet().iterator();
        int ii = 0;
        while (iter.hasNext()) {
            cats[ii] = iter.next();
            ++ii;
        }
        return cats;
    }

    @Override
    public void getCategories(ClientObject caller, LobbyService.CategoriesListener listener) {
        listener.gotCategories(this.getCategories((BodyObject)caller));
    }

    @Override
    public void getLobbies(ClientObject caller, String category, LobbyService.LobbiesListener listener) {
        StreamableArrayList target = StreamableArrayList.newList();
        List<Lobby> list = this._lobbies.get(category);
        if (list != null) {
            target.addAll(list);
        }
        listener.gotLobbies((List<Lobby>)target);
    }

    protected void lobbyReady(int placeOid, String gameIdent, String name) {
        Lobby record = new Lobby(placeOid, gameIdent, name);
        if (this._defLobbyOid == -1) {
            this._defLobbyOid = placeOid;
        }
        StringTokenizer tok = new StringTokenizer(gameIdent, ",");
        while (tok.hasMoreTokens()) {
            String category = tok.nextToken();
            this.registerLobby(category, record);
        }
    }

    protected void registerLobby(String category, Lobby record) {
        ArrayList catlist = this._lobbies.get(category);
        if (catlist == null) {
            catlist = Lists.newArrayList();
            this._lobbies.put(category, catlist);
        }
        catlist.add(record);
        Log.log.info((Object)"Registered lobby", new Object[]{"cat", category, "record", record});
    }
}

