/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.whirled.spot.data;

import com.samskivert.util.HashIntMap;
import com.threerings.whirled.spot.Log;
import com.threerings.whirled.spot.data.Portal;
import com.threerings.whirled.spot.data.SpotScene;
import com.threerings.whirled.spot.data.SpotSceneModel;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpotSceneImpl
implements SpotScene {
    protected SpotSceneModel _smodel;
    protected HashIntMap<Portal> _portals = new HashIntMap();
    protected static final int MAX_PORTAL_ID = Short.MAX_VALUE;

    public SpotSceneImpl(SpotSceneModel smodel) {
        this._smodel = smodel;
        this.readPortals();
    }

    protected void readPortals() {
        this._portals.clear();
        Portal[] portalArray = this._smodel.portals;
        int n = this._smodel.portals.length;
        int n2 = 0;
        while (n2 < n) {
            Portal port = portalArray[n2];
            this._portals.put((int)port.portalId, (Object)port);
            ++n2;
        }
    }

    public SpotSceneImpl() {
        this._smodel = new SpotSceneModel();
    }

    @Override
    public Portal getPortal(int portalId) {
        if (portalId == -1) {
            portalId = this._smodel.defaultEntranceId;
        }
        return (Portal)this._portals.get(portalId);
    }

    @Override
    public int getPortalCount() {
        return this._portals.size();
    }

    @Override
    public Iterator<Portal> getPortals() {
        return this._portals.values().iterator();
    }

    @Override
    public short getNextPortalId() {
        short ii = 1;
        while (ii < Short.MAX_VALUE) {
            if (!this._portals.containsKey((int)ii)) {
                return ii;
            }
            ii = (short)(ii + 1);
        }
        return -1;
    }

    @Override
    public Portal getDefaultEntrance() {
        return this.getPortal(-1);
    }

    @Override
    public void addPortal(Portal portal) {
        if (portal.portalId <= 0) {
            Log.log.warning((Object)"Refusing to add zero-id portal", new Object[]{"scene", this, "portal", portal});
            return;
        }
        this._smodel.addPortal(portal);
        this._portals.put((int)portal.portalId, (Object)portal);
    }

    @Override
    public void removePortal(Portal portal) {
        this._portals.remove((int)portal.portalId);
        this._smodel.removePortal(portal);
    }

    public void setDefaultEntranceId(int defaultEntranceId) {
        this._smodel.defaultEntranceId = defaultEntranceId;
    }

    @Override
    public void setDefaultEntrance(Portal portal) {
        this._smodel.defaultEntranceId = portal == null ? -1 : (int)portal.portalId;
    }

    public void updateReceived() {
        this.readPortals();
    }
}

