/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.stage.tools.editor;

import com.google.common.collect.Lists;
import com.samskivert.swing.Controller;
import com.samskivert.swing.TGraphics2D;
import com.samskivert.swing.util.SwingUtil;
import com.samskivert.util.RandomUtil;
import com.threerings.media.tile.ObjectTile;
import com.threerings.media.tile.Tile;
import com.threerings.media.tile.TileUtil;
import com.threerings.miso.client.MisoScenePanel;
import com.threerings.miso.client.ObjectActionHandler;
import com.threerings.miso.client.SceneBlock;
import com.threerings.miso.client.SceneObject;
import com.threerings.miso.data.MisoSceneModel;
import com.threerings.miso.data.ObjectInfo;
import com.threerings.miso.data.SparseMisoSceneModel;
import com.threerings.miso.util.MisoSceneMetrics;
import com.threerings.miso.util.MisoUtil;
import com.threerings.stage.Log;
import com.threerings.stage.client.StageScenePanel;
import com.threerings.stage.data.StageLocation;
import com.threerings.stage.data.StageMisoSceneModel;
import com.threerings.stage.tools.editor.EditorModel;
import com.threerings.stage.tools.editor.EditorModelListener;
import com.threerings.stage.tools.editor.EditorScrollBox;
import com.threerings.stage.tools.editor.ObjectEditorDialog;
import com.threerings.stage.tools.editor.PortalDialog;
import com.threerings.stage.tools.editor.PortalTool;
import com.threerings.stage.tools.editor.util.EditorContext;
import com.threerings.stage.tools.editor.util.EditorDialogUtil;
import com.threerings.stage.tools.editor.util.ExtrasPainter;
import com.threerings.whirled.spot.data.Portal;
import com.threerings.whirled.spot.tools.EditablePortal;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EditorScenePanel
extends StageScenePanel
implements EditorModelListener,
ChangeListener {
    protected static final int MAX_UNDO_SIZE = 20;
    protected EditorContext _ctx;
    protected EditorModel _emodel;
    protected EditorScrollBox _box;
    protected boolean _refreshBox;
    protected JFrame _frame;
    protected BoundedRangeModel _horizRange = new DefaultBoundedRangeModel();
    protected BoundedRangeModel _vertRange = new DefaultBoundedRangeModel();
    protected Rectangle _area;
    protected boolean _coordHighlighting;
    protected Point _hfull = new Point(Integer.MIN_VALUE, 0);
    protected Point _drag = null;
    protected Point _ppos = new Point(Integer.MIN_VALUE, 0);
    protected boolean _validPlacement = false;
    protected Tile _ptile;
    protected SceneObject _pscobj;
    protected ArrayList<ExtrasPainter> _extras = Lists.newArrayList();
    protected PortalDialog _dialogPortal;
    protected ObjectEditorDialog _objEditor;
    protected SceneObject _eobject;
    protected UndoStack _undo = new UndoStack();
    protected UndoStack _redo = new UndoStack();
    protected SceneModelListener _sceneListener;
    protected static Polygon _locTri = new Polygon();
    protected static final Stroke HIGHLIGHT_STROKE;
    protected static final Composite ALPHA_PLACING;

    static {
        _locTri.addPoint(-3, -3);
        _locTri.addPoint(3, -3);
        _locTri.addPoint(0, 3);
        HIGHLIGHT_STROKE = new BasicStroke(2.0f);
        ALPHA_PLACING = AlphaComposite.getInstance(3, 0.5f);
    }

    public EditorScenePanel(EditorContext ctx, JFrame frame, EditorModel model, SceneModelListener sceneListener) {
        super(ctx, new Controller(){});
        this._sceneListener = sceneListener;
        this._ctx = ctx;
        this._frame = frame;
        this._emodel = model;
        this._emodel.addListener(this);
        ctx.getKeyDispatcher().addGlobalKeyListener((KeyListener)this);
        this._horizRange.addChangeListener(this);
        this._vertRange.addChangeListener(this);
    }

    public BoundedRangeModel getHorizModel() {
        return this._horizRange;
    }

    public BoundedRangeModel getVertModel() {
        return this._vertRange;
    }

    public void stateChanged(ChangeEvent e) {
        this.setViewLocation(this._horizRange.getValue(), this._vertRange.getValue());
        this._refreshBox = true;
    }

    public void setSceneModel(MisoSceneModel model) {
        super.setSceneModel(model);
        this.computeScrollArea();
    }

    public void updateDefaultTileSet(int tileSetId) {
        this._model.setDefaultBaseTileSet(tileSetId);
        this._blocks.clear();
        this.rethink();
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.updateScrollArea(this._horizRange.getValue(), this._vertRange.getValue());
        this.rethink();
    }

    protected void computeScrollArea() {
        StageMisoSceneModel ysmodel = (StageMisoSceneModel)this._model;
        this._area = null;
        Iterator iter = ysmodel.getSections();
        while (iter.hasNext()) {
            SparseMisoSceneModel.Section sect = (SparseMisoSceneModel.Section)iter.next();
            Rectangle sbounds = MisoUtil.getFootprintPolygon((MisoSceneMetrics)this._metrics, (int)sect.x, (int)sect.y, (int)ysmodel.swidth, (int)ysmodel.sheight).getBounds();
            if (this._area == null) {
                this._area = sbounds;
                continue;
            }
            this._area.add(sbounds);
        }
        if (this._area == null) {
            this._area = new Rectangle(-250, -250, 500, 500);
        }
        this.updateScrollArea(this._horizRange.getValue(), this._vertRange.getValue());
    }

    protected void updateScrollArea(int hval, int vval) {
        int hmax = this._area.x + this._area.width;
        hval = Math.min(hval, hmax - this._vbounds.width);
        this._horizRange.setRangeProperties(hval, this._vbounds.width, this._area.x, hmax, false);
        int vmax = this._area.y + this._area.height;
        vval = Math.min(vval, vmax - this._vbounds.height);
        this._vertRange.setRangeProperties(vval, this._vbounds.height, this._area.y, vmax, false);
        SwingUtil.refresh((JComponent)((Object)this._box));
        this._refreshBox = true;
    }

    protected void placeTile(int x, int y) {
        this.markCheckpoint();
        Rectangle drag = this.clearTileSelectRegion(x, y);
        if (!this._emodel.isTileValid()) {
            return;
        }
        switch (this._emodel.getLayerIndex()) {
            case 0: {
                this.updateBaseTiles(x, y, drag, this._emodel.getFQTileId(), this._emodel.getTileSetId(), this._emodel.getTileSet().getTileCount());
                break;
            }
            case 1: {
                this.addObject((ObjectTile)this._emodel.getTile(), this._emodel.getFQTileId(), x, y);
            }
        }
        this.computeScrollArea();
    }

    protected void deleteTile(int x, int y) {
        this.markCheckpoint();
        Rectangle drag = this.clearTileSelectRegion(x, y);
        Log.log.info((Object)("Deleting " + drag), new Object[0]);
        switch (this._emodel.getLayerIndex()) {
            case 0: {
                this.updateBaseTiles(x, y, drag, 0, 0, 1);
                break;
            }
            case 1: {
                if (drag != null) {
                    ArrayList hits = Lists.newArrayList();
                    for (SceneObject scobj : this._vizobjs) {
                        if (!scobj.objectFootprintOverlaps(drag)) continue;
                        hits.add(scobj);
                    }
                    int ii = 0;
                    while (ii < hits.size()) {
                        this.deleteObject((SceneObject)hits.get(ii));
                        ++ii;
                    }
                    break;
                }
                if (!(this._hobject instanceof SceneObject)) break;
                this.deleteObject((SceneObject)this._hobject);
            }
        }
    }

    protected void updateBaseTiles(int x, int y, Rectangle drag, int fqTileId, int tileSetId, int tileCount) {
        if (drag == null) {
            this.setBaseTile(fqTileId, x, y);
        } else {
            this.setBaseTiles(drag, tileSetId, tileCount);
        }
    }

    protected void editTile(int x, int y) {
        this.markCheckpoint();
        if (this._hobject == null || !(this._hobject instanceof SceneObject)) {
            return;
        }
        if (this._objEditor == null) {
            this._objEditor = new ObjectEditorDialog(this._ctx, this);
        }
        this._eobject = (SceneObject)this._hobject;
        this._objEditor.prepare(this._eobject);
        EditorDialogUtil.display(this._frame, this._objEditor);
    }

    protected void selectTile(int x, int y) {
        if (this._hobject == null || !(this._hobject instanceof SceneObject)) {
            return;
        }
        SceneObject scObj = (SceneObject)this._hobject;
        int tileSetId = TileUtil.getTileSetId((int)scObj.info.tileId);
        int tileIndex = TileUtil.getTileIndex((int)scObj.info.tileId);
        this._emodel.setTile(scObj.tile.key.tileSet, tileSetId, tileIndex);
        this._emodel.setLayerIndex(1);
    }

    protected void objectEditorDismissed() {
        this.recomputeVisible();
        this._model.updateObject(this._eobject.info);
        this._eobject = null;
    }

    protected void editPortal(EditablePortal portal) {
        this.markCheckpoint();
        if (this._dialogPortal == null) {
            this._dialogPortal = new PortalDialog(this._ctx, this);
        }
        this._dialogPortal.prepare(this._scene, portal);
        EditorDialogUtil.display(this._frame, this._dialogPortal);
        this.recomputePortals();
        this.recomputeVisible();
    }

    public void modelChanged(int event) {
        switch (event) {
            case 0: {
                switch (this._emodel.getActionMode()) {
                    case 0: {
                        this.enableCoordHighlighting(false);
                        if (!this._emodel.isTileValid()) break;
                        this.setPlacingTile(this._emodel.getTile());
                        break;
                    }
                    case 1: {
                        this.setPlacingTile(null);
                        this.enableCoordHighlighting(false);
                        break;
                    }
                    case 2: {
                        this.setPlacingTile(null);
                        this.enableCoordHighlighting(true);
                    }
                }
                break;
            }
            case 2: {
                if (!this._emodel.isTileValid() || this._emodel.getActionMode() != 0) break;
                this.setPlacingTile(this._emodel.getTile());
            }
        }
        this.repaint();
    }

    public void mousePressed(MouseEvent event) {
        int mx = event.getX();
        int my = event.getY();
        switch (this._emodel.getActionMode()) {
            case 0: {
                this.setTileSelectRegion(this.getTileCoords(mx, my));
                break;
            }
            case 2: {
                this.markCheckpoint();
                Point fcoords = this.getFullCoords(mx, my);
                if (event.getButton() == 3) {
                    this.deletePortal(fcoords.x, fcoords.y);
                    break;
                }
                EditablePortal portal = (EditablePortal)this.getPortal(fcoords.x, fcoords.y);
                if (portal != null) {
                    this.editPortal(portal);
                    break;
                }
                new PortalTool().init(this, mx, my);
                break;
            }
            default: {
                super.mousePressed(event);
            }
        }
    }

    protected boolean handleMousePressed(Object hobject, MouseEvent event) {
        return false;
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        Point tc = this.getTileCoords(e.getX(), e.getY());
        switch (this._emodel.getActionMode()) {
            case 0: {
                switch (e.getButton()) {
                    case 1: {
                        if ((e.getModifiers() & 2) != 0) {
                            this.clearTileSelectRegion(tc.x, tc.y);
                            this.selectTile(tc.x, tc.y);
                            break;
                        }
                        this.placeTile(tc.x, tc.y);
                        this._refreshBox = true;
                        break;
                    }
                    case 2: {
                        this.editTile(tc.x, tc.y);
                        break;
                    }
                    case 3: {
                        this.deleteTile(tc.x, tc.y);
                        this._refreshBox = true;
                    }
                }
                break;
            }
            case 1: {
                this.editTile(tc.x, tc.y);
                break;
            }
        }
        this.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        int x = e.getX();
        int y = e.getY();
        boolean repaint = false;
        if (this._ptile != null) {
            boolean changed;
            if (this._ptile instanceof ObjectTile) {
                changed = this.updateObjectTileCoords(x, y, this._ppos, (ObjectTile)this._ptile);
                if (changed) {
                    this._pscobj.relocateObject(this._metrics, this._ppos.x, this._ppos.y);
                }
            } else {
                changed = this.updateTileCoords(x, y, this._ppos);
            }
            if (changed) {
                this._validPlacement = this.isTilePlacementValid(this._ppos.x, this._ppos.y, this._ptile);
                repaint = true;
            }
        }
        if (this._coordHighlighting) {
            boolean bl = repaint = this.updateCoordPos(x, y, this._hfull) || repaint;
        }
        if (repaint) {
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent e) {
        super.mouseDragged(e);
        this.mouseMoved(e);
    }

    public void mouseExited(MouseEvent e) {
        super.mouseExited(e);
        this._ppos.setLocation(Integer.MIN_VALUE, 0);
        this._hfull.setLocation(Integer.MIN_VALUE, 0);
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 18) {
            this.setShowFlags(1, true);
        }
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 18) {
            this.setShowFlags(1, false);
        }
    }

    protected void fireObjectAction(ObjectActionHandler handler, SceneObject scobj, ActionEvent event) {
    }

    protected void hoverObjectChanged(Object oldHover, Object newHover) {
        super.hoverObjectChanged(oldHover, newHover);
        if (oldHover instanceof SceneObject) {
            SceneObject oldhov = (SceneObject)oldHover;
            this._remgr.invalidateRegion(oldhov.getObjectFootprint().getBounds());
        }
        if (newHover instanceof SceneObject) {
            SceneObject newhov = (SceneObject)newHover;
            this._remgr.invalidateRegion(newhov.getObjectFootprint().getBounds());
        }
    }

    public boolean setBaseTile(int fqTileId, int x, int y) {
        if (!this._model.setBaseTile(fqTileId, x, y)) {
            return false;
        }
        SceneBlock block = this.getBlock(x, y);
        if (block != null && block.isResolved()) {
            block.updateBaseTile(fqTileId, x, y);
        }
        int fx = x - 1;
        int xn = x + 1;
        while (fx <= xn) {
            int fy = y - 1;
            int yn = y + 1;
            while (fy <= yn) {
                block = this.getBlock(fx, fy);
                if (block != null && block.isResolved()) {
                    block.updateFringe(fx, fy);
                }
                ++fy;
            }
            ++fx;
        }
        return true;
    }

    public void setBaseTiles(Rectangle r, int setId, int tileCount) {
        int x = r.x;
        while (x < r.x + r.width) {
            int y = r.y;
            while (y < r.y + r.height) {
                int index = RandomUtil.getInt((int)tileCount);
                int fqTileId = TileUtil.getFQTileId((int)setId, (int)index);
                this.setBaseTile(fqTileId, x, y);
                ++y;
            }
            ++x;
        }
    }

    public ObjectInfo addObject(ObjectTile tile, int fqTileId, int x, int y) {
        Point p = new Point(x, y);
        this.adjustObjectCoordsAccordingToGrip(p, tile);
        return this.addObject(new ObjectInfo(fqTileId, x, y));
    }

    public ObjectInfo addObject(ObjectInfo oinfo) {
        SceneBlock block = this.getBlock(oinfo.x, oinfo.y);
        if ((block == null || !block.isResolved() || block.addObject(oinfo)) && this._model.addObject(oinfo)) {
            this.recomputeVisible();
            return oinfo;
        }
        return null;
    }

    public boolean deleteObject(SceneObject scobj) {
        if (this.deleteObject(scobj.info)) {
            if (this._hobject == scobj) {
                this._hobject = null;
            }
            return true;
        }
        Log.log.warning((Object)("Requested to remove unknown object " + scobj + "."), new Object[0]);
        return false;
    }

    public boolean deleteObject(ObjectInfo info) {
        if (this._model.removeObject(info)) {
            SceneBlock block = this.getBlock(info.x, info.y);
            if (block != null && block.isResolved()) {
                block.deleteObject(info);
            }
            this.recomputeVisible();
            return true;
        }
        return false;
    }

    public void setPlacingTile(Tile tile) {
        this._ptile = tile;
        this._pscobj = this._ptile instanceof ObjectTile ? new SceneObject((MisoScenePanel)this, new ObjectInfo(0, this._ppos.x, this._ppos.y), (ObjectTile)tile) : null;
    }

    public void setTileSelectRegion(Point drag) {
        this._drag = drag;
    }

    public Rectangle clearTileSelectRegion(int x, int y) {
        Rectangle drect = null;
        if (this._drag != null && (x != this._drag.x || y != this._drag.y)) {
            int w = 1 + (x > this._drag.x ? x - this._drag.x : this._drag.x - x);
            int h = 1 + (y > this._drag.y ? y - this._drag.y : this._drag.y - y);
            drect = new Rectangle(Math.min(x, this._drag.x), Math.min(y, this._drag.y), w, h);
        }
        this._drag = null;
        return drect;
    }

    public void enableCoordHighlighting(boolean enabled) {
        this._coordHighlighting = enabled;
    }

    public void deletePortal(int x, int y) {
        Portal port = this.getPortal(x, y);
        if (port != null) {
            this._scene.removePortal(port);
            this.recomputePortals();
            this.recomputeVisible();
        }
    }

    public Portal getEntrance() {
        return this._scene.getDefaultEntrance();
    }

    public void setEntrance(Portal port) {
        this._scene.setDefaultEntrance(port);
    }

    protected void recomputeVisible() {
        super.recomputeVisible();
        for (SceneObject scobj : this._vizobjs) {
            scobj.setWarning(this.overlaps(scobj));
        }
    }

    protected void warnVisible(SceneBlock block, Rectangle sbounds) {
    }

    protected boolean overlaps(SceneObject tobj) {
        for (SceneObject scobj : this._vizobjs) {
            if (scobj == tobj || !tobj.objectFootprintOverlaps(scobj) || tobj.getPriority() != scobj.getPriority()) continue;
            return true;
        }
        return false;
    }

    protected void paintHighlights(Graphics2D gfx, Rectangle dirty) {
        Polygon hpoly = null;
        if (this._hobject != null && this._hobject instanceof SceneObject) {
            SceneObject scobj = (SceneObject)this._hobject;
            hpoly = scobj.getObjectFootprint();
        }
        if (this._emodel.getActionMode() == 0 && (hpoly == null || this._emodel.getLayerIndex() == 0)) {
            hpoly = MisoUtil.getTilePolygon((MisoSceneMetrics)this._metrics, (int)this._hcoords.x, (int)this._hcoords.y);
        }
        if (hpoly != null) {
            gfx.setColor(Color.green);
            gfx.draw(hpoly);
        }
        if (this._coordHighlighting && this._hfull.x != Integer.MIN_VALUE) {
            Point spos = new Point();
            MisoUtil.fullToScreen((MisoSceneMetrics)this._metrics, (int)this._hfull.x, (int)this._hfull.y, (Point)spos);
            Stroke ostroke = gfx.getStroke();
            gfx.setStroke(HIGHLIGHT_STROKE);
            gfx.setColor(Color.red);
            gfx.draw(new Ellipse2D.Float(spos.x - 1, spos.y - 1, 3.0f, 3.0f));
            gfx.setStroke(ostroke);
        }
    }

    protected void paintExtras(Graphics2D gfx, Rectangle dirty) {
        super.paintExtras(gfx, dirty);
        if (gfx instanceof TGraphics2D) {
            gfx = ((TGraphics2D)gfx).getPrimary();
        }
        this.paintPortals(gfx);
        this.paintHighlights(gfx, dirty);
        this.paintPlacingTile(gfx);
        int ii = 0;
        while (ii < this._extras.size()) {
            this._extras.get(ii).paintExtras(gfx);
            ++ii;
        }
    }

    protected void addExtrasPainter(ExtrasPainter painter) {
        this._extras.add(painter);
    }

    protected void removeExtrasPainter(ExtrasPainter painter) {
        this._extras.remove(painter);
    }

    protected void paintPlacingTile(Graphics2D gfx) {
        Polygon bpoly;
        if (this._ptile == null || this._ppos.x == Integer.MIN_VALUE) {
            return;
        }
        Composite ocomp = gfx.getComposite();
        gfx.setComposite(ALPHA_PLACING);
        if (this._pscobj != null) {
            this._pscobj.paint(gfx);
            bpoly = this._pscobj.getObjectFootprint();
        } else {
            bpoly = MisoUtil.getTilePolygon((MisoSceneMetrics)this._metrics, (int)this._ppos.x, (int)this._ppos.y);
            Rectangle bounds = bpoly.getBounds();
            this._ptile.paint(gfx, bounds.x, bounds.y);
        }
        gfx.setComposite(ocomp);
        if (this._drag != null) {
            bpoly = MisoUtil.getMultiTilePolygon((MisoSceneMetrics)this._metrics, (Point)this._ppos, (Point)this._drag);
        }
        gfx.setColor(this._validPlacement ? Color.blue : Color.red);
        gfx.draw(bpoly);
    }

    protected void paintPortals(Graphics2D gfx) {
        Iterator<Portal> iter = this._scene.getPortals();
        while (iter.hasNext()) {
            this.paintPortal(gfx, (EditablePortal)iter.next());
        }
    }

    protected void paintPortal(Graphics2D gfx, EditablePortal port) {
        this.paintLocation(gfx, (StageLocation)port.loc, Color.BLUE, port.equals(this._scene.getDefaultEntrance()));
    }

    protected void paintLocation(Graphics2D gfx, StageLocation loc, Color color, boolean highlight) {
        Point spos = new Point();
        MisoUtil.fullToScreen((MisoSceneMetrics)this._metrics, (int)loc.x, (int)loc.y, (Point)spos);
        int cx = spos.x;
        int cy = spos.y;
        gfx.translate(cx, cy);
        double rot = 0.7853981633974483 * (double)loc.orient;
        gfx.rotate(rot);
        gfx.setColor(color);
        gfx.fill(_locTri);
        gfx.setColor(Color.black);
        gfx.draw(_locTri);
        gfx.setColor(Color.red);
        gfx.fillRect(-1, 2, 3, 3);
        gfx.rotate(-rot);
        gfx.translate(-cx, -cy);
        if (highlight) {
            gfx.setColor(Color.cyan);
            gfx.drawRect(spos.x - 5, spos.y - 5, 10, 10);
        }
    }

    public boolean updateCoordPos(int x, int y, Point cpos) {
        Point npos = MisoUtil.screenToFull((MisoSceneMetrics)this._metrics, (int)x, (int)y, (Point)new Point());
        if (!cpos.equals(npos)) {
            cpos.setLocation(npos.x, npos.y);
            return true;
        }
        return false;
    }

    protected boolean isTilePlacementValid(int x, int y, Tile tile) {
        if (tile instanceof ObjectTile) {
            SceneObject nobj = new SceneObject((MisoScenePanel)this, new ObjectInfo(0, x, y), (ObjectTile)tile);
            int ocount = this._vizobjs.size();
            int ii = 0;
            while (ii < ocount) {
                SceneObject scobj = (SceneObject)this._vizobjs.get(ii);
                if (scobj.objectFootprintOverlaps(nobj)) {
                    return false;
                }
                ++ii;
            }
        }
        return true;
    }

    protected boolean skipHitObject(SceneObject scobj) {
        return false;
    }

    protected boolean updateObjectTileCoords(int sx, int sy, Point tpos, ObjectTile otile) {
        Point npos = new Point();
        MisoUtil.screenToTile((MisoSceneMetrics)this._metrics, (int)sx, (int)sy, (Point)npos);
        this.adjustObjectCoordsAccordingToGrip(npos, otile);
        if (!tpos.equals(npos)) {
            tpos.setLocation(npos.x, npos.y);
            return true;
        }
        return false;
    }

    protected void adjustObjectCoordsAccordingToGrip(Point p, ObjectTile tile) {
        int dy = Math.max(3, tile.getHeight() / this._metrics.tilehei);
        int dx = Math.max(3, tile.getWidth() / this._metrics.tilewid);
        switch (this._emodel.getObjectGripDirection()) {
            case 3: {
                p.x += dy;
                p.y += dy;
                break;
            }
            case 1: {
                p.x += dx;
                break;
            }
            case 5: {
                p.y += dx;
                break;
            }
            case 2: {
                p.x += dy + dx / 2;
                p.y += dy - dx / 2;
                break;
            }
            case 4: {
                p.x += dy - dx / 2;
                p.y += dy + dx / 2;
                break;
            }
            case 0: {
                p.x += dx / 2;
                p.y -= dx / 2;
                break;
            }
            case 6: {
                p.x -= dx / 2;
                p.y += dx / 2;
            }
        }
    }

    protected void setEditorModel(EditorModel model) {
        this._emodel = model;
    }

    public void setEditorScrollBox(EditorScrollBox box) {
        this._box = box;
    }

    protected void paint(Graphics2D gfx, Rectangle[] dirty) {
        if (this._refreshBox && this._visiBlocks.isEmpty()) {
            this._refreshBox = false;
            Graphics2D mini = this._box.getMiniGraphics();
            TGraphics2D t = new TGraphics2D(gfx, mini);
            super.paint((Graphics2D)t, dirty);
            mini.dispose();
            this._box.repaint();
        } else {
            super.paint(gfx, dirty);
        }
    }

    protected void markCheckpoint() {
        this._undo.preserve();
        this._redo.clear();
    }

    public void undo() {
        if (this._undo.size() > 0) {
            this._redo.preserve();
            this._undo.rollback();
        }
    }

    public void redo() {
        if (this._redo.size() > 0) {
            this._undo.preserve();
            this._redo.rollback();
        }
    }

    public static interface SceneModelListener {
        public void setMisoSceneModel(StageMisoSceneModel var1);
    }

    protected class UndoStack {
        LinkedList<MisoSceneModel> _list = Lists.newLinkedList();

        protected UndoStack() {
        }

        public void preserve() {
            this._list.addFirst(EditorScenePanel.this._model.clone());
            if (this._list.size() > 20) {
                this._list.removeLast();
            }
        }

        public void rollback() {
            if (this._list.size() > 0) {
                EditorScenePanel.this._model = this._list.removeFirst();
                EditorScenePanel.this._sceneListener.setMisoSceneModel((StageMisoSceneModel)EditorScenePanel.this._model);
                EditorScenePanel.this.refreshScene();
            }
        }

        public int size() {
            return this._list.size();
        }

        public void clear() {
            this._list.clear();
        }
    }
}

