/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.micasa.simulator.server;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.data.PlaceConfig;
import com.threerings.crowd.server.LocationManager;
import com.threerings.crowd.server.PlaceRegistry;
import com.threerings.micasa.Log;
import com.threerings.micasa.simulator.data.SimulatorMarshaller;
import com.threerings.micasa.simulator.server.Simulant;
import com.threerings.micasa.simulator.server.SimulatorProvider;
import com.threerings.parlor.game.data.GameAI;
import com.threerings.parlor.game.data.GameConfig;
import com.threerings.parlor.game.data.GameObject;
import com.threerings.parlor.game.server.GameManager;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.dobj.DObjectManager;
import com.threerings.presents.dobj.RootDObjectManager;
import com.threerings.presents.server.ClientManager;
import com.threerings.presents.server.ClientResolutionListener;
import com.threerings.presents.server.InvocationManager;
import com.threerings.presents.server.InvocationProvider;
import com.threerings.util.Name;
import java.util.List;

@Singleton
public class SimulatorManager {
    @Inject
    protected PlaceRegistry _plreg;
    @Inject
    protected ClientManager _clmgr;
    @Inject
    protected RootDObjectManager _omgr;
    @Inject
    protected LocationManager _locman;
    protected static final byte DEFAULT_SKILL = 50;

    @Inject
    public SimulatorManager(InvocationManager invmgr) {
        SimulatorProvider sprov = new SimulatorProvider(this);
        invmgr.registerProvider((InvocationProvider)sprov, SimulatorMarshaller.class, "presents");
    }

    public void createGame(BodyObject source, GameConfig config, String simClass, int playerCount) {
        new CreateGameTask(source, config, simClass, playerCount);
    }

    public class CreateGameTask {
        protected List<ClientObject> _sims = Lists.newArrayList();
        protected GameObject _gobj;
        protected GameManager _gmgr;
        protected int _playerCount;
        protected String _simClass;
        protected GameConfig _config;
        protected BodyObject _source;

        public CreateGameTask(BodyObject source, GameConfig config, String simClass, int playerCount) {
            int skill;
            this._source = source;
            this._config = config;
            this._simClass = simClass;
            this._playerCount = playerCount;
            try {
                config.players = new Name[this._playerCount];
                config.players[0] = this._source.getVisibleName();
                int ii = 1;
                while (ii < this._playerCount) {
                    config.players[ii] = new Name("simulant" + ii);
                    ++ii;
                }
                this._gmgr = (GameManager)SimulatorManager.this._plreg.createPlace((PlaceConfig)config);
            }
            catch (Exception e) {
                Log.log.warning((Object)"Unable to create game manager", new Object[]{"e", e, e});
                return;
            }
            this._gobj = (GameObject)this._gmgr.getPlaceObject();
            try {
                skill = Byte.parseByte(System.getProperty("skill"));
            }
            catch (NumberFormatException nfe) {
                skill = 50;
            }
            int ii = 1;
            while (ii < this._playerCount) {
                this._gmgr.setAI(ii, new GameAI(0, skill));
                ++ii;
            }
            ClientResolutionListener listener = new ClientResolutionListener(){

                public void clientResolved(Name username, ClientObject clobj) {
                    CreateGameTask.this._sims.add(clobj);
                    if (CreateGameTask.this._sims.size() == CreateGameTask.this._playerCount - 1) {
                        CreateGameTask.this.createSimulants();
                    }
                }

                public void resolutionFailed(Name username, Exception cause) {
                    Log.log.warning((Object)"Unable to create simulant body object", new Object[]{"error", cause});
                }
            };
            int ii2 = 1;
            while (ii2 < this._playerCount) {
                Name username = new Name("simulant" + ii2);
                SimulatorManager.this._clmgr.resolveClientObject(username, listener);
                ++ii2;
            }
        }

        protected void createSimulants() {
            int ii = 1;
            while (ii < this._playerCount) {
                Simulant sim;
                try {
                    sim = (Simulant)Class.forName(this._simClass).newInstance();
                }
                catch (Exception e) {
                    Log.log.warning((Object)"Unable to create simulant", new Object[]{"class", this._simClass});
                    return;
                }
                BodyObject bobj = (BodyObject)this._sims.get(ii - 1);
                sim.init(bobj, this._config, this._gmgr, (DObjectManager)SimulatorManager.this._omgr);
                sim.willEnterPlace(this._gobj);
                try {
                    SimulatorManager.this._locman.moveTo(bobj, this._gobj.getOid());
                }
                catch (Exception e) {
                    Log.log.warning((Object)"Failed to move simulant into room", new Object[]{"e", e});
                    return;
                }
                ++ii;
            }
        }
    }
}

