/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.stage.tools.editor;

import com.samskivert.swing.HGroupLayout;
import com.threerings.stage.data.StageScene;
import com.threerings.stage.tools.editor.EditorDialog;
import com.threerings.stage.tools.editor.EditorScenePanel;
import com.threerings.stage.tools.editor.util.EditorContext;
import com.threerings.whirled.spot.data.Portal;
import com.threerings.whirled.spot.tools.EditablePortal;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PortalDialog
extends EditorDialog {
    protected StageScene _scene;
    protected JTextField _portalText;
    protected JCheckBox _entrance;
    protected EditablePortal _port;
    protected JComboBox _orientcombo;

    public PortalDialog(EditorContext ctx, EditorScenePanel panel) {
        super("Edit Portal", ctx, panel);
    }

    public void addComponents(JComponent top) {
        top.add(new JLabel("Enter settings for this portal:"));
        JPanel sub = new JPanel((LayoutManager)new HGroupLayout(HGroupLayout.STRETCH));
        sub.add(new JLabel("Portal name:", 4));
        this._portalText = new JTextField();
        sub.add(this._portalText);
        top.add(sub);
        this._entrance = new JCheckBox("Default Entrance");
        this._entrance.addActionListener(this);
        this._entrance.setActionCommand("entrance");
        top.add(this._entrance);
    }

    public void prepare(StageScene scene, EditablePortal port) {
        this._port = port;
        this._scene = scene;
        String text = port.name;
        this._portalText.setText(text);
        this._portalText.setCaretPosition(0);
        this._portalText.moveCaretPosition(text.length());
        Portal entry = this._scene.getDefaultEntrance();
        this._entrance.setSelected(entry == null || entry.portalId == this._port.portalId);
        this._portalText.requestFocusInWindow();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("entrance")) {
            this._entrance.setSelected(this._entrance.isSelected());
        } else {
            super.actionPerformed(e);
        }
    }

    public void accepted() {
        this._port.name = this._portalText.getText();
        if (this._entrance.isSelected()) {
            this._scene.setDefaultEntrance(this._port);
        } else if (this._scene.getDefaultEntrance() == this._port) {
            this._scene.setDefaultEntrance(null);
        }
    }

    protected void processKeyEvent(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 10: {
                this.accepted();
                break;
            }
            case 27: {
                this.setVisible(false);
            }
        }
    }
}

