/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.puzzle.drop.client;

import com.threerings.puzzle.drop.client.DropBoardView;
import com.threerings.puzzle.drop.client.DropSprite;
import java.awt.Rectangle;

public class DropBlockSprite
extends DropSprite {
    protected byte _popups = (byte)2;
    protected Rectangle _dbounds = new Rectangle();
    protected int[] _rows = new int[2];
    protected int[] _cols = new int[2];
    protected int _ecol;
    protected int _erow;

    public DropBlockSprite(DropBoardView view, int col, int row, int orient, int[] pieces) {
        super(view, col, row, pieces, 0);
        this._orient = orient;
    }

    public DropBlockSprite(DropBoardView view, int col, int row, int orient, int[] pieces, int renderOrder) {
        super(view, col, row, pieces, 0, renderOrder);
        this._orient = orient;
    }

    protected void init() {
        super.init();
        this.setOrientation(this._orient);
    }

    public int[] getRows() {
        return this._rows;
    }

    public int[] getColumns() {
        return this._cols;
    }

    public Rectangle getBoardBounds() {
        return this._dbounds;
    }

    public int getExternalRow() {
        return this._erow;
    }

    public int getExternalColumn() {
        return this._ecol;
    }

    public void setColumn(int col) {
        super.setColumn(col);
        this.updateDropInfo();
    }

    public void setRow(int row) {
        super.setRow(row);
        this.updateDropInfo();
    }

    public void setBoardLocation(int row, int col) {
        super.setBoardLocation(row, col);
        this.updateDropInfo();
    }

    public void setOrientation(int orient) {
        super.setOrientation(orient);
        int edx = 0;
        int edy = 0;
        if (orient == 3) {
            edy = -1;
        } else if (orient == 1) {
            edx = -1;
        }
        this.setRowOffset(edy);
        this.setColumnOffset(edx);
        this.updateDropInfo();
    }

    public void toString(StringBuilder buf) {
        super.toString(buf);
        buf.append(", erow=").append(this._erow);
        buf.append(", ecol=").append(this._ecol);
    }

    public boolean canPopup() {
        return this._popups > 0;
    }

    public void didPopup() {
        this._popups = (byte)(this._popups - 1);
    }

    protected void updateDropInfo() {
        int bphei;
        int bpwid;
        this._erow = this.calculateExternalRow();
        this._ecol = this.calculateExternalColumn();
        this._rows[0] = this._row;
        this._rows[1] = this._erow;
        this._cols[0] = this._col;
        this._cols[1] = this._ecol;
        int maxrow = Math.max(this._row, this._erow);
        int mincol = Math.min(this._col, this._ecol);
        if (this._orient == 3 || this._orient == 7) {
            bpwid = 1;
            bphei = 2;
        } else {
            bpwid = 2;
            bphei = 1;
        }
        this._dbounds.setBounds(mincol, maxrow, bpwid, bphei);
    }

    protected int calculateExternalRow() {
        if (this._orient == 3) {
            return this._row - 1;
        }
        if (this._orient == 7) {
            return this._row + 1;
        }
        return this._row;
    }

    protected int calculateExternalColumn() {
        if (this._orient == 1) {
            return this._col - 1;
        }
        if (this._orient == 5) {
            return this._col + 1;
        }
        return this._col;
    }
}

