/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.puzzle.client;

import com.google.common.collect.Lists;
import com.samskivert.swing.Label;
import com.samskivert.util.StringUtil;
import com.threerings.media.VirtualMediaPanel;
import com.threerings.media.animation.Animation;
import com.threerings.media.animation.AnimationAdapter;
import com.threerings.media.animation.AnimationArranger;
import com.threerings.media.animation.AnimationObserver;
import com.threerings.media.image.Mirage;
import com.threerings.media.sprite.Sprite;
import com.threerings.parlor.game.data.GameConfig;
import com.threerings.parlor.media.ScoreAnimation;
import com.threerings.puzzle.Log;
import com.threerings.puzzle.client.PuzzleController;
import com.threerings.puzzle.data.Board;
import com.threerings.puzzle.util.PuzzleContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;

public abstract class PuzzleBoardView
extends VirtualMediaPanel {
    protected PuzzleContext _ctx;
    protected PuzzleController _pctrl;
    protected Board _board;
    protected Rectangle _bounds;
    protected List<Animation> _actionAnims = Lists.newArrayList();
    protected List<Sprite> _actionSprites = Lists.newArrayList();
    protected AnimationArranger _avoidArranger;
    protected Mirage _background;
    protected Label _pauseLabel;
    protected int _scoreDist = 30;
    protected AnimationAdapter _actionAnimObs = new AnimationAdapter(){

        public void animationCompleted(Animation anim, long when) {
            PuzzleBoardView.this.animationFinished(anim);
        }
    };
    protected static boolean DEBUG_ACTION = false;
    protected static final int ACTION_GOING = 0;
    protected static final int CLEAR_PENDING = 1;
    protected static final int ACTION_CLEARED = 2;
    protected static final int DEFAULT_SCORE_DISTANCE = 30;

    public PuzzleBoardView(PuzzleContext ctx) {
        super(ctx.getFrameManager());
        this._ctx = ctx;
    }

    public void init(GameConfig config) {
        Dimension bounds = this.getPreferredSize();
        this._bounds = new Rectangle(0, 0, bounds.width, bounds.height);
    }

    public void setBoard(Board board) {
        this._board = board;
    }

    public void setController(PuzzleController pctrl) {
        this._pctrl = pctrl;
    }

    public void setBackgroundImage(Mirage image) {
        this._background = image;
    }

    public void setPaused(boolean paused) {
        if (paused) {
            String pmsg = this._pctrl.getPauseString();
            pmsg = this._ctx.getMessageManager().getBundle("puzzle.general").xlate(pmsg);
            this._pauseLabel = new Label(pmsg, 3, Color.WHITE, Color.BLACK, this.getFont());
            this._pauseLabel.setTargetWidth(this._bounds.width);
            this._pauseLabel.layout((Component)((Object)this));
        } else {
            this._pauseLabel = null;
        }
        this.repaint();
    }

    public void addActionAnimation(Animation anim) {
        super.addAnimation(anim);
        this._actionAnims.add(anim);
        anim.addAnimationObserver((AnimationObserver)this._actionAnimObs);
    }

    public void abortAnimation(Animation anim) {
        super.abortAnimation(anim);
        this.animationFinished(anim);
    }

    protected void animationFinished(Animation anim) {
        if (DEBUG_ACTION) {
            Log.log.info((Object)("Animation cleared " + StringUtil.shortClassName((Object)anim) + ":" + this._actionAnims.contains(anim)), new Object[0]);
        }
        if (this._actionAnims.remove(anim)) {
            this.maybeFireCleared();
        }
    }

    public void addActionSprite(Sprite sprite) {
        this.addSprite(sprite);
        this._actionSprites.add(sprite);
    }

    public void removeSprite(Sprite sprite) {
        super.removeSprite(sprite);
        if (DEBUG_ACTION) {
            Log.log.info((Object)("Sprite cleared " + StringUtil.shortClassName((Object)sprite) + ":" + this._actionSprites.contains(sprite)), new Object[0]);
        }
        if (this._actionSprites.remove(sprite)) {
            this.maybeFireCleared();
        }
    }

    public void clearSprites() {
        super.clearSprites();
        this._actionSprites.clear();
    }

    public void clearAnimations() {
        super.clearAnimations();
        this._actionAnims.clear();
    }

    public int getActionAnimationCount() {
        return this._actionAnims.size();
    }

    public int getActionSpriteCount() {
        return this._actionSprites.size();
    }

    public int getActionCount() {
        return this._actionSprites.size() + this._actionAnims.size();
    }

    public void dumpActors() {
        StringUtil.Formatter fmt = new StringUtil.Formatter(){

            public String toString(Object obj) {
                return StringUtil.shortClassName((Object)obj);
            }
        };
        Log.log.info((Object)"Board contents", new Object[]{"board", StringUtil.shortClassName((Object)((Object)this)), "sprites", StringUtil.listToString(this._actionSprites, (StringUtil.Formatter)fmt), "anims", StringUtil.listToString(this._actionAnims, (StringUtil.Formatter)fmt)});
    }

    public ScoreAnimation createScoreAnimation(String score, Color color, Font font, int x, int y) {
        return this.createScoreAnimation(ScoreAnimation.createLabel(score, color, font, (Component)((Object)this)), x, y);
    }

    protected ScoreAnimation createScoreAnimation(Label label, int x, int y) {
        return new ScoreAnimation(label, x, y);
    }

    public void trackAvoidAnimation(Animation anim) {
        if (this._avoidArranger == null) {
            this._avoidArranger = new AnimationArranger();
        }
        this._avoidArranger.positionAvoidAnimation(anim, this._vbounds);
    }

    public void paintBehind(Graphics2D gfx, Rectangle dirty) {
        super.paintBehind(gfx, dirty);
        this.renderBackground(gfx, dirty);
    }

    protected void renderBackground(Graphics2D gfx, Rectangle dirty) {
        gfx.setColor(this.getBackground());
        gfx.fill(dirty);
    }

    public void paintBetween(Graphics2D gfx, Rectangle dirty) {
        super.paintBetween(gfx, dirty);
        this.renderBoard(gfx, dirty);
    }

    protected void paintInFront(Graphics2D gfx, Rectangle dirty) {
        super.paintInFront(gfx, dirty);
        if (this._pauseLabel != null) {
            Dimension d = this._pauseLabel.getSize();
            this._pauseLabel.render(gfx, (float)(this._vbounds.x + (this._vbounds.width - d.width) / 2), (float)(this._vbounds.y + (this._vbounds.height - d.height) / 2));
        }
    }

    protected void maybeFireCleared() {
        if (DEBUG_ACTION) {
            Log.log.info((Object)("Maybe firing cleared " + this.getActionCount() + ":" + this.isShowing()), new Object[0]);
        }
        if (this.getActionCount() == 0) {
            this._ctx.getClient().getRunQueue().postRunnable(new Runnable(){

                public void run() {
                    PuzzleBoardView.this._pctrl.boardActionCleared();
                }
            });
        }
    }

    protected abstract void renderBoard(Graphics2D var1, Rectangle var2);
}

