/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.micasa.client;

import com.samskivert.swing.util.SwingUtil;
import com.threerings.micasa.Log;
import com.threerings.micasa.client.MiCasaClient;
import com.threerings.micasa.client.MiCasaFrame;
import com.threerings.presents.client.Client;
import com.threerings.presents.net.Credentials;
import com.threerings.presents.net.UsernamePasswordCreds;
import com.threerings.util.Name;
import java.awt.Window;
import java.io.IOException;

public class MiCasaApp {
    protected MiCasaClient _client;
    protected MiCasaFrame _frame;

    public void init() throws IOException {
        this._frame = new MiCasaFrame();
        String cclass = null;
        try {
            cclass = System.getProperty("client");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cclass == null) {
            cclass = MiCasaClient.class.getName();
        }
        try {
            this._client = (MiCasaClient)Class.forName(cclass).newInstance();
        }
        catch (Exception e) {
            Log.log.warning((Object)"Unable to instantiate client class", new Object[]{"cclass", cclass, e});
        }
        this._client.init(this._frame);
    }

    public void run(String server, String username, String password) {
        this._frame.setSize(800, 600);
        SwingUtil.centerWindow((Window)this._frame);
        this._frame.setVisible(true);
        Client client = this._client.getContext().getClient();
        Log.log.info((Object)"Using", new Object[]{"server", server});
        client.setServer(server, Client.DEFAULT_SERVER_PORTS);
        if (username != null && password != null) {
            client.setCredentials((Credentials)new UsernamePasswordCreds(new Name(username), password));
            client.logon();
        }
    }

    public static void main(String[] args) {
        String server = "localhost";
        if (args.length > 0) {
            server = args[0];
        }
        String username = args.length > 1 ? args[1] : null;
        String password = args.length > 2 ? args[2] : null;
        MiCasaApp app = new MiCasaApp();
        try {
            app.init();
        }
        catch (IOException ioe) {
            Log.log.warning((Object)"Error initializing application.", new Object[]{ioe});
        }
        app.run(server, username, password);
    }
}

