/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.whirled.util;

import com.google.common.collect.Lists;
import com.threerings.whirled.Log;
import com.threerings.whirled.data.SceneUpdate;
import java.util.ArrayList;
import java.util.List;

public class UpdateList {
    protected List<SceneUpdate> _updates = Lists.newArrayList();

    public void addUpdate(SceneUpdate update) {
        if (this._updates.isEmpty()) {
            this._updates.add(update);
            return;
        }
        SceneUpdate last = this._updates.get(this._updates.size() - 1);
        int expVersion = last.getSceneVersion() + last.getVersionIncrement();
        int gotVersion = update.getSceneVersion();
        if (gotVersion > expVersion) {
            Log.log.warning((Object)("Update continuity broken, flushing list [got=" + update + ", expect=" + expVersion + ", ucount=" + this._updates.size() + "]."), new Object[0]);
            this._updates.clear();
        } else if (gotVersion < expVersion) {
            String errmsg = "Invalid update version [want=" + expVersion + ", got=" + update + "]";
            throw new IllegalArgumentException(errmsg);
        }
        this._updates.add(update);
    }

    public SceneUpdate[] getUpdates(int fromVersion) {
        if (this._updates.size() == 0 || this._updates.get(0).getSceneVersion() > fromVersion) {
            return null;
        }
        ArrayList updates = Lists.newArrayList();
        for (SceneUpdate update : this._updates) {
            if (update.getSceneVersion() < fromVersion) continue;
            updates.add(update);
        }
        return updates.size() == 0 ? null : updates.toArray(new SceneUpdate[updates.size()]);
    }

    public boolean validate(int sceneVersion) {
        if (this._updates.size() == 0) {
            return true;
        }
        SceneUpdate last = this._updates.get(this._updates.size() - 1);
        return sceneVersion == last.getSceneVersion() + last.getVersionIncrement();
    }
}

