/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.stats.server.persist;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.samskivert.depot.CacheInvalidator;
import com.samskivert.depot.DatabaseException;
import com.samskivert.depot.DepotRepository;
import com.samskivert.depot.DuplicateKeyException;
import com.samskivert.depot.Funcs;
import com.samskivert.depot.Key;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.clause.FieldDefinition;
import com.samskivert.depot.clause.FromOverride;
import com.samskivert.depot.clause.QueryClause;
import com.samskivert.depot.clause.Where;
import com.samskivert.depot.clause.WhereClause;
import com.samskivert.depot.expression.ColumnExp;
import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.io.ByteArrayOutInputStream;
import com.samskivert.util.HashIntMap;
import com.samskivert.util.IntMap;
import com.samskivert.util.IntMaps;
import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.stats.Log;
import com.threerings.stats.data.Stat;
import com.threerings.stats.data.StatModifier;
import com.threerings.stats.server.persist.MaxStatCodeRecord;
import com.threerings.stats.server.persist.StatRecord;
import com.threerings.stats.server.persist.StringCodeRecord;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class StatRepository
extends DepotRepository
implements Stat.AuxDataSource {
    protected Map<Stat.Type, Map<String, Integer>> _stringToCode = Maps.newHashMap();
    protected Map<Stat.Type, IntMap<String>> _codeToString = Maps.newHashMap();
    protected static final int MAX_UPDATE_TRIES = 5;

    @Inject
    public StatRepository(PersistenceContext context) {
        super(context);
    }

    public <T extends Stat> T updateStat(int playerId, StatModifier<T> modifier) {
        Where where = new Where(StatRecord.PLAYER_ID, (Comparable)Integer.valueOf(playerId), StatRecord.STAT_CODE, (Comparable)Integer.valueOf(modifier.getType().code()));
        int ii = 0;
        while (ii < 5) {
            Stat stat;
            StatRecord record = (StatRecord)this.load(StatRecord.class, new QueryClause[]{where});
            Stat tstat = stat = record == null ? modifier.getType().newStat() : this.decodeStat(record.statCode, record.statData, record.modCount);
            modifier.modify(tstat);
            if (!tstat.isModified()) {
                return null;
            }
            if (this.updateStat(playerId, tstat, false)) {
                return (T)tstat;
            }
            ++ii;
        }
        throw new DatabaseException("Unable to update stat after 5 attempts [stat=" + modifier.getType() + ", pid=" + playerId + "]");
    }

    public ArrayList<Stat> loadStats(int playerId) {
        ArrayList stats = Lists.newArrayList();
        Where where = new Where(StatRecord.PLAYER_ID, (Comparable)Integer.valueOf(playerId));
        for (StatRecord record : this.findAll(StatRecord.class, new QueryClause[]{where})) {
            Stat stat = this.decodeStat(record.statCode, record.statData, record.modCount);
            if (stat == null) continue;
            stats.add(stat);
        }
        return stats;
    }

    public void deleteStats(int playerId) {
        this.deleteAll(StatRecord.class, (WhereClause)new Where(StatRecord.PLAYER_ID, (Comparable)Integer.valueOf(playerId)));
    }

    public void writeModified(int playerId, Stat[] stats) {
        this.writeModified(playerId, Arrays.asList(stats));
    }

    public void writeModified(int playerId, Iterable<Stat> stats) {
        for (Stat stat : stats) {
            try {
                if (!stat.getType().isPersistent() || !stat.isModified()) continue;
                this.updateStat(playerId, stat, true);
            }
            catch (Exception e) {
                Log.log.warning((Object)"Error flushing modified stat", new Object[]{"stat", stat, e});
            }
        }
    }

    @Override
    public int getStringCode(Stat.Type type, String value) {
        Integer code;
        HashMap map = this._stringToCode.get(type);
        if (map == null) {
            map = Maps.newHashMap();
            this._stringToCode.put(type, map);
        }
        if ((code = map.get(value)) == null) {
            try {
                code = this.assignStringCode(type, value);
            }
            catch (DatabaseException pe) {
                Log.log.warning((Object)"Failed to assign code", new Object[]{"type", type, "value", value, pe});
                code = -1;
            }
            this.mapStringCode(type, value, code);
        }
        return code;
    }

    @Override
    public String getCodeString(Stat.Type type, int code) {
        String value;
        IntMap<String> map = this._codeToString.get(type);
        String string = value = map == null ? null : (String)map.get(code);
        if (value == null) {
            try {
                this.loadStringCodes(type);
            }
            catch (DatabaseException pe) {
                Log.log.warning((Object)"Failed to reload string codes", new Object[]{"type", type, "code", code, pe});
            }
            map = this._codeToString.get(type);
            String string2 = value = map == null ? null : (String)map.get(code);
            if (value == null) {
                Log.log.warning((Object)"Missing reverse maping", new Object[]{"type", type, "code", code});
                value = "__UNKNOWN:" + code + "__";
            }
        }
        return value;
    }

    public void clearMapping(Stat.Type type, String value) {
        int ocode = this._stringToCode.get(type).remove(value);
        this._codeToString.get(type).remove(ocode);
    }

    public void purgePlayers(Collection<Integer> playerIds) {
        this.deleteAll(StatRecord.class, (WhereClause)new Where((SQLExpression)StatRecord.PLAYER_ID.in(playerIds)));
    }

    protected Stat decodeStat(int statCode, byte[] data, byte modCount) {
        Stat.Type type = Stat.getType(statCode);
        if (type == null) {
            Log.log.warning((Object)"Unable to decode stat, unknown type", new Object[]{"code", statCode});
            return null;
        }
        return this.decodeStat(type.newStat(), data, modCount);
    }

    protected Stat decodeStat(Stat stat, byte[] data, byte modCount) {
        String errmsg = null;
        Exception error = null;
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(data);
            stat.unpersistFrom(new ObjectInputStream((InputStream)bin), this);
            stat.setModCount(modCount);
            return stat;
        }
        catch (ClassNotFoundException cnfe) {
            error = cnfe;
            errmsg = "Unable to instantiate stat";
        }
        catch (IOException ioe) {
            error = ioe;
            errmsg = "Unable to decode stat";
        }
        Log.log.warning((Object)errmsg, new Object[]{"type", stat.getType(), error});
        return null;
    }

    protected boolean updateStat(int playerId, Stat stat, boolean forceWrite) {
        ByteArrayOutInputStream out = new ByteArrayOutInputStream();
        try {
            stat.persistTo(new ObjectOutputStream((OutputStream)out), this);
        }
        catch (IOException ioe) {
            throw new DatabaseException("Error serializing stat " + stat, (Throwable)ioe);
        }
        byte[] data = out.toByteArray();
        byte nextModCount = (byte)((stat.getModCount() + 1) % 127);
        Key<StatRecord> key = StatRecord.getKey(playerId, stat.getCode());
        int numRows = this.updatePartial(StatRecord.class, (WhereClause)new Where(StatRecord.PLAYER_ID, (Comparable)Integer.valueOf(playerId), StatRecord.STAT_CODE, (Comparable)Integer.valueOf(stat.getCode()), StatRecord.MOD_COUNT, (Comparable)Byte.valueOf(stat.getModCount())), (CacheInvalidator)key, (ColumnExp)StatRecord.STAT_DATA, data, new Object[]{StatRecord.MOD_COUNT, nextModCount});
        if (numRows == 0) {
            if (this.load(StatRecord.class, new QueryClause[]{key}) == null) {
                try {
                    this.insert(new StatRecord(playerId, stat.getCode(), data, nextModCount));
                    numRows = 1;
                }
                catch (DuplicateKeyException e) {
                    numRows = 0;
                }
            }
            if (numRows == 0 && forceWrite) {
                Log.log.warning((Object)"Possible collision while storing StatRecord", new Object[]{"playerId", playerId, "stat", stat.getType().name(), "modCount", nextModCount, "overwriting", this.load(StatRecord.class, new QueryClause[]{key})});
                this.store(new StatRecord(playerId, stat.getCode(), data, nextModCount));
                numRows = 1;
            }
        }
        return numRows > 0;
    }

    protected Integer assignStringCode(Stat.Type type, String value) {
        int ii = 0;
        while (ii < 10) {
            MaxStatCodeRecord maxRecord = (MaxStatCodeRecord)this.load(MaxStatCodeRecord.class, new QueryClause[]{new FromOverride(StringCodeRecord.class), new FieldDefinition(MaxStatCodeRecord.MAX_CODE, (SQLExpression)Funcs.max(StringCodeRecord.CODE)), new Where(StringCodeRecord.STAT_CODE, (Comparable)Integer.valueOf(type.code()))});
            int code = maxRecord != null ? maxRecord.maxCode + 1 : 1;
            try {
                this.insert(new StringCodeRecord(type.code(), value, code));
                return code;
            }
            catch (DatabaseException pe) {
                if (!(pe instanceof DuplicateKeyException)) {
                    throw pe;
                }
                StringCodeRecord record = (StringCodeRecord)this.load(StringCodeRecord.class, new QueryClause[]{StringCodeRecord.getKey(type.code(), value)});
                if (record != null) {
                    Log.log.info((Object)"Value collision assigning string code", new Object[]{"type", type, "value", value});
                    return code;
                }
                Log.log.info((Object)"Code collision assigning string code", new Object[]{"type", type, "value", value});
                ++ii;
            }
        }
        throw new DatabaseException("Unable to assign code after 10 attempts [type=" + type + ", value=" + value + "]");
    }

    protected void loadStringCodes(Stat.Type type) {
        QueryClause[] clauses = type != null ? new QueryClause[]{new Where(StringCodeRecord.STAT_CODE, (Comparable)Integer.valueOf(type.code()))} : new QueryClause[]{};
        for (StringCodeRecord record : this.findAll(StringCodeRecord.class, clauses)) {
            this.mapStringCode(Stat.getType(record.statCode), record.value, record.code);
        }
    }

    protected void mapStringCode(Stat.Type type, String value, int code) {
        HashMap fmap = this._stringToCode.get(type);
        if (fmap == null) {
            fmap = Maps.newHashMap();
            this._stringToCode.put(type, fmap);
        }
        fmap.put((String)value, code);
        HashIntMap rmap = this._codeToString.get(type);
        if (rmap == null) {
            rmap = IntMaps.newHashIntMap();
            this._codeToString.put(type, (IntMap<String>)rmap);
        }
        rmap.put(code, (Object)value);
    }

    protected void init() {
        super.init();
        this.loadStringCodes(null);
    }

    protected void getManagedRecords(Set<Class<? extends PersistentRecord>> classes) {
        classes.add(StatRecord.class);
        classes.add(StringCodeRecord.class);
    }
}

