/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.stats.data;

import com.samskivert.util.HashIntMap;
import com.samskivert.util.StringUtil;
import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.presents.dobj.DSet;
import com.threerings.stats.Log;
import java.io.IOException;
import java.io.Serializable;
import java.util.zip.CRC32;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Stat
implements DSet.Entry,
Cloneable {
    protected Type _type;
    protected boolean _modified;
    protected byte _modCount;
    protected static CRC32 _crc = new CRC32();
    protected static HashIntMap<Type> _codeToType = new HashIntMap();

    public static Type getType(int code) {
        return (Type)_codeToType.get(code);
    }

    public static int initType(Type type, Stat prototype) {
        int code = Stat.crc32(type.name());
        if (_codeToType.containsKey(code)) {
            Log.log.warning((Object)("Stat type collision! " + type.name() + " and " + ((Type)_codeToType.get(code)).name() + " both map to '" + code + "'."), new Object[0]);
            return -1;
        }
        prototype._type = type;
        _codeToType.put(code, (Object)type);
        return code;
    }

    public static int crc32(String string) {
        _crc.reset();
        _crc.update(string.getBytes());
        return (int)_crc.getValue();
    }

    public Type getType() {
        return this._type;
    }

    public int getCode() {
        return this._type.code();
    }

    public boolean isModified() {
        return this._modified;
    }

    public void setModified(boolean modified) {
        this._modified = modified;
    }

    public byte getModCount() {
        return this._modCount;
    }

    public void setModCount(byte modCount) {
        this._modCount = modCount;
    }

    public abstract void persistTo(ObjectOutputStream var1, AuxDataSource var2) throws IOException;

    public abstract void unpersistFrom(ObjectInputStream var1, AuxDataSource var2) throws IOException, ClassNotFoundException;

    public String toString() {
        StringBuilder buf = new StringBuilder(StringUtil.toUSLowerCase((String)this._type.name()));
        buf.append("=").append(this.valueToString());
        buf.append("(").append(this._modCount).append(")");
        return buf.toString();
    }

    public abstract String valueToString();

    public String getKey() {
        return this._type.name();
    }

    public Stat clone() {
        try {
            return (Stat)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static interface AuxDataSource {
        public int getStringCode(Type var1, String var2);

        public String getCodeString(Type var1, int var2);
    }

    public static interface Type
    extends Serializable {
        public Stat newStat();

        public String name();

        public int code();

        public boolean isPersistent();
    }
}

