/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.puzzle.client;

import com.samskivert.swing.Controller;
import com.samskivert.swing.ControllerProvider;
import com.samskivert.swing.RuntimeAdjust;
import com.samskivert.swing.util.SwingUtil;
import com.threerings.crowd.client.PlaceView;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.parlor.game.data.GameConfig;
import com.threerings.parlor.util.RobotPlayer;
import com.threerings.puzzle.Log;
import com.threerings.puzzle.client.PuzzleBoardView;
import com.threerings.puzzle.client.PuzzleController;
import com.threerings.puzzle.client.PuzzlePrefs;
import com.threerings.puzzle.data.PuzzleCodes;
import com.threerings.puzzle.data.PuzzleGameCodes;
import com.threerings.puzzle.util.PuzzleContext;
import com.threerings.util.KeyTranslator;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class PuzzlePanel
extends JPanel
implements PlaceView,
ControllerProvider,
PuzzleCodes,
PuzzleGameCodes {
    protected PuzzleContext _ctx;
    protected PuzzleBoardView _bview;
    protected JPanel _bpanel;
    protected JPanel _opanel;
    protected GameConfig _config;
    protected RobotPlayer _robot;
    protected KeyTranslator _xlate;
    protected PuzzleController _controller;
    protected static RuntimeAdjust.BooleanAdjust _robotTest = new RuntimeAdjust.BooleanAdjust("Activates the robot test player which will make random moves in any activated puzzle.", "narya.puzzle.robot_tester", PuzzlePrefs.config, false);
    protected static RuntimeAdjust.BooleanAdjust _syncBoardState = new RuntimeAdjust.BooleanAdjust("Sends a snapshot of the puzzle board with every event to aid in debugging.", "narya.puzzle.sync_board_state", PuzzlePrefs.config, false);

    public PuzzlePanel(PuzzleContext ctx, PuzzleController controller) {
        this._ctx = ctx;
        this._controller = controller;
        this._xlate = this.getKeyTranslator();
        this._ctx.getKeyboardManager().setTarget((JComponent)this, this._xlate);
        this.setLayout(new BorderLayout());
        this._bview = this.createBoardView(ctx);
        this._bpanel = this.createBoardPanel(ctx);
        this.add((Component)this._bpanel, "Center");
    }

    public void addNotify() {
        super.addNotify();
        this.setPuzzleGrabsKeys(false);
    }

    public void removeNotify() {
        super.removeNotify();
        this.setPuzzleGrabsKeys(false);
    }

    public boolean pushOverlayPanel(JPanel opanel) {
        if (this._opanel != null) {
            Log.log.info((Object)"Refusing to push overlay panel, we've already got one", new Object[]{"opanel", this._opanel, "npanel", opanel});
            return false;
        }
        this._opanel = opanel;
        this.remove(this._bpanel);
        this.add(this._opanel);
        SwingUtil.refresh((JComponent)this);
        return true;
    }

    public void popOverlayPanel() {
        if (this._opanel != null) {
            this.remove(this._opanel);
            this._opanel = null;
            this.add(this._bpanel);
            SwingUtil.refresh((JComponent)this);
        }
    }

    public boolean hasOverlay() {
        return this._opanel != null;
    }

    public void init(GameConfig config) {
        this._config = config;
        this._bview.init(config);
    }

    public void setRobotPlayer(boolean isrobot) {
        if (this._robot == null) {
            this._robot = this.createRobotPlayer();
        }
        this.setPuzzleGrabsKeys(!isrobot);
        this._robot.setRobotDelay(200L);
        this._robot.setActive(isrobot);
    }

    public void setPuzzleGrabsKeys(boolean puzgrabs) {
        this._ctx.getKeyboardManager().setEnabled(puzgrabs);
        if (puzgrabs) {
            this.getBoardView().requestFocusInWindow();
        }
    }

    public void startAction() {
        if (PuzzlePanel.isRobotTesting() && this._controller.getPlayerIndex() == 0) {
            this.setRobotPlayer(true);
        }
    }

    public void clearAction() {
        if (PuzzlePanel.isRobotTesting() && this._controller.getPlayerIndex() == 0) {
            this.setRobotPlayer(false);
        }
    }

    protected RobotPlayer createRobotPlayer() {
        return new RobotPlayer(this, this._xlate);
    }

    protected abstract PuzzleBoardView createBoardView(PuzzleContext var1);

    protected abstract JPanel createBoardPanel(PuzzleContext var1);

    protected abstract KeyTranslator getKeyTranslator();

    public void willEnterPlace(PlaceObject plobj) {
    }

    public void didLeavePlace(PlaceObject plobj) {
        this._ctx.getKeyboardManager().reset();
    }

    public PuzzleBoardView getBoardView() {
        return this._bview;
    }

    public Controller getController() {
        return this._controller;
    }

    public static boolean isRobotTesting() {
        return _robotTest.getValue();
    }

    public static boolean isSyncingBoards() {
        return _syncBoardState.getValue();
    }
}

