/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.parlor.card.client;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.samskivert.util.ObserverList;
import com.samskivert.util.QuickSort;
import com.threerings.media.FrameManager;
import com.threerings.media.VirtualMediaPanel;
import com.threerings.media.image.Mirage;
import com.threerings.media.sprite.PathAdapter;
import com.threerings.media.sprite.Sprite;
import com.threerings.media.util.LinePath;
import com.threerings.media.util.Path;
import com.threerings.media.util.PathSequence;
import com.threerings.parlor.card.client.CardSprite;
import com.threerings.parlor.card.client.CardSpriteObserver;
import com.threerings.parlor.card.data.Card;
import com.threerings.parlor.card.data.CardCodes;
import com.threerings.parlor.card.data.Hand;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.MouseInputAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CardPanel
extends VirtualMediaPanel
implements CardCodes {
    public static final int NONE = 0;
    public static final int SINGLE = 1;
    public static final int MULTIPLE = 2;
    protected int _cardWidth;
    protected MouseEvent _mouseEvent;
    protected CardSprite _activeCardSprite;
    protected ArrayList<CardSprite> _handSprites = Lists.newArrayList();
    protected ArrayList<CardSprite> _selectedHandSprites = Lists.newArrayList();
    protected int _handSelectionMode;
    protected Predicate<CardSprite> _handSelectionPredicate;
    protected ObserverList<CardSelectionObserver> _handSelectionObservers = ObserverList.newFastUnsafe();
    protected Point _handLocation = new Point();
    protected int _handSpacing;
    protected int _selectableCardOffset;
    protected int _selectedCardOffset;
    protected ArrayList<CardSprite> _boardSprites = Lists.newArrayList();
    protected HandSpriteObserver _handSpriteObserver = new HandSpriteObserver();
    protected PathAdapter _pathEndRemover = new PathAdapter(){

        public void pathCompleted(Sprite sprite, Path path, long when) {
            CardPanel.this.removeSprite(sprite);
        }
    };
    protected static final Comparator<CardSprite> CARD_COMP = new Comparator<CardSprite>(){

        @Override
        public int compare(CardSprite cs1, CardSprite cs2) {
            if (cs1._card == null || cs2._card == null) {
                return 0;
            }
            return cs1._card.compareTo(cs2._card);
        }
    };
    protected static final Color DEFAULT_BACKGROUND = new Color(3304758);

    public CardPanel(FrameManager frameManager) {
        super(frameManager);
        CardListener cl = new CardListener();
        this.addMouseListener(cl);
        this.addMouseMotionListener(cl);
    }

    public abstract Mirage getCardBackImage();

    public abstract Mirage getCardImage(Card var1);

    public abstract Mirage getMicroCardBackImage();

    public abstract Mirage getMicroCardImage(Card var1);

    public void setHandLocation(int x, int y) {
        this._handLocation.setLocation(x, y);
    }

    public void setHandSpacing(int spacing) {
        this._handSpacing = spacing;
    }

    public void setSelectableCardOffset(int offset) {
        this._selectableCardOffset = offset;
    }

    public void setSelectedCardOffset(int offset) {
        this._selectedCardOffset = offset;
    }

    public void setHandSelectionMode(int mode) {
        this._handSelectionMode = mode;
        this.updateHandOffsets();
    }

    public void setHandSelectionPredicate(Predicate<CardSprite> pred) {
        this._handSelectionPredicate = pred;
        this.updateHandOffsets();
    }

    public CardSprite getSelectedHandSprite() {
        return this._selectedHandSprites.size() == 0 ? null : this._selectedHandSprites.get(0);
    }

    public CardSprite[] getSelectedHandSprites() {
        return this._selectedHandSprites.toArray(new CardSprite[this._selectedHandSprites.size()]);
    }

    public void selectHandSprite(final CardSprite sprite) {
        CardSprite oldSprite;
        if (this._selectedHandSprites.contains((Object)sprite)) {
            return;
        }
        if (this._handSelectionMode == 1 && (oldSprite = this.getSelectedHandSprite()) != null) {
            this.deselectHandSprite(oldSprite);
        }
        this._selectedHandSprites.add(sprite);
        sprite.setLocation(sprite.getX(), this.getHandY(sprite));
        ObserverList.ObserverOp<CardSelectionObserver> op = new ObserverList.ObserverOp<CardSelectionObserver>(){

            public boolean apply(CardSelectionObserver obs) {
                obs.cardSpriteSelected(sprite);
                return true;
            }
        };
        this._handSelectionObservers.apply((ObserverList.ObserverOp)op);
    }

    public void deselectHandSprite(final CardSprite sprite) {
        if (!this._selectedHandSprites.contains((Object)sprite)) {
            return;
        }
        this._selectedHandSprites.remove((Object)sprite);
        sprite.setLocation(sprite.getX(), this.getHandY(sprite));
        ObserverList.ObserverOp<CardSelectionObserver> op = new ObserverList.ObserverOp<CardSelectionObserver>(){

            public boolean apply(CardSelectionObserver obs) {
                obs.cardSpriteDeselected(sprite);
                return true;
            }
        };
        this._handSelectionObservers.apply((ObserverList.ObserverOp)op);
    }

    public void clearHandSelection() {
        CardSprite[] sprites;
        CardSprite[] cardSpriteArray = sprites = this.getSelectedHandSprites();
        int n = sprites.length;
        int n2 = 0;
        while (n2 < n) {
            CardSprite sprite = cardSpriteArray[n2];
            this.deselectHandSprite(sprite);
            ++n2;
        }
    }

    public void addHandSelectionObserver(CardSelectionObserver obs) {
        this._handSelectionObservers.add((Object)obs);
    }

    public void removeHandSelectionObserver(CardSelectionObserver obs) {
        this._handSelectionObservers.remove((Object)obs);
    }

    public void setHand(Hand hand, long fadeDuration) {
        this.clearHand();
        int size = hand.size();
        int ii = 0;
        while (ii < size) {
            CardSprite cs = new CardSprite(this, (Card)hand.get(ii));
            this._handSprites.add(cs);
            ++ii;
        }
        if (this.shouldSortHand()) {
            QuickSort.sort(this._handSprites, CARD_COMP);
        }
        long cardDuration = fadeDuration / (long)size;
        int ii2 = 0;
        while (ii2 < size) {
            CardSprite cs = this._handSprites.get(ii2);
            cs.setLocation(this.getHandX(size, ii2), this._handLocation.y);
            cs.setRenderOrder(ii2);
            cs.addSpriteObserver(this._handSpriteObserver);
            this.addSprite((Sprite)cs);
            cs.fadeIn((long)ii2 * cardDuration, cardDuration);
            ++ii2;
        }
        this.updateActiveCardSprite();
    }

    public void setHand(int size, long fadeDuration) {
        Hand hand = new Hand();
        int ii = 0;
        while (ii < size) {
            hand.add(null);
            ++ii;
        }
        this.setHand(hand, fadeDuration);
    }

    public void showHand(Hand hand) {
        if (this.shouldSortHand()) {
            QuickSort.sort((List)((Object)hand));
        }
        int len = Math.min(this._handSprites.size(), hand.size());
        int ii = 0;
        while (ii < len) {
            CardSprite cs = this._handSprites.get(ii);
            cs.setCard((Card)hand.get(ii));
            ++ii;
        }
    }

    public CardSprite getHandSprite(Card card) {
        return this.getCardSprite(this._handSprites, card);
    }

    public void clearHand() {
        this.clearHandSelection();
        this.clearSprites(this._handSprites);
    }

    public void clearBoard() {
        this.clearSprites(this._boardSprites);
    }

    public void flyFromHand(CardSprite[] cards, Point dest, long flightDuration, float fadePortion) {
        CardSprite[] cardSpriteArray = cards;
        int n = cards.length;
        int n2 = 0;
        while (n2 < n) {
            CardSprite card = cardSpriteArray[n2];
            this.removeFromHand(card);
            LinePath flight = new LinePath(dest, flightDuration);
            card.addSpriteObserver(this._pathEndRemover);
            card.moveAndFadeOut((Path)flight, flightDuration, fadePortion);
            ++n2;
        }
        this.adjustHand(flightDuration, false);
    }

    public void flyIntoHand(Card[] cards, Point src, long flightDuration, long pauseDuration, long dropDuration, float fadePortion) {
        CardSprite[] sprites = new CardSprite[cards.length];
        int ii = 0;
        while (ii < cards.length) {
            sprites[ii] = new CardSprite(this, cards[ii]);
            this._handSprites.add(sprites[ii]);
            ++ii;
        }
        this.adjustHand(flightDuration, true);
        int size = this._handSprites.size();
        CardSprite[] cardSpriteArray = sprites;
        int n = sprites.length;
        int n2 = 0;
        while (n2 < n) {
            CardSprite sprite = cardSpriteArray[n2];
            int idx = this._handSprites.indexOf((Object)sprite);
            sprite.setLocation(src.x, src.y);
            sprite.setRenderOrder(idx);
            sprite.addSpriteObserver(this._handSpriteObserver);
            this.addSprite((Sprite)sprite);
            ArrayList paths = Lists.newArrayList();
            Point hp2 = new Point(this.getHandX(size, idx), this._handLocation.y);
            Point hp1 = new Point(hp2.x, hp2.y - this._selectedCardOffset);
            paths.add(new LinePath(hp1, flightDuration));
            paths.add(new LinePath(hp1, pauseDuration));
            paths.add(new LinePath(hp2, dropDuration));
            sprite.moveAndFadeIn((Path)new PathSequence((List)paths), flightDuration + pauseDuration + dropDuration, fadePortion);
            ++n2;
        }
    }

    public void flyAcross(Card[] cards, Point src, Point dest, long flightDuration, long cardDelay, float fadePortion) {
        int ii = 0;
        while (ii < cards.length) {
            long pathDuration;
            LinePath path;
            CardSprite cs = new CardSprite(this, cards[ii]);
            cs.setRenderOrder(this.getHighestBoardLayer() + 1 + ii);
            cs.setLocation(src.x, src.y);
            this.addSprite((Sprite)cs);
            LinePath flight = new LinePath(dest, flightDuration);
            if (ii > 0) {
                long delayDuration = cardDelay * (long)ii;
                LinePath delay = new LinePath(src, delayDuration);
                path = new PathSequence((Path)delay, (Path)flight);
                pathDuration = delayDuration + flightDuration;
            } else {
                path = flight;
                pathDuration = flightDuration;
            }
            cs.addSpriteObserver(this._pathEndRemover);
            cs.moveAndFadeInAndOut((Path)path, pathDuration, fadePortion);
            ++ii;
        }
    }

    public void flyAcross(int number, Point src, Point dest, long flightDuration, long cardDelay, float fadePortion) {
        this.flyAcross(new Card[number], src, dest, flightDuration, cardDelay, fadePortion);
    }

    public void flyFromHandToBoard(CardSprite card, Point dest, long flightDuration) {
        LinePath flight = new LinePath(dest, flightDuration);
        card.move((Path)flight);
        this.lowerBoardSprites(card.getRenderOrder() - 1);
        this.removeFromHand(card);
        this._boardSprites.add(card);
        this.adjustHand(flightDuration, false);
    }

    public void flyToBoard(Card card, Point src, Point dest, long flightDuration, float fadePortion) {
        CardSprite cs = new CardSprite(this, card);
        cs.setRenderOrder(this.getHighestBoardLayer() + 1);
        cs.setLocation(src.x, src.y);
        this.addSprite((Sprite)cs);
        this._boardSprites.add(cs);
        LinePath flight = new LinePath(dest, flightDuration);
        cs.moveAndFadeIn((Path)flight, flightDuration, fadePortion);
    }

    public void addToBoard(Card card, Point dest) {
        CardSprite cs = new CardSprite(this, card);
        cs.setRenderOrder(this.getHighestBoardLayer() + 1);
        cs.setLocation(dest.x, dest.y);
        this.addSprite((Sprite)cs);
        this._boardSprites.add(cs);
    }

    public void flyFromBoard(CardSprite[] cards, Point dest, long flightDuration, float fadePortion) {
        CardSprite[] cardSpriteArray = cards;
        int n = cards.length;
        int n2 = 0;
        while (n2 < n) {
            CardSprite card = cardSpriteArray[n2];
            LinePath flight = new LinePath(dest, flightDuration);
            card.addSpriteObserver(this._pathEndRemover);
            card.moveAndFadeOut((Path)flight, flightDuration, fadePortion);
            this._boardSprites.remove((Object)card);
            ++n2;
        }
    }

    public void flyFromBoard(CardSprite[] cards, Point dest1, Point dest2, long flightDuration, float fadePortion) {
        CardSprite[] cardSpriteArray = cards;
        int n = cards.length;
        int n2 = 0;
        while (n2 < n) {
            CardSprite card = cardSpriteArray[n2];
            PathSequence flight = new PathSequence((Path)new LinePath(dest1, flightDuration / 2L), (Path)new LinePath(dest1, dest2, flightDuration / 2L));
            card.addSpriteObserver(this._pathEndRemover);
            card.moveAndFadeOut((Path)flight, flightDuration, fadePortion);
            this._boardSprites.remove((Object)card);
            ++n2;
        }
    }

    protected CardSprite getCardSprite(List<CardSprite> list, Card card) {
        int ii = 0;
        while (ii < list.size()) {
            CardSprite cs = list.get(ii);
            if (card.equals(cs.getCard())) {
                return cs;
            }
            ++ii;
        }
        return null;
    }

    protected boolean shouldSortHand() {
        return true;
    }

    protected void adjustHand(long adjustDuration, boolean updateLayers) {
        this.clearHandSelection();
        if (this.shouldSortHand()) {
            QuickSort.sort(this._handSprites, CARD_COMP);
        }
        int size = this._handSprites.size();
        int ii = 0;
        while (ii < size) {
            CardSprite cs = this._handSprites.get(ii);
            if (this.isManaged((Sprite)cs)) {
                if (updateLayers) {
                    cs.setRenderOrder(ii);
                }
                LinePath adjust = new LinePath(new Point(this.getHandX(size, ii), this._handLocation.y), adjustDuration);
                cs.move((Path)adjust);
            }
            ++ii;
        }
    }

    protected void removeFromHand(CardSprite card) {
        this._selectedHandSprites.remove((Object)card);
        this._handSprites.remove((Object)card);
    }

    protected void updateHandOffsets() {
        this.updateActiveCardSprite();
        int size = this._handSprites.size();
        int ii = 0;
        while (ii < size) {
            CardSprite cs = this._handSprites.get(ii);
            if (!cs.isMoving()) {
                cs.setLocation(cs.getX(), this.getHandY(cs));
            }
            ++ii;
        }
    }

    protected int getHandX(int size, int idx) {
        if (this._cardWidth == 0) {
            this._cardWidth = this.getCardBackImage().getWidth();
        }
        int width = (size - 1) * this._handSpacing + this._cardWidth;
        return this._handLocation.x - width / 2 + idx * this._handSpacing;
    }

    protected int getHandY(CardSprite sprite) {
        if (this._selectedHandSprites.contains((Object)sprite)) {
            return this._handLocation.y - this._selectedCardOffset;
        }
        if (this.isSelectable(sprite) && (sprite == this._activeCardSprite || this.isOnlySelectable(sprite))) {
            return this._handLocation.y - this._selectableCardOffset;
        }
        return this._handLocation.y;
    }

    protected boolean isSelectable(CardSprite sprite) {
        return this._handSelectionMode != 0 && (this._handSelectionPredicate == null || this._handSelectionPredicate.apply((Object)sprite));
    }

    protected boolean isOnlySelectable(CardSprite sprite) {
        if (this._handSelectionPredicate == null) {
            return this._handSprites.size() == 1 && this._handSprites.contains((Object)sprite);
        }
        for (CardSprite cs : this._handSprites) {
            if (cs == sprite || !this._handSelectionPredicate.apply((Object)cs)) continue;
            return false;
        }
        return true;
    }

    protected void lowerBoardSprites(int layer) {
        int highest = this.getHighestBoardLayer();
        if (highest <= layer) {
            return;
        }
        int size = this._boardSprites.size();
        int adjustment = layer - highest;
        int ii = 0;
        while (ii < size) {
            CardSprite cs = this._boardSprites.get(ii);
            cs.setRenderOrder(cs.getRenderOrder() + adjustment);
            ++ii;
        }
    }

    protected int getHighestBoardLayer() {
        int size = this._boardSprites.size();
        int highest = 0;
        int ii = 0;
        while (ii < size) {
            highest = Math.max(highest, this._boardSprites.get(ii).getRenderOrder());
            ++ii;
        }
        return highest;
    }

    protected void clearSprites(List<CardSprite> sprites) {
        Iterator<CardSprite> it = sprites.iterator();
        while (it.hasNext()) {
            this.removeSprite((Sprite)it.next());
            it.remove();
        }
    }

    protected void updateActiveCardSprite() {
        CardSprite newActiveCardSprite;
        if (this._mouseEvent == null) {
            return;
        }
        Sprite newHighestHit = this._spritemgr.getHighestHitSprite(this._mouseEvent.getX(), this._mouseEvent.getY());
        CardSprite cardSprite = newActiveCardSprite = newHighestHit instanceof CardSprite ? (CardSprite)newHighestHit : null;
        if (this._activeCardSprite != newActiveCardSprite) {
            if (this._activeCardSprite != null && this.isManaged((Sprite)this._activeCardSprite)) {
                this._activeCardSprite.queueNotification(new CardSpriteExitedOp(this._activeCardSprite, this._mouseEvent));
            }
            this._activeCardSprite = newActiveCardSprite;
            if (this._activeCardSprite != null) {
                this._activeCardSprite.queueNotification(new CardSpriteEnteredOp(this._activeCardSprite, this._mouseEvent));
            }
        }
    }

    protected void paintBehind(Graphics2D gfx, Rectangle dirtyRect) {
        gfx.setColor(DEFAULT_BACKGROUND);
        gfx.fill(dirtyRect);
        super.paintBehind(gfx, dirtyRect);
    }

    protected class CardListener
    extends MouseInputAdapter {
        protected int _handleX;
        protected int _handleY;
        protected boolean _hasBeenDragged;

        protected CardListener() {
        }

        public void mousePressed(MouseEvent me) {
            if (CardPanel.this._activeCardSprite != null && CardPanel.this.isManaged((Sprite)CardPanel.this._activeCardSprite)) {
                this._handleX = CardPanel.this._activeCardSprite.getX() - me.getX();
                this._handleY = CardPanel.this._activeCardSprite.getY() - me.getY();
                this._hasBeenDragged = false;
            }
        }

        public void mouseReleased(MouseEvent me) {
            if (CardPanel.this._activeCardSprite != null && CardPanel.this.isManaged((Sprite)CardPanel.this._activeCardSprite) && this._hasBeenDragged) {
                CardPanel.this._activeCardSprite.queueNotification(new CardSpriteDraggedOp(CardPanel.this._activeCardSprite, me));
            }
        }

        public void mouseClicked(MouseEvent me) {
            if (CardPanel.this._activeCardSprite != null && CardPanel.this.isManaged((Sprite)CardPanel.this._activeCardSprite)) {
                CardPanel.this._activeCardSprite.queueNotification(new CardSpriteClickedOp(CardPanel.this._activeCardSprite, me));
            }
        }

        public void mouseMoved(MouseEvent me) {
            CardPanel.this._mouseEvent = me;
            CardPanel.this.updateActiveCardSprite();
        }

        public void mouseDragged(MouseEvent me) {
            CardPanel.this._mouseEvent = me;
            if (CardPanel.this._activeCardSprite != null && CardPanel.this.isManaged((Sprite)CardPanel.this._activeCardSprite) && CardPanel.this._activeCardSprite.isDraggable()) {
                CardPanel.this._activeCardSprite.setLocation(me.getX() + this._handleX, me.getY() + this._handleY);
                this._hasBeenDragged = true;
            } else {
                CardPanel.this.updateActiveCardSprite();
            }
        }

        public void mouseEntered(MouseEvent me) {
            CardPanel.this._mouseEvent = me;
        }

        public void mouseExited(MouseEvent me) {
            CardPanel.this._mouseEvent = me;
        }
    }

    public static interface CardSelectionObserver {
        public void cardSpriteSelected(CardSprite var1);

        public void cardSpriteDeselected(CardSprite var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CardSpriteClickedOp
    implements ObserverList.ObserverOp<Object> {
        protected CardSprite _sprite;
        protected MouseEvent _me;

        public CardSpriteClickedOp(CardSprite sprite, MouseEvent me) {
            this._sprite = sprite;
            this._me = me;
        }

        public boolean apply(Object observer) {
            if (observer instanceof CardSpriteObserver) {
                ((CardSpriteObserver)observer).cardSpriteClicked(this._sprite, this._me);
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CardSpriteDraggedOp
    implements ObserverList.ObserverOp<Object> {
        protected CardSprite _sprite;
        protected MouseEvent _me;

        public CardSpriteDraggedOp(CardSprite sprite, MouseEvent me) {
            this._sprite = sprite;
            this._me = me;
        }

        public boolean apply(Object observer) {
            if (observer instanceof CardSpriteObserver) {
                ((CardSpriteObserver)observer).cardSpriteDragged(this._sprite, this._me);
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CardSpriteEnteredOp
    implements ObserverList.ObserverOp<Object> {
        protected CardSprite _sprite;
        protected MouseEvent _me;

        public CardSpriteEnteredOp(CardSprite sprite, MouseEvent me) {
            this._sprite = sprite;
            this._me = me;
        }

        public boolean apply(Object observer) {
            if (observer instanceof CardSpriteObserver) {
                ((CardSpriteObserver)observer).cardSpriteEntered(this._sprite, this._me);
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CardSpriteExitedOp
    implements ObserverList.ObserverOp<Object> {
        protected CardSprite _sprite;
        protected MouseEvent _me;

        public CardSpriteExitedOp(CardSprite sprite, MouseEvent me) {
            this._sprite = sprite;
            this._me = me;
        }

        public boolean apply(Object observer) {
            if (observer instanceof CardSpriteObserver) {
                ((CardSpriteObserver)observer).cardSpriteExited(this._sprite, this._me);
            }
            return true;
        }
    }

    protected class HandSpriteObserver
    extends PathAdapter
    implements CardSpriteObserver {
        protected HandSpriteObserver() {
        }

        public void pathCompleted(Sprite sprite, Path path, long when) {
            CardPanel.this.updateActiveCardSprite();
            this.maybeUpdateOffset((CardSprite)sprite);
        }

        public void cardSpriteClicked(CardSprite sprite, MouseEvent me) {
            if (CardPanel.this._selectedHandSprites.contains((Object)sprite) && CardPanel.this._handSelectionMode != 0) {
                CardPanel.this.deselectHandSprite(sprite);
            } else if (CardPanel.this._handSprites.contains((Object)sprite) && CardPanel.this.isSelectable(sprite)) {
                CardPanel.this.selectHandSprite(sprite);
            }
        }

        public void cardSpriteEntered(CardSprite sprite, MouseEvent me) {
            this.maybeUpdateOffset(sprite);
        }

        public void cardSpriteExited(CardSprite sprite, MouseEvent me) {
            this.maybeUpdateOffset(sprite);
        }

        public void cardSpriteDragged(CardSprite sprite, MouseEvent me) {
        }

        protected void maybeUpdateOffset(CardSprite sprite) {
            if (CardPanel.this._handSprites.contains((Object)sprite) && !sprite.isMoving()) {
                sprite.setLocation(sprite.getX(), CardPanel.this.getHandY(sprite));
            }
        }
    }
}

