/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.micasa.simulator.client;

import com.samskivert.swing.Controller;
import com.threerings.crowd.data.BodyObject;
import com.threerings.micasa.Log;
import com.threerings.micasa.simulator.client.SimulatorFrame;
import com.threerings.micasa.simulator.client.SimulatorService;
import com.threerings.micasa.simulator.data.SimulatorInfo;
import com.threerings.parlor.game.data.GameConfig;
import com.threerings.parlor.util.ParlorContext;
import com.threerings.presents.client.Client;
import com.threerings.presents.client.SessionObserver;
import java.awt.event.ActionEvent;

public class SimulatorController
extends Controller
implements SessionObserver {
    public static final String LOGOFF = "logoff";
    protected ParlorContext _ctx;
    protected SimulatorFrame _frame;
    protected SimulatorInfo _info;
    protected BodyObject _body;

    public SimulatorController(ParlorContext ctx, SimulatorFrame frame, SimulatorInfo info) {
        this._ctx = ctx;
        this._frame = frame;
        this._info = info;
        this._ctx.getClient().addClientObserver((SessionObserver)this);
    }

    public boolean handleAction(ActionEvent action) {
        String cmd = action.getActionCommand();
        if (cmd.equals(LOGOFF)) {
            this._ctx.getClient().logoff(true);
            return true;
        }
        Log.log.info((Object)("Unhandled action: " + action), new Object[0]);
        return false;
    }

    public void clientWillLogon(Client client) {
    }

    public void clientDidLogon(Client client) {
        Log.log.info((Object)("Client did logon [client=" + client + "]."), new Object[0]);
        this._body = (BodyObject)client.getClientObject();
        this.createGame(client);
    }

    public void createGame(Client client) {
        GameConfig config = null;
        try {
            config = (GameConfig)Class.forName(this._info.gameConfigClass).newInstance();
            SimulatorService sservice = (SimulatorService)client.requireService(SimulatorService.class);
            sservice.createGame(config, this._info.simClass, this._info.playerCount);
        }
        catch (Exception e) {
            Log.log.warning((Object)("Failed to instantiate game config [class=" + this._info.gameConfigClass + ", error=" + e + "]."), new Object[0]);
        }
    }

    public void clientObjectDidChange(Client client) {
        this._body = (BodyObject)client.getClientObject();
    }

    public void clientDidLogoff(Client client) {
        Log.log.info((Object)("Client did logoff [client=" + client + "]."), new Object[0]);
    }
}

