/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.micasa.lobby.table;

import com.threerings.crowd.data.BodyObject;
import com.threerings.micasa.Log;
import com.threerings.micasa.util.MiCasaContext;
import com.threerings.parlor.client.SeatednessObserver;
import com.threerings.parlor.client.TableDirector;
import com.threerings.parlor.data.Table;
import com.threerings.util.Name;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TableItem
extends JPanel
implements ActionListener,
SeatednessObserver {
    public Table table;
    protected MiCasaContext _ctx;
    protected Name _self;
    protected TableDirector _tdtr;
    protected JButton[] _seats;
    protected JButton _goButton;
    protected static final String JOIN_LABEL = "<join>";
    protected static final String LEAVE_LABEL = "<leave>";

    public TableItem(MiCasaContext ctx, TableDirector tdtr, Table table) {
        this._tdtr = tdtr;
        this._ctx = ctx;
        this._tdtr.addSeatednessObserver(this);
        this._self = ((BodyObject)ctx.getClient().getClientObject()).getVisibleName();
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel tlabel = new JLabel("Table " + table.tableId);
        gbc.gridwidth = 0;
        gbc.insets = new Insets(2, 0, 0, 0);
        this.add((Component)tlabel, gbc);
        int bcount = table.players.length;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(2, 0, 2, 0);
        this._seats = new JButton[bcount];
        int ii = 0;
        while (ii < bcount) {
            this._seats[ii] = new JButton(JOIN_LABEL);
            this._seats[ii].addActionListener(this);
            gbc.gridwidth = ii % 2 == 0 ? (ii == bcount - 1 ? 0 : 1) : 0;
            if (ii == bcount - 1) {
                gbc.insets = new Insets(2, 0, 4, 0);
            }
            this.add((Component)this._seats[ii], gbc);
            if (ii == 0) {
                this._goButton = new JButton("Go");
                this._goButton.setActionCommand("go");
                this._goButton.addActionListener(this);
                this.add((Component)this._goButton, gbc);
            }
            ++ii;
        }
        this.tableUpdated(table);
    }

    public void tableUpdated(Table table) {
        this.table = table;
        boolean isSeated = this._tdtr.isSeated();
        int slength = this._seats.length;
        int ii = 0;
        while (ii < slength) {
            if (table.players[ii] == null) {
                this._seats[ii].setText(JOIN_LABEL);
                this._seats[ii].setEnabled(!isSeated);
                this._seats[ii].setActionCommand("join");
            } else if (table.players[ii].equals((Object)this._self) && !table.inPlay()) {
                this._seats[ii].setText(LEAVE_LABEL);
                this._seats[ii].setEnabled(true);
                this._seats[ii].setActionCommand("leave");
            } else {
                this._seats[ii].setText(table.players[ii].toString());
                this._seats[ii].setEnabled(false);
            }
            ++ii;
        }
        this._goButton.setVisible(table.gameOid != -1);
    }

    public void tableRemoved() {
        this._tdtr.removeSeatednessObserver(this);
    }

    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals("join")) {
            int position = -1;
            int ii = 0;
            while (ii < this._seats.length) {
                if (this._seats[ii] == event.getSource()) {
                    position = ii;
                    break;
                }
                ++ii;
            }
            if (position == -1) {
                Log.log.warning((Object)("Unable to figure out what position a <join> click came from [event=" + event + "]."), new Object[0]);
            } else {
                this._tdtr.joinTable(this.table.tableId, position);
            }
        } else if (cmd.equals("leave")) {
            this._tdtr.leaveTable(this.table.tableId);
        } else if (cmd.equals("go")) {
            this._ctx.getLocationDirector().moveTo(this.table.gameOid);
        } else {
            Log.log.warning((Object)("Received unknown action [event=" + event + "]."), new Object[0]);
        }
    }

    public void seatednessDidChange(boolean isSeated) {
        this.tableUpdated(this.table);
        if (this._goButton.isVisible()) {
            this._goButton.setEnabled(!isSeated);
        }
    }
}

