//
// $Id$
//
// Vilya library - tools for developing networked games
// Copyright (C) 2002-2012 Three Rings Design, Inc., All Rights Reserved
// http://code.google.com/p/vilya/
//
// This library is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published
// by the Free Software Foundation; either version 2.1 of the License, or
// (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

package com.threerings.whirled.zone.peer.data;

import com.threerings.io.SimpleStreamableObject;

import com.threerings.util.Name;

import com.threerings.presents.dobj.DSet;

/**
 * Represents a zone hosted on some node.
 */
public class HostedZone extends SimpleStreamableObject
    implements DSet.Entry
{
    /** The unique ID for the zone in question. */
    public int zoneId;

    /** The name of the zone being hosted. */
    public Name name;

    public HostedZone ()
    {
    }

    public HostedZone (int zoneId, Name name)
    {
        this.zoneId = zoneId;
        this.name = name;
    }

    // from DSet.Entry
    public Comparable<?> getKey ()
    {
        return zoneId;
    }

}
