/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.whirled.server.persist;

import com.google.common.collect.Maps;
import com.samskivert.io.PersistenceException;
import com.samskivert.util.HashIntMap;
import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.whirled.data.SceneUpdate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SceneUpdateMarshaller {
    protected HashIntMap<Class<?>> _typeToClass = new HashIntMap();
    protected HashMap<Class<?>, Integer> _classToType = Maps.newHashMap();
    protected int _nextType = 0;

    public SceneUpdateMarshaller(Class<?> ... typesClasses) {
        Class<?>[] classArray = typesClasses;
        int n = typesClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            this.registerUpdateClass(c);
            ++n2;
        }
    }

    public int getUpdateType(SceneUpdate update) {
        return update == null ? -1 : this.getUpdateType(update.getClass());
    }

    public int getUpdateType(Class<?> typeClass) {
        Integer type = this._classToType.get(typeClass);
        return type == null ? -1 : type;
    }

    public Class<?> getUpdateClass(int type) {
        return (Class)this._typeToClass.get(type);
    }

    public byte[] persistUpdate(SceneUpdate update) throws PersistenceException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            update.persistTo(new ObjectOutputStream((OutputStream)out));
        }
        catch (IOException ioe) {
            throw new PersistenceException("Error serializing update " + update, (Exception)ioe);
        }
        return out.toByteArray();
    }

    public SceneUpdate decodeUpdate(int sceneId, int sceneVersion, int updateType, byte[] data) throws PersistenceException {
        String errmsg = null;
        Exception error = null;
        try {
            Class<?> updateClass = this.getUpdateClass(updateType);
            if (updateClass == null) {
                errmsg = "No class registered for update type [sceneId=" + sceneId + ", sceneVersion=" + sceneVersion + ", updateType=" + updateType + "].";
                throw new PersistenceException(errmsg);
            }
            SceneUpdate update = (SceneUpdate)updateClass.newInstance();
            update.init(sceneId, sceneVersion);
            ByteArrayInputStream bin = new ByteArrayInputStream(data);
            update.unpersistFrom(new ObjectInputStream((InputStream)bin));
            return update;
        }
        catch (IOException ioe) {
            error = ioe;
            errmsg = "Unable to decode update";
        }
        catch (ClassNotFoundException cnfe) {
            error = cnfe;
            errmsg = "Unable to instantiate update";
        }
        catch (InstantiationException ie) {
            error = ie;
            errmsg = "Unable to instantiate update";
        }
        catch (IllegalAccessException iae) {
            error = iae;
            errmsg = "Unable to instantiate update";
        }
        errmsg = String.valueOf(errmsg) + " [sceneId=" + sceneId + ", sceneVersion=" + sceneVersion + ", updateType=" + updateType + "].";
        throw new PersistenceException(errmsg, error);
    }

    protected void registerUpdateClass(Class<?> typeClass) {
        if (this._classToType.containsKey(typeClass)) {
            throw new IllegalArgumentException("Class already registered: " + typeClass);
        }
        int type = ++this._nextType;
        if (typeClass != null) {
            this._typeToClass.put(type, typeClass);
            this._classToType.put(typeClass, type);
        }
    }
}

