/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.whirled.zone.peer.server;

import com.google.inject.Inject;
import com.samskivert.util.ResultListener;
import com.samskivert.util.Tuple;
import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.server.LocationManager;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.data.InvocationException;
import com.threerings.presents.server.InvocationManager;
import com.threerings.whirled.server.SceneRegistry;
import com.threerings.whirled.zone.Log;
import com.threerings.whirled.zone.client.ZoneService;
import com.threerings.whirled.zone.data.ZoneSummary;
import com.threerings.whirled.zone.peer.data.HostedZone;
import com.threerings.whirled.zone.peer.server.PeeredZoneManager;
import com.threerings.whirled.zone.peer.server.ZonePeerManager;
import com.threerings.whirled.zone.server.ZoneManager;
import com.threerings.whirled.zone.server.ZoneMoveHandler;
import com.threerings.whirled.zone.server.ZoneRegistry;

public abstract class PeeredZoneRegistry
extends ZoneRegistry {
    protected ZonePeerManager _peerMgr;

    protected abstract PeerZoneMoveHandler createMoveHandler(LocationManager var1, ZoneManager var2, SceneRegistry var3, BodyObject var4, int var5, int var6, ZoneService.ZoneMoveListener var7);

    @Inject
    public PeeredZoneRegistry(InvocationManager invmgr, ZonePeerManager peerMgr) {
        super(invmgr);
        this._peerMgr = peerMgr;
    }

    public void registerZoneManager(int zoneType, ZoneManager manager) {
        if (!(manager instanceof PeeredZoneManager)) {
            throw new IllegalArgumentException("All ZoneManagers received by PeeredZoneRegistry must be PeeredZoneManagers");
        }
        super.registerZoneManager(zoneType, manager);
    }

    public PeeredZoneManager getZoneManager(int qualifiedZoneId) {
        return (PeeredZoneManager)super.getZoneManager(qualifiedZoneId);
    }

    public void moveTo(ClientObject caller, int zoneId, int sceneId, int sceneVer, ZoneService.ZoneMoveListener listener) throws InvocationException {
        if (!(caller instanceof BodyObject)) {
            Log.log.warning((Object)("Request to switch zones by non-BodyObject [clobj=" + caller.getClass() + "]."), new Object[0]);
            throw new InvocationException("m.internal_error");
        }
        BodyObject body = (BodyObject)caller;
        PeerZoneMoveHandler handler = this.createMoveHandler(this._locman, this.getZoneManager(zoneId), this._screg, body, sceneId, sceneVer, listener);
        this.resolvePeerZone(zoneId, handler);
    }

    public void resolveZone(int zoneId, ZoneManager.ResolutionListener listener) {
        PeeredZoneManager zmgr = this.getZoneManager(zoneId);
        if (zmgr == null) {
            Log.log.warning((Object)"Trying to resolve a zone for which we have no manager", new Object[]{"zoneId", zoneId});
            listener.zoneFailedToResolve(zoneId, new Exception("m.internal_error"));
        } else {
            zmgr.resolveZone(zoneId, listener);
        }
    }

    public void resolvePeerZone(int zoneId, PeerZoneResolutionListener listener) {
        Tuple<String, HostedZone> nodeInfo = this._peerMgr.getZoneHost(zoneId);
        if (nodeInfo != null) {
            if (this._peerMgr.getNodeObject().nodeName.equals(nodeInfo.left)) {
                this.resolveZone(zoneId, listener);
            } else {
                listener.zoneOnNode(nodeInfo);
            }
            return;
        }
        this.resolveNewZone(zoneId, listener);
    }

    protected void resolveNewZone(final int zoneId, final PeerZoneResolutionListener listener) {
        this._peerMgr.acquireLock(ZonePeerManager.getZoneLock(zoneId), (ResultListener)new ResultListener<String>(){

            public void requestCompleted(String nodeName) {
                PeeredZoneRegistry.this.resolveZoneForNode(zoneId, nodeName, listener);
            }

            public void requestFailed(Exception cause) {
                Log.log.warning((Object)"Failed to acquire zone resolution lock", new Object[]{"id", zoneId, cause});
                listener.zoneFailedToResolve(zoneId, cause);
            }
        });
    }

    protected void resolveZoneForNode(final int zoneId, String nodeName, final PeerZoneResolutionListener listener) {
        if (this._peerMgr.getNodeObject().nodeName.equals(nodeName)) {
            Log.log.debug((Object)"Got lock, resolving zone", new Object[]{"zoneId", zoneId});
            this.resolveZone(zoneId, new ZoneManager.ResolutionListener(){

                public void zoneWasResolved(ZoneSummary zonesum) {
                    this.releaseLock();
                    PeeredZoneRegistry.this._peerMgr.zoneDidStartup(zonesum.zoneId, zonesum.name);
                    PeerZoneShutdownListener shutdowner = new PeerZoneShutdownListener(){

                        public void zoneDidShutdown(int zoneId) {
                            (this).PeeredZoneRegistry.this._peerMgr.zoneDidShutdown(zoneId);
                        }
                    };
                    PeeredZoneRegistry.this.getZoneManager(zonesum.zoneId).setShutdownListener(zonesum.zoneId, shutdowner);
                    listener.zoneWasResolved(zonesum);
                }

                public void zoneFailedToResolve(int zoneId2, Exception reason) {
                    this.releaseLock();
                    listener.zoneFailedToResolve(zoneId2, reason);
                }

                protected void releaseLock() {
                    PeeredZoneRegistry.this._peerMgr.releaseLock(ZonePeerManager.getZoneLock(zoneId), (ResultListener)new ResultListener.NOOP());
                }
            });
        } else {
            Tuple<String, HostedZone> nodeInfo = this._peerMgr.getZoneHost(zoneId);
            if (nodeName == null || nodeInfo == null || !nodeName.equals(nodeInfo.left)) {
                Log.log.warning((Object)"Zone resolved on wacked-out node?", new Object[]{"zoneId", zoneId, "nodeName", nodeName, "nodeInfo", nodeInfo});
                listener.zoneFailedToResolve(zoneId, new Exception("Zone on bogus host node"));
            } else {
                listener.zoneOnNode(nodeInfo);
            }
        }
    }

    public void zoneDidShutdown(int zoneId) {
        this._peerMgr.zoneDidShutdown(zoneId);
    }

    public static abstract class PeerZoneMoveHandler
    extends ZoneMoveHandler
    implements PeerZoneResolutionListener {
        public PeerZoneMoveHandler(LocationManager locman, ZoneManager zmgr, SceneRegistry scReg, BodyObject body, int sceneId, int sceneVer, ZoneService.ZoneMoveListener listener) {
            super(locman, zmgr, scReg, body, sceneId, sceneVer, listener);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PeerZoneResolutionListener
    extends ZoneManager.ResolutionListener {
        public void zoneOnNode(Tuple<String, HostedZone> var1);
    }

    public static interface PeerZoneShutdownListener {
        public void zoneDidShutdown(int var1);
    }
}

