/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.whirled.tools.xml;

import com.google.common.collect.Maps;
import com.megginson.sax.DataWriter;
import com.threerings.tools.xml.NestableWriter;
import com.threerings.whirled.Log;
import com.threerings.whirled.data.AuxModel;
import com.threerings.whirled.data.SceneModel;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SceneWriter {
    public static final String OUTER_ELEMENT = "scene";
    protected Map<Class<?>, NestableWriter> _auxers = Maps.newHashMap();

    public void registerAuxWriter(Class<?> aclass, NestableWriter writer) {
        this._auxers.put(aclass, writer);
    }

    public void writeScene(File out, SceneModel model) throws IOException, SAXException {
        FileWriter fout = new FileWriter(out);
        DataWriter dout = new DataWriter((Writer)fout);
        dout.setIndentStep(2);
        dout.startDocument();
        this.writeSceneModel(model, dout);
        dout.endDocument();
        fout.close();
    }

    public void writeSceneModel(SceneModel model, DataWriter writer) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        this.addSceneAttributes(model, attrs);
        writer.startElement("", OUTER_ELEMENT, "", (Attributes)attrs);
        this.writeSceneData(model, writer);
        writer.endElement(OUTER_ELEMENT);
    }

    protected void addSceneAttributes(SceneModel model, AttributesImpl attrs) {
        attrs.addAttribute("", "name", "", "", model.name);
        attrs.addAttribute("", "version", "", "", Integer.toString(model.version));
    }

    protected void writeSceneData(SceneModel model, DataWriter writer) throws SAXException {
        AuxModel[] auxModelArray = model.auxModels;
        int n = model.auxModels.length;
        int n2 = 0;
        while (n2 < n) {
            AuxModel amodel = auxModelArray[n2];
            NestableWriter awriter = this._auxers.get(amodel.getClass());
            if (awriter != null) {
                awriter.write((Object)amodel, writer);
            } else {
                Log.log.warning((Object)("No writer registered for auxiliary scene model [mclass=" + amodel.getClass() + "]."), new Object[0]);
            }
            ++n2;
        }
    }
}

