/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.whirled.spot.tools.xml;

import com.megginson.sax.DataWriter;
import com.threerings.tools.xml.NestableWriter;
import com.threerings.whirled.spot.Log;
import com.threerings.whirled.spot.data.Location;
import com.threerings.whirled.spot.data.Portal;
import com.threerings.whirled.spot.data.SpotSceneModel;
import com.threerings.whirled.spot.tools.EditablePortal;
import java.lang.reflect.Field;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SpotSceneWriter
implements NestableWriter {
    public static final String OUTER_ELEMENT = "spot";

    public void write(Object object, DataWriter writer) throws SAXException {
        SpotSceneModel model = (SpotSceneModel)object;
        AttributesImpl attrs = new AttributesImpl();
        this.addSceneAttributes(model, attrs);
        writer.startElement("", OUTER_ELEMENT, "", (Attributes)attrs);
        this.writeSceneData(model, writer);
        writer.endElement(OUTER_ELEMENT);
    }

    protected void addSceneAttributes(SpotSceneModel model, AttributesImpl attrs) {
        if (model.defaultEntranceId != -1) {
            attrs.addAttribute("", "defaultEntranceId", "", "", String.valueOf(model.defaultEntranceId));
        }
    }

    protected void writeSceneData(SpotSceneModel model, DataWriter writer) throws SAXException {
        Portal[] portalArray = model.portals;
        int n = model.portals.length;
        int n2 = 0;
        while (n2 < n) {
            Portal portal = portalArray[n2];
            EditablePortal port = (EditablePortal)portal;
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "portalId", "", "", String.valueOf(port.portalId));
            this.addPortalLocationAttributes(port.loc, attrs);
            this.maybeAddAttr(attrs, "name", port.name);
            this.maybeAddAttr(attrs, "targetSceneName", port.targetSceneName);
            this.maybeAddAttr(attrs, "targetPortalName", port.targetPortalName);
            writer.emptyElement("", "portal", "", (Attributes)attrs);
            ++n2;
        }
    }

    protected void addPortalLocationAttributes(Location portalLoc, AttributesImpl attrs) {
        Field[] fields;
        Class<?> clazz = portalLoc.getClass();
        Field[] fieldArray = fields = clazz.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                attrs.addAttribute("", field.getName(), "", "", String.valueOf(field.get(portalLoc)));
            }
            catch (IllegalAccessException iae) {
                Log.log.warning((Object)("Unable to write portal field, skipping [field=" + field.getName() + ", e=" + iae + "]."), new Object[0]);
            }
            ++n2;
        }
    }

    protected void maybeAddAttr(AttributesImpl attrs, String name, String value) {
        if (value != null) {
            attrs.addAttribute("", name, "", "", value);
        }
    }
}

