/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.stage.tools.editor;

import com.threerings.miso.util.MisoUtil;
import com.threerings.stage.data.StageLocation;
import com.threerings.stage.data.StageScene;
import com.threerings.stage.tools.editor.EditorScenePanel;
import com.threerings.stage.tools.editor.util.ExtrasPainter;
import com.threerings.util.DirectionUtil;
import com.threerings.whirled.spot.data.Portal;
import com.threerings.whirled.spot.tools.EditablePortal;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.event.MouseInputAdapter;

public class PortalTool
extends MouseInputAdapter
implements ExtrasPainter {
    protected EditorScenePanel _panel;
    protected StageScene _scene;
    protected Point _center;
    protected EditablePortal _portal;

    public void init(EditorScenePanel panel, int centerx, int centery) {
        this._panel = panel;
        this._scene = this._panel.getScene();
        Point p = this._panel.getFullCoords(centerx, centery);
        this._portal = new EditablePortal();
        this._portal.loc = new StageLocation(p.x, p.y, 3);
        this._panel.addMouseListener(this);
        this._panel.addMouseMotionListener(this);
        this._panel.addExtrasPainter(this);
        this._center = this._panel.getScreenCoords(p.x, p.y);
        this.calculateOrientation(centerx, centery);
    }

    public void mouseDragged(MouseEvent event) {
        this.calculateOrientation(event.getX(), event.getY());
    }

    public void mouseReleased(MouseEvent event) {
        switch (event.getButton()) {
            case 1: {
                this.savePortal();
                this.dispose();
                break;
            }
            case 3: {
                this.dispose();
            }
        }
    }

    public void paintExtras(Graphics2D gfx) {
        this._panel.paintPortal(gfx, this._portal);
    }

    protected void calculateOrientation(int x, int y) {
        int norient = MisoUtil.getProjectedIsoDirection((int)x, (int)y, (int)this._center.x, (int)this._center.y);
        if ((norient = DirectionUtil.getOpposite((int)norient)) == -1) {
            norient = 3;
        }
        StageLocation loc = (StageLocation)this._portal.loc;
        if (norient != loc.orient) {
            loc.orient = (byte)norient;
            this._panel.repaint();
        }
    }

    protected void savePortal() {
        String dirname;
        byte orient = ((StageLocation)this._portal.loc).orient;
        String name = dirname = DirectionUtil.toString((int)orient).toLowerCase();
        int ii = 1;
        while (this.portalNameExists(name)) {
            name = String.valueOf(dirname) + ii;
            ++ii;
        }
        this._portal.name = name;
        this._portal.portalId = this._scene.getNextPortalId();
        this._scene.addPortal(this._portal);
        this._panel.editPortal(this._portal);
    }

    protected boolean portalNameExists(String name) {
        Iterator<Portal> iter = this._scene.getPortals();
        while (iter.hasNext()) {
            if (!((EditablePortal)iter.next()).name.equals(name)) continue;
            return true;
        }
        return false;
    }

    protected void dispose() {
        this._panel.removeMouseListener(this);
        this._panel.removeMouseMotionListener(this);
        this._panel.removeExtrasPainter(this);
    }
}

