/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.puzzle.drop.data;

import com.samskivert.util.StringUtil;
import com.threerings.puzzle.Log;
import com.threerings.puzzle.data.Board;
import com.threerings.puzzle.drop.data.DropPieceCodes;
import com.threerings.puzzle.drop.util.DropBoardUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;

public class DropBoard
extends Board
implements DropPieceCodes {
    public static final int RADIAL_ROTATION = 0;
    public static final int INPLACE_ROTATION = 1;
    public static final PieceOperation CLEAR_OP = new PieceOperation(){

        public boolean execute(DropBoard board, int col, int row) {
            board.setPiece(col, row, -1);
            return true;
        }
    };
    protected int[] _board;
    protected int _bwid;
    protected int _bhei;
    protected transient Rectangle _bounds;
    protected static final int[][][] ROTATE_DX;
    protected static final int[][][] ROTATE_DY;
    protected static final int[] ORIENT_WIDTHS;
    protected static final int[] ORIENT_HEIGHTS;
    protected static final int[] ORIENT_ORIGIN_DX;
    protected static final int[] ORIENT_ORIGIN_DY;
    protected static final int[] COERCE_DX;
    protected static final SetSegmentOperation _setSegmentOp;
    protected static final SetPieceOperation _setPieceOp;
    protected static final int DEFAULT_PAD_WIDTH = 3;

    static {
        int[][][] nArrayArray = new int[2][][];
        nArrayArray[0] = new int[][]{new int[4], new int[4]};
        int[][] nArrayArray2 = new int[2][];
        int[] nArray = new int[4];
        nArray[0] = -1;
        nArray[1] = 1;
        nArrayArray2[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = -1;
        nArray2[3] = 1;
        nArrayArray2[1] = nArray2;
        nArrayArray[1] = nArrayArray2;
        ROTATE_DX = nArrayArray;
        int[][][] nArrayArray3 = new int[2][][];
        nArrayArray3[0] = new int[][]{new int[4], new int[4]};
        int[][] nArrayArray4 = new int[2][];
        int[] nArray3 = new int[4];
        nArray3[0] = -1;
        nArray3[3] = 1;
        nArrayArray4[0] = nArray3;
        int[] nArray4 = new int[4];
        nArray4[2] = -1;
        nArray4[3] = 1;
        nArrayArray4[1] = nArray4;
        nArrayArray3[1] = nArrayArray4;
        ROTATE_DY = nArrayArray3;
        ORIENT_WIDTHS = new int[]{2, 1, 2, 1};
        ORIENT_HEIGHTS = new int[]{1, 2, 1, 2};
        int[] nArray5 = new int[4];
        nArray5[0] = -1;
        ORIENT_ORIGIN_DX = nArray5;
        int[] nArray6 = new int[4];
        nArray6[3] = 1;
        ORIENT_ORIGIN_DY = nArray6;
        int[] nArray7 = new int[3];
        nArray7[1] = 1;
        nArray7[2] = -1;
        COERCE_DX = nArray7;
        _setSegmentOp = new SetSegmentOperation();
        _setPieceOp = new SetPieceOperation();
    }

    public DropBoard() {
        this(null, 0, 0);
    }

    public DropBoard(int bwid, int bhei) {
        this(new int[bwid * bhei], bwid, bhei);
        this.fill(-1);
    }

    public DropBoard(int bwid, int bhei, int piece) {
        this(new int[bwid * bhei], bwid, bhei);
        this.fill(piece);
    }

    public DropBoard(int[] board, int bwid, int bhei) {
        this._board = board;
        this._bwid = bwid;
        this._bhei = bhei;
    }

    public int getWidth() {
        return this._bwid;
    }

    public int getHeight() {
        return this._bhei;
    }

    public int getPiece(int col, int row) {
        if (!this.inBounds(col, row)) {
            Log.log.warning((Object)"Requested piece from invalid coordinate", new Object[]{"col", col, "row", row, "width", this._bwid, "height", this._bhei});
        }
        try {
            return this._board[this.coordsToIndex(col, row)];
        }
        catch (Exception e) {
            Log.log.warning((Object)"Failed getting piece", new Object[]{"col", col, "row", row, e});
            return -1;
        }
    }

    public int getNextPiece() {
        return -1;
    }

    public int getDropDistance(int col, int row) {
        int dist = 0;
        int yy = row + 1;
        while (yy < this._bhei) {
            if (this.getPiece(col, yy) != -1) {
                return dist;
            }
            ++dist;
            ++yy;
        }
        return dist;
    }

    public boolean isRowEmpty(int row) {
        int col = 0;
        while (col < this._bwid) {
            if (this.getPiece(col, row) != -1) {
                return false;
            }
            ++col;
        }
        return true;
    }

    public boolean isValidDrop(int[] rows, int[] cols, float pctdone) {
        int bottom = this._bhei - 1;
        int ii = 0;
        while (ii < rows.length) {
            if (rows[ii] >= bottom) {
                return false;
            }
            int row = rows[ii] + 1;
            if (row >= 0 && this.getPiece(cols[ii], row) != -1) {
                return false;
            }
            ++ii;
        }
        return true;
    }

    public boolean inBounds(int col, int row) {
        return col >= 0 && row >= 0 && col < this.getWidth() && row < this.getHeight();
    }

    public boolean isBlockEmpty(int col, int row, int wid, int hei) {
        int ypos = row;
        while (ypos > row - hei) {
            int xpos = col;
            while (xpos < col + wid) {
                if (ypos < 0) {
                    if (xpos < 0 || xpos >= this._bwid || this.getPiece(xpos, 0) != -1) {
                        return false;
                    }
                } else {
                    if (xpos < 0 || xpos >= this._bwid || ypos >= this._bhei) {
                        return false;
                    }
                    if (this.getPiece(xpos, ypos) != -1) {
                        return false;
                    }
                }
                ++xpos;
            }
            --ypos;
        }
        return true;
    }

    public int[] getForgivingRotation(int[] rows, int[] cols, int orient, int dir, int rtype, float pctdone, boolean canPopup) {
        int px = cols[0];
        int py = rows[0];
        int ii = 0;
        while (ii < 4) {
            int oidx = orient / 2;
            px += ROTATE_DX[rtype][dir][oidx];
            py += ROTATE_DY[rtype][dir][oidx];
            orient = DropBoardUtil.getRotatedOrientation(orient, dir);
            oidx = orient / 2;
            int ox = px + ORIENT_ORIGIN_DX[oidx];
            int oy = py + ORIENT_ORIGIN_DY[oidx];
            if ((double)pctdone > 0.5) {
                ++oy;
            }
            int[] nArray = COERCE_DX;
            int n = COERCE_DX.length;
            int n2 = 0;
            while (n2 < n) {
                int cx = nArray[n2];
                if (this.isBlockEmpty(ox + cx, oy, ORIENT_WIDTHS[oidx], ORIENT_HEIGHTS[oidx])) {
                    int[] nArray2 = new int[4];
                    nArray2[0] = orient;
                    nArray2[1] = px + cx;
                    nArray2[2] = py;
                    return nArray2;
                }
                ++n2;
            }
            if (canPopup && rtype == 0 && orient == 7 && this.isBlockEmpty(ox, oy - 1, ORIENT_WIDTHS[oidx], ORIENT_HEIGHTS[oidx])) {
                return new int[]{orient, px, py - 1, 1};
            }
            ++ii;
        }
        Log.log.warning((Object)"**** We're horked and couldn't rotate at all!", new Object[0]);
        return null;
    }

    public Point getForgivingMove(int col, int row, int wid, int hei, int dx, int dy, float pctdone) {
        int xpos = col + dx;
        int ypos = row + dy;
        if ((double)pctdone >= 0.5) {
            ++ypos;
        }
        return this.isBlockEmpty(xpos, ypos, wid, hei) ? new Point(xpos, row + dy) : null;
    }

    public void getColumnLevels(byte[] columns) {
        int bwid = this.getWidth();
        int bhei = this.getHeight();
        int col = 0;
        while (col < bwid) {
            int dist = this.getDropDistance(col, -1);
            columns[col] = (byte)(bhei - dist);
            ++col;
        }
    }

    public void applyRisingPieces(int[] pieces) {
        int xx;
        int end = this._bhei - 1;
        int yy = 0;
        while (yy < end) {
            xx = 0;
            while (xx < this._bwid) {
                this.setPiece(xx, yy, this.getPiece(xx, yy + 1));
                ++xx;
            }
            ++yy;
        }
        int ypos = this._bhei - 1;
        xx = 0;
        while (xx < this._bwid) {
            this.setPiece(xx, ypos, pieces[xx]);
            ++xx;
        }
    }

    public boolean rowContainsPieces(int row, int blankPiece) {
        int x = 0;
        while (x < this._bwid) {
            if (this.getPiece(x, row) != blankPiece) {
                return true;
            }
            ++x;
        }
        return false;
    }

    public void fill(int piece) {
        Arrays.fill(this._board, piece);
    }

    public boolean setPiece(int col, int row, int piece) {
        if (col >= 0 && row >= 0 && col < this._bwid && row < this._bhei) {
            this._board[this.coordsToIndex((int)col, (int)row)] = piece;
            return true;
        }
        Log.log.warning((Object)"Attempt to set piece outside board bounds", new Object[]{"col", col, "row", row, "p", piece});
        return false;
    }

    public void setRect(int x, int y, int width, int height, int piece) {
        int yy = y;
        while (yy > y - height) {
            int xx = x;
            while (xx < x + width) {
                this.setPiece(xx, yy, piece);
                ++xx;
            }
            --yy;
        }
    }

    public boolean setSegment(int dir, int col, int row, int len, int piece) {
        _setPieceOp.init(piece);
        this.applyOp(dir, col, row, len, _setPieceOp);
        return !_setPieceOp.getError();
    }

    public void setSegment(int dir, int col, int row, int[] pieces) {
        _setSegmentOp.init(dir, pieces);
        this.applyOp(dir, col, row, pieces.length, _setSegmentOp);
    }

    public void applyOp(int dir, int col, int row, PieceOperation op) {
        int len = dir == 0 ? this._bwid - col : row + 1;
        this.applyOp(dir, col, row, len, op);
    }

    public void applyOp(int dir, int col, int row, int len, PieceOperation op) {
        if (dir == 0) {
            int end = Math.min(col + len, this._bwid);
            int ii = col;
            while (ii < end) {
                if (op.execute(this, ii, row)) {
                    ++ii;
                    continue;
                }
                break;
            }
        } else {
            int end = Math.max(row - len, -1);
            int ii = row;
            while (ii > end) {
                if (op.execute(this, col, ii)) {
                    --ii;
                    continue;
                }
                break;
            }
        }
    }

    public void applyOp(int col, int row, PieceOperation op) {
        op.execute(this, col, row);
    }

    public void dump() {
        this.dumpAndCompare(null);
    }

    public void dumpAndCompare(Board other) {
        if (other != null && !(other instanceof DropBoard)) {
            throw new IllegalArgumentException("Can't compare drop board to non-drop-board.");
        }
        DropBoard dother = (DropBoard)other;
        int padwid = this.getPadWidth();
        if (other != null) {
            padwid *= 2;
        }
        int y = 0;
        while (y < this._bhei) {
            StringBuilder buf = new StringBuilder();
            int x = 0;
            while (x < this._bwid) {
                int opiece;
                int piece = this.getPiece(x, y);
                String str = this.formatPiece(piece);
                if (dother != null && (opiece = dother.getPiece(x, y)) != piece) {
                    str = String.valueOf(str) + "|" + this.formatPiece(opiece);
                }
                buf.append(StringUtil.pad((String)str, (int)padwid));
                ++x;
            }
            System.err.println(buf.toString());
            ++y;
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[wid=").append(this._bwid);
        buf.append(", hei=").append(this._bhei);
        return buf.append("]").toString();
    }

    public boolean equals(Board other) {
        if (!this.getClass().getName().equals(other.getClass().getName())) {
            throw new IllegalArgumentException("Can't compare board of different class types [src=" + this.getClass().getName() + ", other=" + other.getClass().getName() + "].");
        }
        DropBoard dother = (DropBoard)other;
        if (dother.getWidth() != this._bwid || dother.getHeight() != this._bhei) {
            return false;
        }
        int xx = 0;
        while (xx < this._bwid) {
            int yy = 0;
            while (yy < this._bhei) {
                if (this.getPiece(xx, yy) != dother.getPiece(xx, yy)) {
                    return false;
                }
                ++yy;
            }
            ++xx;
        }
        return true;
    }

    public boolean isValidPosition(int x, int y) {
        return x >= 0 && y >= 0 && x < this._bwid && y < this._bhei;
    }

    public Rectangle getBounds() {
        if (this._bounds == null) {
            this._bounds = new Rectangle(0, 0, this._bwid, this._bhei);
        }
        return this._bounds;
    }

    public int size() {
        return this._bwid * this._bhei;
    }

    public void copyInto(DropBoard board) {
        if (board.getWidth() != this._bwid || board.getHeight() != this._bhei) {
            Log.log.warning((Object)"Can't copy board into destination board with different dimensions", new Object[]{"src", this, "dest", board});
            return;
        }
        int[] dest = board.getBoard();
        System.arraycopy(this._board, 0, dest, 0, this._bwid * this._bhei);
    }

    public int[] getBoard() {
        return this._board;
    }

    public void setBoard(int[] board, int bwid, int bhei) {
        this._board = board;
        this._bwid = bwid;
        this._bhei = bhei;
    }

    public void setBoard(int[] board) {
        int size = this.size();
        if (board.length < size) {
            Log.log.warning((Object)"Attempt to set board with invalid data size", new Object[]{"len", board.length, "expected", size});
            return;
        }
        this._board = board;
    }

    public DropBoard clone() {
        DropBoard board = (DropBoard)super.clone();
        board._board = (int[])this._board.clone();
        return board;
    }

    protected int coordsToIndex(int col, int row) {
        return row * this._bwid + col;
    }

    protected int indexToCol(int idx) {
        return idx % this._bwid;
    }

    protected int indexToRow(int idx) {
        return idx / this._bwid;
    }

    protected int getPadWidth() {
        return 3;
    }

    protected String formatPiece(int piece) {
        return piece == -1 ? "." : String.valueOf(piece);
    }

    public static interface PieceOperation {
        public boolean execute(DropBoard var1, int var2, int var3);
    }

    protected static class SetPieceOperation
    implements PieceOperation {
        protected int _piece;
        protected boolean _error;

        protected SetPieceOperation() {
        }

        public void init(int piece) {
            this._piece = piece;
            this._error = false;
        }

        public boolean getError() {
            return this._error;
        }

        public boolean execute(DropBoard board, int col, int row) {
            if (!board.setPiece(col, row, this._piece)) {
                this._error = true;
            }
            return true;
        }
    }

    protected static class SetSegmentOperation
    implements PieceOperation {
        protected int _dir;
        protected int _idx;
        protected int[] _pieces;

        protected SetSegmentOperation() {
        }

        public void init(int dir, int[] pieces) {
            this._dir = dir;
            this._pieces = pieces;
            this._idx = dir == 0 ? this._pieces.length - 1 : 0;
        }

        public boolean execute(DropBoard board, int col, int row) {
            if (this._dir == 0) {
                board.setPiece(col, row, this._pieces[this._idx--]);
            } else {
                board.setPiece(col, row, this._pieces[this._idx++]);
            }
            return true;
        }
    }
}

