/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.parlor.util;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.samskivert.swing.Controller;
import com.samskivert.util.Interval;
import com.samskivert.util.RandomUtil;
import com.threerings.util.KeyTranslator;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;

public class RobotPlayer
extends Interval {
    protected static final long DEFAULT_ROBOT_DELAY = 500L;
    protected boolean _active = false;
    protected long _robotDelay = 500L;
    protected List<String> _press = Lists.newArrayList();
    protected List<String> _release = Lists.newArrayList();
    protected KeyTranslator _xlate;
    protected Component _target;

    public RobotPlayer(Component target, KeyTranslator xlate) {
        super(Interval.RUN_DIRECT);
        this._target = target;
        this._xlate = xlate;
        Iterators.addAll(this._press, (Iterator)this._xlate.enumeratePressCommands());
        Iterators.addAll(this._release, (Iterator)this._xlate.enumerateReleaseCommands());
    }

    public void setActive(boolean active) {
        if (active != this._active) {
            if (active) {
                this.schedule(this._robotDelay, true);
            } else {
                this.cancel();
            }
            this._active = active;
        }
    }

    public void setRobotDelay(long delay) {
        this._robotDelay = delay;
        if (this.isActive()) {
            this.setActive(false);
            this.setActive(true);
        }
    }

    public boolean isActive() {
        return this._active;
    }

    public void expired() {
        int idx = RandomUtil.getInt((int)this._press.size());
        String command = this._press.get(idx);
        Controller.postAction((Component)this._target, (String)command);
    }
}

