/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.parlor.rating.server;

import com.samskivert.util.StringUtil;
import com.threerings.media.util.MathUtil;
import com.threerings.parlor.rating.data.RatingCodes;

public class Rating
implements RatingCodes {
    public int rating = 1200;
    public int experience;

    public static int computeRating(Rating[] ratings, int pidx, float W) {
        float dR = 0.0f;
        int opponents = 0;
        int ii = 0;
        while (ii < ratings.length) {
            Rating orating = ratings[ii];
            if (pidx != ii && orating != null) {
                int opprat = ratings[ii].rating;
                if (!ratings[pidx].isProvisional() && ratings[ii].isProvisional()) {
                    opprat = Math.min(opprat, 1200);
                }
                dR += Rating.computeAdjustment(W, opprat, ratings[pidx]);
                ++opponents;
            }
            ++ii;
        }
        if (opponents == 0) {
            return -1;
        }
        int nrat = Math.round((float)ratings[pidx].rating + dR / (float)opponents);
        return MathUtil.bound((int)1000, (int)nrat, (int)3000);
    }

    public static float computeAdjustment(float W, int opprat, Rating rating) {
        float dR = opprat - rating.rating;
        float We = 1.0f / (float)(Math.pow(10.0, dR / 400.0f) + 1.0);
        int K = rating.isProvisional() ? 64 : (rating.rating < 2100 ? 32 : (rating.rating < 2400 ? 24 : 16));
        return (float)K * (W - We);
    }

    public boolean isProvisional() {
        return this.experience < 20;
    }

    public String toString() {
        return StringUtil.fieldsToString((Object)this);
    }
}

