/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.parlor.card.trick.server;

import com.google.common.collect.Lists;
import com.samskivert.util.ArrayUtil;
import com.samskivert.util.Interval;
import com.samskivert.util.RandomUtil;
import com.samskivert.util.RunQueue;
import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.data.PlaceConfig;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.crowd.server.PlaceManager;
import com.threerings.parlor.card.Log;
import com.threerings.parlor.card.data.Card;
import com.threerings.parlor.card.data.CardGameObject;
import com.threerings.parlor.card.data.Deck;
import com.threerings.parlor.card.data.Hand;
import com.threerings.parlor.card.data.PlayerCard;
import com.threerings.parlor.card.server.CardGameManager;
import com.threerings.parlor.card.trick.data.TrickCardGameMarshaller;
import com.threerings.parlor.card.trick.data.TrickCardGameObject;
import com.threerings.parlor.card.trick.server.TrickCardGameProvider;
import com.threerings.parlor.turn.server.TurnGameManagerDelegate;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.RootDObjectManager;
import com.threerings.presents.server.InvocationManager;
import com.threerings.util.Name;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TrickCardGameManagerDelegate
extends TurnGameManagerDelegate
implements TrickCardGameProvider {
    protected Interval _turnTimeoutInterval;
    protected Interval _endTrickInterval;
    protected CardGameManager _cgmgr;
    protected TrickCardGameObject _trickCardGame;
    protected CardGameObject _cardGame;
    protected long _endTrickDelay;
    protected Deck _deck;
    protected Hand[] _hands;
    protected boolean _turnTimedOut;
    protected static final float TURN_DURATION_SCALE_REDUCTION = 0.25f;
    protected static final float TURN_DURATION_SCALE_INCREASE = 0.5f;
    protected static final float MINIMUM_TURN_DURATION_SCALE = 0.1f;

    public TrickCardGameManagerDelegate() {
    }

    @Deprecated
    public TrickCardGameManagerDelegate(CardGameManager manager) {
    }

    public void init(PlaceManager plmgr, RootDObjectManager omgr, InvocationManager invmgr) {
        super.init(plmgr, omgr, invmgr);
        this._turnTimeoutInterval = new Interval((RunQueue)this._omgr){

            public void expired() {
                TrickCardGameManagerDelegate.this._turnTimedOut = true;
                TrickCardGameManagerDelegate.this.turnTimedOut();
            }
        };
        this._endTrickInterval = new Interval((RunQueue)this._omgr){

            public void expired() {
                TrickCardGameManagerDelegate.this.endTrick();
            }
        };
    }

    public void didInit(PlaceConfig config) {
        super.didInit(config);
        this._cgmgr = (CardGameManager)this._plmgr;
    }

    public void didStartup(PlaceObject plobj) {
        super.didStartup(plobj);
        this._deck = new Deck();
        this._trickCardGame = (TrickCardGameObject)plobj;
        this._cardGame = (CardGameObject)plobj;
        this._trickCardGame.setTrickCardGameService((TrickCardGameMarshaller)this.addProvider(this, TrickCardGameMarshaller.class));
    }

    public void gameWillStart() {
        super.gameWillStart();
        this._trickCardGame.setLastCardsPlayed(null);
        float[] scales = new float[this._cardGame.getPlayerCount()];
        Arrays.fill(scales, 1.0f);
        this._trickCardGame.setTurnDurationScales(scales);
    }

    public void gameDidStart() {
        super.gameDidStart();
        this.startHand();
    }

    public void gameDidEnd() {
        super.gameDidEnd();
        this._turnTimeoutInterval.cancel();
        this._endTrickInterval.cancel();
        if (this._trickCardGame.getTrickState() != 0) {
            this._trickCardGame.setTrickState(0);
        }
        this._trickCardGame.setRematchRequests(new int[this._cardGame.getPlayerCount()]);
    }

    public void startTurn() {
        super.startTurn();
        this._turnTimedOut = false;
        this._turnTimeoutInterval.schedule(this._trickCardGame.getTurnDuration());
    }

    public void endTurn() {
        this._turnTimeoutInterval.cancel();
        if (this._turnTimedOut) {
            this.reduceTurnDurationScale(this._turnIdx);
        } else {
            this.increaseTurnDurationScale(this._turnIdx);
        }
        super.endTurn();
    }

    public void startHand() {
        this.handWillStart();
        this._trickCardGame.setTrickState(1);
        this.handDidStart();
    }

    public void endHand() {
        this.handWillEnd();
        this._trickCardGame.setTrickState(0);
        this.handDidEnd();
    }

    public void startTrick() {
        this.trickWillStart();
        this._trickCardGame.setTrickState(2);
        this.trickDidStart();
    }

    public void endTrick() {
        this.trickWillEnd();
        this._trickCardGame.setTrickState(1);
        this.trickDidEnd();
    }

    public void sendCardsToPlayer(ClientObject client, int toidx, Card[] cards) {
        int fromidx = this._cgmgr.getPlayerIndex(client);
        if (fromidx == -1) {
            Log.log.warning((Object)"Send request from non-player", new Object[]{"username", ((BodyObject)client).who(), "cards", cards});
            return;
        }
        if (!this._hands[fromidx].containsAll(cards)) {
            Log.log.warning((Object)"Tried to send cards not held", new Object[]{"username", ((BodyObject)client).who(), "cards", cards});
            return;
        }
        this.sendCardsToPlayer(fromidx, toidx, cards);
    }

    public void playCard(ClientObject client, Card card, int handSize) {
        if (this._trickCardGame.getTrickState() != 2) {
            return;
        }
        Name username = ((BodyObject)client).getVisibleName();
        if (!username.equals((Object)this._trickCardGame.getTurnHolder())) {
            return;
        }
        int pidx = this._cardGame.getPlayerIndex(username);
        if (this._hands[pidx].size() != handSize) {
            return;
        }
        if (!this._hands[pidx].contains(card)) {
            Log.log.warning((Object)"Tried to play card not held", new Object[]{"username", username, "card", card});
            return;
        }
        if (!this._trickCardGame.isCardPlayable(this._hands[pidx], card)) {
            Log.log.warning((Object)"Tried to play illegal card", new Object[]{"username", username, "card", card});
            return;
        }
        this.playCard(pidx, card);
    }

    public void requestRematch(ClientObject client) {
        if (this._cardGame.state != 2) {
            Log.log.warning((Object)("Tried to request rematch when game wasn't over [username=" + ((BodyObject)client).who() + "]."), new Object[0]);
            return;
        }
        int pidx = this._cgmgr.getPlayerIndex(client);
        if (pidx == -1) {
            Log.log.warning((Object)"Rematch request from non-player", new Object[]{"username", ((BodyObject)client).who()});
            return;
        }
        if (this._trickCardGame.getRematchRequests()[pidx] != 0) {
            Log.log.warning((Object)"Repeated rematch request", new Object[]{"username", ((BodyObject)client).who()});
            return;
        }
        int req = this.getRematchRequestCount() == 0 ? 1 : 2;
        this._trickCardGame.setRematchRequestsAt(req, pidx);
        if (this.getRematchRequestCount() == this._cardGame.getPlayerCount()) {
            this._cgmgr.rematchGame();
        }
    }

    protected void sendCardsToPlayer(int fromidx, int toidx, Card[] cards) {
        this._hands[fromidx].removeAll(cards);
        this._hands[toidx].addAll(cards);
        this._cgmgr.transferCardsBetweenPlayers(fromidx, toidx, cards);
    }

    protected void playCard(int pidx, Card card) {
        ((DObject)this._trickCardGame).startTransaction();
        try {
            this._hands[pidx].remove(card);
            PlayerCard[] cards = (PlayerCard[])ArrayUtil.append((Object[])this._trickCardGame.getCardsPlayed(), (Object)new PlayerCard(pidx, card));
            this._trickCardGame.setCardsPlayed(cards);
            this.endTurn();
            if (this._turnIdx == -1) {
                if (this._endTrickDelay == 0L) {
                    this.endTrick();
                } else {
                    this._endTrickInterval.schedule(this._endTrickDelay);
                }
            }
        }
        finally {
            ((DObject)this._trickCardGame).commitTransaction();
        }
    }

    protected int getRematchRequestCount() {
        int[] rematchRequests = this._trickCardGame.getRematchRequests();
        int count = 0;
        int[] nArray = rematchRequests;
        int n = rematchRequests.length;
        int n2 = 0;
        while (n2 < n) {
            int rematchRequest = nArray[n2];
            if (rematchRequest != 0) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    protected boolean isTrickComplete() {
        return this._trickCardGame.getCardsPlayed().length == this._cardGame.getPlayerCount();
    }

    protected void setFirstTurnHolder() {
        if (this._trickCardGame.getTrickState() == 2) {
            super.setFirstTurnHolder();
        } else {
            this._turnIdx = -1;
        }
    }

    protected void setNextTurnHolder() {
        if (this._trickCardGame.getTrickState() == 2 && !this.isTrickComplete()) {
            super.setNextTurnHolder();
        } else {
            this._turnIdx = -1;
        }
    }

    protected void turnTimedOut() {
        if (this._trickCardGame.getTrickState() == 2) {
            this.playCard(this._turnIdx, this.pickRandomPlayableCard(this._hands[this._turnIdx]));
        }
    }

    protected void reduceTurnDurationScale(int pidx) {
        float oldScale = this._trickCardGame.getTurnDurationScales()[pidx];
        float newScale = Math.max(oldScale - 0.25f, 0.1f);
        if (newScale != oldScale) {
            this._trickCardGame.setTurnDurationScalesAt(newScale, pidx);
        }
    }

    protected void increaseTurnDurationScale(int pidx) {
        float oldScale = this._trickCardGame.getTurnDurationScales()[pidx];
        float newScale = Math.min(oldScale + 0.5f, 1.0f);
        if (newScale != oldScale) {
            this._trickCardGame.setTurnDurationScalesAt(newScale, pidx);
        }
    }

    protected Card pickRandomPlayableCard(Hand hand) {
        ArrayList playableCards = Lists.newArrayList();
        int ii = 0;
        while (ii < hand.size()) {
            Card card = (Card)hand.get(ii);
            if (this._trickCardGame.isCardPlayable(hand, card)) {
                playableCards.add(card);
            }
            ++ii;
        }
        return (Card)RandomUtil.pickRandom((List)playableCards);
    }

    protected void handWillStart() {
    }

    protected void handDidStart() {
        this.prepareDeck();
        this.dealHands();
        this.startTrick();
    }

    protected void prepareDeck() {
        this._deck.reset(false);
        this._deck.shuffle();
    }

    protected void dealHands() {
        this._hands = this._cgmgr.dealHands(this._deck, this._deck.size() / this._cardGame.getPlayerCount());
    }

    protected void handWillEnd() {
    }

    protected void handDidEnd() {
        this.startHand();
    }

    protected void trickWillStart() {
        this._trickCardGame.setCardsPlayed(new PlayerCard[0]);
    }

    protected void trickDidStart() {
        this.setFirstTurnHolder();
        this.startTurn();
    }

    protected void trickWillEnd() {
    }

    protected void trickDidEnd() {
        this._trickCardGame.setLastCardsPlayed(this._trickCardGame.getCardsPlayed());
        this._trickCardGame.setCardsPlayed(null);
        if (this.anyHandsEmpty()) {
            this.endHand();
            return;
        }
        this.startTrick();
    }

    protected boolean anyHandsEmpty() {
        Hand[] handArray = this._hands;
        int n = this._hands.length;
        int n2 = 0;
        while (n2 < n) {
            Hand _hand = handArray[n2];
            if (_hand.isEmpty()) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

