/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.stats.data;

import com.samskivert.util.StringUtil;
import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.stats.data.SetStat;
import com.threerings.stats.data.Stat;
import com.threerings.util.StreamableArrayIntSet;
import java.io.IOException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntSetStat
extends SetStat<Integer> {
    protected int _maxSize;
    protected StreamableArrayIntSet _intSet = new StreamableArrayIntSet();
    protected static final int MAX_MAX_SIZE = 255;

    public IntSetStat() {
        this._maxSize = 255;
    }

    public IntSetStat(int maxSize) {
        this._maxSize = Math.min(maxSize, 255);
    }

    @Override
    public int size() {
        return this._intSet.size();
    }

    @Override
    public boolean contains(Integer key) {
        return this._intSet.contains((Object)key);
    }

    @Override
    public boolean add(Integer key) {
        boolean modified = this._intSet.size() < this._maxSize && this._intSet.add(key);
        this.setModified(this._modified || modified);
        return modified;
    }

    @Override
    public void persistTo(ObjectOutputStream out, Stat.AuxDataSource aux) throws IOException {
        out.writeByte(this._maxSize - 128);
        out.writeByte(this._intSet.size() - 128);
        Iterator i$ = this._intSet.iterator();
        while (i$.hasNext()) {
            int key = (Integer)i$.next();
            out.writeInt(key);
        }
    }

    @Override
    public void unpersistFrom(ObjectInputStream in, Stat.AuxDataSource aux) throws IOException, ClassNotFoundException {
        this._maxSize = in.readByte() + 128;
        int numValues = in.readByte() + 128;
        this._intSet = new StreamableArrayIntSet(numValues);
        for (int ii = 0; ii < numValues; ++ii) {
            this._intSet.add(in.readInt());
        }
    }

    @Override
    public String valueToString() {
        return StringUtil.toString((Object)this._intSet);
    }
}

