/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.puzzle.drop.server;

import com.threerings.crowd.data.PlaceConfig;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.puzzle.Log;
import com.threerings.puzzle.data.Board;
import com.threerings.puzzle.data.PuzzleCodes;
import com.threerings.puzzle.drop.data.DropBoard;
import com.threerings.puzzle.drop.data.DropCodes;
import com.threerings.puzzle.drop.data.DropConfig;
import com.threerings.puzzle.drop.data.DropLogic;
import com.threerings.puzzle.drop.util.PieceDropLogic;
import com.threerings.puzzle.drop.util.PieceDropper;
import com.threerings.puzzle.server.PuzzleManager;
import com.threerings.puzzle.server.PuzzleManagerDelegate;

public abstract class DropManagerDelegate
extends PuzzleManagerDelegate
implements PuzzleCodes,
DropCodes {
    protected DropBoard[] _dboards;
    protected DropConfig _dconfig;
    protected boolean _usedrop;
    protected boolean _userise;
    protected int _bwid;
    protected int _bhei;
    protected PieceDropper _dropper;
    protected static final int MAX_UPDATE_LOOPS = 100;

    @Deprecated
    public DropManagerDelegate(PuzzleManager puzmgr, DropLogic logic) {
        this(logic);
    }

    public DropManagerDelegate(DropLogic logic) {
        this._usedrop = logic.useBlockDropping();
        this._userise = logic.useBoardRising();
        if (this._usedrop && this._userise) {
            Log.log.warning((Object)"Can't use dropping blocks and board rising functionality simultaneously in a drop puzzle game! Falling back to straight dropping.", new Object[0]);
            this._userise = false;
        }
    }

    public void didInit(PlaceConfig config) {
        this._dconfig = (DropConfig)config;
        this._bwid = this._dconfig.getBoardWidth();
        this._bhei = this._dconfig.getBoardHeight();
        super.didInit(config);
    }

    public void didStartup(PlaceObject plobj) {
        super.didStartup(plobj);
        this._dboards = new DropBoard[this._puzmgr.getPlayerCount()];
        PieceDropLogic pdl = this.getPieceDropLogic();
        if (pdl != null) {
            this._dropper = this.getPieceDropper(pdl);
        }
    }

    public void gameWillStart() {
        super.gameWillStart();
        Board[] board = this._puzmgr.getBoards();
        for (int ii = 0; ii < this._puzmgr.getPlayerCount(); ++ii) {
            this._dboards[ii] = (DropBoard)board[ii];
        }
    }

    protected boolean dropPieces(DropBoard board) {
        return this._dropper.dropPieces(board, null) > 0;
    }

    protected PieceDropLogic getPieceDropLogic() {
        return null;
    }

    protected PieceDropper getPieceDropper(PieceDropLogic logic) {
        return new PieceDropper(logic);
    }

    protected void placedBlock(int pidx) {
    }
}

