/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.puzzle.drop.client;

import com.threerings.media.image.Mirage;
import com.threerings.puzzle.drop.client.DropBoardView;
import com.threerings.util.DirectionCodes;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;

public class NextBlockView
extends JComponent
implements DirectionCodes {
    protected DropBoardView _view;
    protected int[] _pieces;
    protected int _pwid;
    protected int _phei;
    protected int _orient;

    public NextBlockView(DropBoardView view, int pwid, int phei, int orient) {
        this._view = view;
        this._pwid = pwid;
        this._phei = phei;
        this._orient = orient;
        this.setOpaque(false);
    }

    public void setPieces(int[] pieces) {
        this._pieces = pieces;
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D gfx = (Graphics2D)g;
        if (this._pieces != null) {
            Dimension size = this.getSize();
            int xpos = this._orient == 1 ? 0 : size.width - this._pwid;
            int ypos = this._orient == 1 ? size.height - this._phei : 0;
            for (int _piece : this._pieces) {
                Mirage image = this._view.getPieceImage(_piece);
                image.paint(gfx, xpos, ypos);
                if (this._orient == 1) {
                    ypos -= this._phei;
                    continue;
                }
                xpos -= this._pwid;
            }
        }
    }

    public Dimension getPreferredSize() {
        int wid = this._orient == 1 ? this._pwid : 2 * this._pwid;
        int hei = this._orient == 1 ? 2 * this._phei : this._phei;
        return new Dimension(wid, hei);
    }
}

