/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.parlor.game.data;

import com.samskivert.util.StringUtil;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.util.Name;

public class GameObject
extends PlaceObject {
    public static final String STATE = "state";
    public static final String IS_RATED = "isRated";
    public static final String IS_PRIVATE = "isPrivate";
    public static final String PLAYERS = "players";
    public static final String WINNERS = "winners";
    public static final String SESSION_ID = "sessionId";
    public static final String PLAYER_STATUS = "playerStatus";
    public static final int PRE_GAME = 0;
    public static final int IN_PLAY = 1;
    public static final int GAME_OVER = 2;
    public static final int CANCELLED = 3;
    public static final int PLAYER_IN_PLAY = 0;
    public static final int PLAYER_LEFT_GAME = 1;
    public int state = 0;
    public boolean isRated;
    public boolean isPrivate;
    public Name[] players;
    public boolean[] winners;
    public int sessionId;
    public int[] playerStatus;

    public int getPlayerCount() {
        int count = 0;
        int size = this.players.length;
        for (int ii = 0; ii < size; ++ii) {
            if (this.players[ii] == null) continue;
            ++count;
        }
        return count;
    }

    public int getActivePlayerCount() {
        int count = 0;
        int size = this.players.length;
        for (int ii = 0; ii < size; ++ii) {
            if (!this.isActivePlayer(ii)) continue;
            ++count;
        }
        return count;
    }

    public boolean isActivePlayer(int pidx) {
        return this.isOccupiedPlayer(pidx) && (this.playerStatus == null || this.isActivePlayerStatus(this.playerStatus[pidx]));
    }

    public int getPlayerIndex(Name username) {
        int size = this.players == null ? 0 : this.players.length;
        for (int ii = 0; ii < size; ++ii) {
            if (this.players[ii] == null || !this.players[ii].equals((Object)username)) continue;
            return ii;
        }
        return -1;
    }

    public boolean isInPlay() {
        return this.state == 1;
    }

    public boolean isOccupiedPlayer(int pidx) {
        return pidx >= 0 && pidx < this.players.length && this.players[pidx] != null;
    }

    public boolean isWinner(int pidx) {
        return this.winners != null && this.winners[pidx];
    }

    public int getWinnerCount() {
        int count = 0;
        int size = this.winners == null ? 0 : this.winners.length;
        for (int ii = 0; ii < size; ++ii) {
            if (!this.winners[ii]) continue;
            ++count;
        }
        return count;
    }

    public boolean isDraw() {
        return this.getWinnerCount() == this.getPlayerCount();
    }

    public int getWinnerIndex() {
        int size = this.winners == null ? 0 : this.winners.length;
        for (int ii = 0; ii < size; ++ii) {
            if (!this.winners[ii]) continue;
            return ii;
        }
        return -1;
    }

    protected boolean isActivePlayerStatus(int playerStatus) {
        return playerStatus == 0;
    }

    protected void which(StringBuilder buf) {
        super.which(buf);
        StringUtil.toString((StringBuilder)buf, (Object)this.players);
        buf.append(":").append(this.state);
    }

    public void setState(int value) {
        int ovalue = this.state;
        this.requestAttributeChange(STATE, value, ovalue);
        this.state = value;
    }

    public void setIsRated(boolean value) {
        boolean ovalue = this.isRated;
        this.requestAttributeChange(IS_RATED, value, ovalue);
        this.isRated = value;
    }

    public void setIsPrivate(boolean value) {
        boolean ovalue = this.isPrivate;
        this.requestAttributeChange(IS_PRIVATE, value, ovalue);
        this.isPrivate = value;
    }

    public void setPlayers(Name[] value) {
        Name[] ovalue = this.players;
        this.requestAttributeChange(PLAYERS, value, ovalue);
        this.players = value == null ? null : (Name[])value.clone();
    }

    public void setPlayersAt(Name value, int index) {
        Name ovalue = this.players[index];
        this.requestElementUpdate(PLAYERS, index, value, ovalue);
        this.players[index] = value;
    }

    public void setWinners(boolean[] value) {
        boolean[] ovalue = this.winners;
        this.requestAttributeChange(WINNERS, value, ovalue);
        this.winners = value == null ? null : (boolean[])value.clone();
    }

    public void setWinnersAt(boolean value, int index) {
        boolean ovalue = this.winners[index];
        this.requestElementUpdate(WINNERS, index, value, ovalue);
        this.winners[index] = value;
    }

    public void setSessionId(int value) {
        int ovalue = this.sessionId;
        this.requestAttributeChange(SESSION_ID, value, ovalue);
        this.sessionId = value;
    }

    public void setPlayerStatus(int[] value) {
        int[] ovalue = this.playerStatus;
        this.requestAttributeChange(PLAYER_STATUS, value, ovalue);
        this.playerStatus = value == null ? null : (int[])value.clone();
    }

    public void setPlayerStatusAt(int value, int index) {
        int ovalue = this.playerStatus[index];
        this.requestElementUpdate(PLAYER_STATUS, index, value, ovalue);
        this.playerStatus[index] = value;
    }
}

